package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_FEATURE_SEQUENCE_RANGE category
 *  records information about properties pertaining to
 *  this structure sequence_range.
 *  
 * <pre>
 *  Example 1 - Secondary structure computed by program DSSP.
 *  <PDBx:pdbx_feature_sequence_rangeCategory>
 *  <PDBx:pdbx_feature_sequence_range id="1">
 *  <PDBx:seq_range_id>H1</PDBx:seq_range_id>
 *  <PDBx:feature_name>secondary structure</PDBx:feature_name>
 *  <PDBx:feature>4-helix (alpha-helix)</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>DSSP</PDBx:feature_assigned_by>
 *  <PDBx:feature_software_id>DSSP</PDBx:feature_software_id>
 *  </PDBx:pdbx_feature_sequence_range>
 *  <PDBx:pdbx_feature_sequence_range id="2">
 *  <PDBx:seq_range_id>T1</PDBx:seq_range_id>
 *  <PDBx:feature_name>secondary structure</PDBx:feature_name>
 *  <PDBx:feature>hydrogen-bonded turn in beta-ladder</PDBx:feature>
 *  <PDBx:feature_type>value</PDBx:feature_type>
 *  <PDBx:feature_assigned_by>DSSP</PDBx:feature_assigned_by>
 *  <PDBx:feature_software_id>DSSP</PDBx:feature_software_id>
 *  </PDBx:pdbx_feature_sequence_range>
 *  </PDBx:pdbx_feature_sequence_rangeCategory>
 * </pre>
 */
public class Pdbx_feature_sequence_range extends org.pdb.beans.Pdbx_feature_sequence_range implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_feature_sequence_range";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_feature_sequence_range()
	{
	}

	/** Full constructor */
	public Pdbx_feature_sequence_range(
		Datablock datablock,
		java.lang.String feature,
		java.lang.String feature_assigned_by,
		java.lang.String feature_citation_id,
		java.lang.String feature_identifier,
		java.lang.String feature_name,
		java.lang.String feature_software_id,
		java.lang.String feature_type,
		java.lang.String id_,
		java.lang.String seq_range_id)
	{
		this.datablock = datablock;
		this.feature = feature;
		this.feature_assigned_by = feature_assigned_by;
		this.feature_citation_id = feature_citation_id;
		this.feature_identifier = feature_identifier;
		this.feature_name = feature_name;
		this.feature_software_id = feature_software_id;
		this.feature_type = feature_type;
		this.id_ = id_;
		this.seq_range_id = seq_range_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_feature_sequence_range");
		sb.append("\n");
		if (feature != null)
		{
			sb.append("feature = ");
			sb.append(feature);
			sb.append('\n');
		}
		if (feature_assigned_by != null)
		{
			sb.append("feature_assigned_by = ");
			sb.append(feature_assigned_by);
			sb.append('\n');
		}
		if (feature_citation_id != null)
		{
			sb.append("feature_citation_id = ");
			sb.append(feature_citation_id);
			sb.append('\n');
		}
		if (feature_identifier != null)
		{
			sb.append("feature_identifier = ");
			sb.append(feature_identifier);
			sb.append('\n');
		}
		if (feature_name != null)
		{
			sb.append("feature_name = ");
			sb.append(feature_name);
			sb.append('\n');
		}
		if (feature_software_id != null)
		{
			sb.append("feature_software_id = ");
			sb.append(feature_software_id);
			sb.append('\n');
		}
		if (feature_type != null)
		{
			sb.append("feature_type = ");
			sb.append(feature_type);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (seq_range_id != null)
		{
			sb.append("seq_range_id = ");
			sb.append(seq_range_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		feature = null;
		feature_assigned_by = null;
		feature_citation_id = null;
		feature_identifier = null;
		feature_name = null;
		feature_software_id = null;
		feature_type = null;
		id_ = null;
		seq_range_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_feature_sequence_range)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_feature_sequence_range>\n");
			if (feature != null) ow.write(indent + " <PDBx:feature>" + feature + "</PDBx:feature>\n");
			if (feature_assigned_by != null) ow.write(indent + " <PDBx:feature_assigned_by>" + feature_assigned_by + "</PDBx:feature_assigned_by>\n");
			if (feature_citation_id != null) ow.write(indent + " <PDBx:feature_citation_id>" + feature_citation_id + "</PDBx:feature_citation_id>\n");
			if (feature_identifier != null) ow.write(indent + " <PDBx:feature_identifier>" + feature_identifier + "</PDBx:feature_identifier>\n");
			if (feature_name != null) ow.write(indent + " <PDBx:feature_name>" + feature_name + "</PDBx:feature_name>\n");
			if (feature_software_id != null) ow.write(indent + " <PDBx:feature_software_id>" + feature_software_id + "</PDBx:feature_software_id>\n");
			if (feature_type != null) ow.write(indent + " <PDBx:feature_type>" + feature_type + "</PDBx:feature_type>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (seq_range_id != null) ow.write(indent + " <PDBx:seq_range_id>" + seq_range_id + "</PDBx:seq_range_id>\n");
			ow.write(indent + "</PDBx:pdbx_feature_sequence_range>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
