package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_HELICAL_SYMMETRY category record details about the
 *  helical symmetry group associated with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_helical_symmetryCategory>
 *  <PDBx:pdbx_helical_symmetry entry_id="1ABC">
 *  <PDBx:number_of_operations>35</PDBx:number_of_operations>
 *  <PDBx:rotation_per_n_subunits>131.84</PDBx:rotation_per_n_subunits>
 *  <PDBx:rise_per_n_subunits>6.10</PDBx:rise_per_n_subunits>
 *  <PDBx:n_subunits_divisor>1</PDBx:n_subunits_divisor>
 *  <PDBx:dyad_axis>no</PDBx:dyad_axis>
 *  <PDBx:circular_symmetry>1</PDBx:circular_symmetry>
 *  </PDBx:pdbx_helical_symmetry>
 *  </PDBx:pdbx_helical_symmetryCategory>
 * </pre>
 */
public class Pdbx_helical_symmetry extends org.pdb.beans.Pdbx_helical_symmetry implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_helical_symmetry";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_helical_symmetry()
	{
	}

	/** Full constructor */
	public Pdbx_helical_symmetry(
		Datablock datablock,
		java.lang.Integer circular_symmetry,
		java.lang.String dyad_axis,
		java.lang.String entry_id,
		java.lang.Integer n_subunits_divisor,
		java.lang.Integer number_of_operations,
		java.lang.Float rise_per_n_subunits,
		java.lang.Float rotation_per_n_subunits)
	{
		this.datablock = datablock;
		this.circular_symmetry = circular_symmetry;
		this.dyad_axis = dyad_axis;
		this.entry_id = entry_id;
		this.n_subunits_divisor = n_subunits_divisor;
		this.number_of_operations = number_of_operations;
		this.rise_per_n_subunits = rise_per_n_subunits;
		this.rotation_per_n_subunits = rotation_per_n_subunits;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_helical_symmetry");
		sb.append("\n");
		if (circular_symmetry != null)
		{
			sb.append("circular_symmetry = ");
			sb.append(circular_symmetry);
			sb.append('\n');
		}
		if (dyad_axis != null)
		{
			sb.append("dyad_axis = ");
			sb.append(dyad_axis);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (n_subunits_divisor != null)
		{
			sb.append("n_subunits_divisor = ");
			sb.append(n_subunits_divisor);
			sb.append('\n');
		}
		if (number_of_operations != null)
		{
			sb.append("number_of_operations = ");
			sb.append(number_of_operations);
			sb.append('\n');
		}
		if (rise_per_n_subunits != null)
		{
			sb.append("rise_per_n_subunits = ");
			sb.append(rise_per_n_subunits);
			sb.append('\n');
		}
		if (rotation_per_n_subunits != null)
		{
			sb.append("rotation_per_n_subunits = ");
			sb.append(rotation_per_n_subunits);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		circular_symmetry = null;
		dyad_axis = null;
		entry_id = null;
		n_subunits_divisor = null;
		number_of_operations = null;
		rise_per_n_subunits = null;
		rotation_per_n_subunits = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_helical_symmetry)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_helical_symmetry>\n");
			if (circular_symmetry != null) ow.write(indent + " <PDBx:circular_symmetry>" + circular_symmetry + "</PDBx:circular_symmetry>\n");
			if (dyad_axis != null) ow.write(indent + " <PDBx:dyad_axis>" + dyad_axis + "</PDBx:dyad_axis>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (n_subunits_divisor != null) ow.write(indent + " <PDBx:n_subunits_divisor>" + n_subunits_divisor + "</PDBx:n_subunits_divisor>\n");
			if (number_of_operations != null) ow.write(indent + " <PDBx:number_of_operations>" + number_of_operations + "</PDBx:number_of_operations>\n");
			if (rise_per_n_subunits != null) ow.write(indent + " <PDBx:rise_per_n_subunits>" + rise_per_n_subunits + "</PDBx:rise_per_n_subunits>\n");
			if (rotation_per_n_subunits != null) ow.write(indent + " <PDBx:rotation_per_n_subunits>" + rotation_per_n_subunits + "</PDBx:rotation_per_n_subunits>\n");
			ow.write(indent + "</PDBx:pdbx_helical_symmetry>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
