package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  This section provides a tabulation of constraint data.
 *  This example uses the data from the MCP-1 structure determination. Remember
 *  this is a dimer so there are intersubunit constraints as well as intrasubunit
 *  constraints.
 *  <PDBx:pdbx_nmr_constraintsCategory>
 *  <PDBx:pdbx_nmr_constraints entry_id="1ABC">
 *  <PDBx:NOE_constraints_total>4458</PDBx:NOE_constraints_total>
 *  <PDBx:NOE_intraresidue_total_count>1144</PDBx:NOE_intraresidue_total_count>
 *  <PDBx:NOE_sequential_total_count>272</PDBx:NOE_sequential_total_count>
 *  <PDBx:NOE_medium_range_total_count>1004</PDBx:NOE_medium_range_total_count>
 *  <PDBx:NOE_long_range_total_count>1356</PDBx:NOE_long_range_total_count>
 *  <PDBx:protein_phi_angle_constraints_total_count>96</PDBx:protein_phi_angle_constraints_total_count>
 *  </PDBx:pdbx_nmr_constraints>
 *  </PDBx:pdbx_nmr_constraintsCategory>
 */
public class Pdbx_nmr_constraints extends org.pdb.beans.Pdbx_nmr_constraints implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_constraints";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_constraints()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_constraints(
		Datablock datablock,
		java.lang.Integer NA_alpha_angle_constraints_total_count,
		java.lang.Integer NA_beta_angle_constraints_total_count,
		java.lang.Integer NA_chi_angle_constraints_total_count,
		java.lang.Integer NA_delta_angle_constraints_total_count,
		java.lang.Integer NA_epsilon_angle_constraints_total_count,
		java.lang.Integer NA_gamma_angle_constraints_total_count,
		java.lang.Integer NA_other_angle_constraints_total_count,
		java.lang.Integer NA_sugar_pucker_constraints_total_count,
		java.lang.Integer NOE_constraints_total,
		java.lang.Integer NOE_interentity_total_count,
		java.lang.String NOE_interproton_distance_evaluation,
		java.lang.Integer NOE_intraresidue_total_count,
		java.lang.Integer NOE_long_range_total_count,
		java.lang.Integer NOE_medium_range_total_count,
		java.lang.String NOE_motional_averaging_correction,
		java.lang.String NOE_pseudoatom_corrections,
		java.lang.Integer NOE_sequential_total_count,
		java.lang.Integer disulfide_bond_constraints_total_count,
		java.lang.String entry_id,
		java.lang.Integer hydrogen_bond_constraints_total_count,
		java.lang.Integer protein_chi_angle_constraints_total_count,
		java.lang.Integer protein_other_angle_constraints_total_count,
		java.lang.Integer protein_phi_angle_constraints_total_count,
		java.lang.Integer protein_psi_angle_constraints_total_count)
	{
		this.datablock = datablock;
		this.NA_alpha_angle_constraints_total_count = NA_alpha_angle_constraints_total_count;
		this.NA_beta_angle_constraints_total_count = NA_beta_angle_constraints_total_count;
		this.NA_chi_angle_constraints_total_count = NA_chi_angle_constraints_total_count;
		this.NA_delta_angle_constraints_total_count = NA_delta_angle_constraints_total_count;
		this.NA_epsilon_angle_constraints_total_count = NA_epsilon_angle_constraints_total_count;
		this.NA_gamma_angle_constraints_total_count = NA_gamma_angle_constraints_total_count;
		this.NA_other_angle_constraints_total_count = NA_other_angle_constraints_total_count;
		this.NA_sugar_pucker_constraints_total_count = NA_sugar_pucker_constraints_total_count;
		this.NOE_constraints_total = NOE_constraints_total;
		this.NOE_interentity_total_count = NOE_interentity_total_count;
		this.NOE_interproton_distance_evaluation = NOE_interproton_distance_evaluation;
		this.NOE_intraresidue_total_count = NOE_intraresidue_total_count;
		this.NOE_long_range_total_count = NOE_long_range_total_count;
		this.NOE_medium_range_total_count = NOE_medium_range_total_count;
		this.NOE_motional_averaging_correction = NOE_motional_averaging_correction;
		this.NOE_pseudoatom_corrections = NOE_pseudoatom_corrections;
		this.NOE_sequential_total_count = NOE_sequential_total_count;
		this.disulfide_bond_constraints_total_count = disulfide_bond_constraints_total_count;
		this.entry_id = entry_id;
		this.hydrogen_bond_constraints_total_count = hydrogen_bond_constraints_total_count;
		this.protein_chi_angle_constraints_total_count = protein_chi_angle_constraints_total_count;
		this.protein_other_angle_constraints_total_count = protein_other_angle_constraints_total_count;
		this.protein_phi_angle_constraints_total_count = protein_phi_angle_constraints_total_count;
		this.protein_psi_angle_constraints_total_count = protein_psi_angle_constraints_total_count;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_constraints");
		sb.append("\n");
		if (NA_alpha_angle_constraints_total_count != null)
		{
			sb.append("NA_alpha-angle_constraints_total_count = ");
			sb.append(NA_alpha_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_beta_angle_constraints_total_count != null)
		{
			sb.append("NA_beta-angle_constraints_total_count = ");
			sb.append(NA_beta_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_chi_angle_constraints_total_count != null)
		{
			sb.append("NA_chi-angle_constraints_total_count = ");
			sb.append(NA_chi_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_delta_angle_constraints_total_count != null)
		{
			sb.append("NA_delta-angle_constraints_total_count = ");
			sb.append(NA_delta_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_epsilon_angle_constraints_total_count != null)
		{
			sb.append("NA_epsilon-angle_constraints_total_count = ");
			sb.append(NA_epsilon_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_gamma_angle_constraints_total_count != null)
		{
			sb.append("NA_gamma-angle_constraints_total_count = ");
			sb.append(NA_gamma_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_other_angle_constraints_total_count != null)
		{
			sb.append("NA_other-angle_constraints_total_count = ");
			sb.append(NA_other_angle_constraints_total_count);
			sb.append('\n');
		}
		if (NA_sugar_pucker_constraints_total_count != null)
		{
			sb.append("NA_sugar_pucker_constraints_total_count = ");
			sb.append(NA_sugar_pucker_constraints_total_count);
			sb.append('\n');
		}
		if (NOE_constraints_total != null)
		{
			sb.append("NOE_constraints_total = ");
			sb.append(NOE_constraints_total);
			sb.append('\n');
		}
		if (NOE_interentity_total_count != null)
		{
			sb.append("NOE_interentity_total_count = ");
			sb.append(NOE_interentity_total_count);
			sb.append('\n');
		}
		if (NOE_interproton_distance_evaluation != null)
		{
			sb.append("NOE_interproton_distance_evaluation = ");
			sb.append(NOE_interproton_distance_evaluation);
			sb.append('\n');
		}
		if (NOE_intraresidue_total_count != null)
		{
			sb.append("NOE_intraresidue_total_count = ");
			sb.append(NOE_intraresidue_total_count);
			sb.append('\n');
		}
		if (NOE_long_range_total_count != null)
		{
			sb.append("NOE_long_range_total_count = ");
			sb.append(NOE_long_range_total_count);
			sb.append('\n');
		}
		if (NOE_medium_range_total_count != null)
		{
			sb.append("NOE_medium_range_total_count = ");
			sb.append(NOE_medium_range_total_count);
			sb.append('\n');
		}
		if (NOE_motional_averaging_correction != null)
		{
			sb.append("NOE_motional_averaging_correction = ");
			sb.append(NOE_motional_averaging_correction);
			sb.append('\n');
		}
		if (NOE_pseudoatom_corrections != null)
		{
			sb.append("NOE_pseudoatom_corrections = ");
			sb.append(NOE_pseudoatom_corrections);
			sb.append('\n');
		}
		if (NOE_sequential_total_count != null)
		{
			sb.append("NOE_sequential_total_count = ");
			sb.append(NOE_sequential_total_count);
			sb.append('\n');
		}
		if (disulfide_bond_constraints_total_count != null)
		{
			sb.append("disulfide_bond_constraints_total_count = ");
			sb.append(disulfide_bond_constraints_total_count);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (hydrogen_bond_constraints_total_count != null)
		{
			sb.append("hydrogen_bond_constraints_total_count = ");
			sb.append(hydrogen_bond_constraints_total_count);
			sb.append('\n');
		}
		if (protein_chi_angle_constraints_total_count != null)
		{
			sb.append("protein_chi_angle_constraints_total_count = ");
			sb.append(protein_chi_angle_constraints_total_count);
			sb.append('\n');
		}
		if (protein_other_angle_constraints_total_count != null)
		{
			sb.append("protein_other_angle_constraints_total_count = ");
			sb.append(protein_other_angle_constraints_total_count);
			sb.append('\n');
		}
		if (protein_phi_angle_constraints_total_count != null)
		{
			sb.append("protein_phi_angle_constraints_total_count = ");
			sb.append(protein_phi_angle_constraints_total_count);
			sb.append('\n');
		}
		if (protein_psi_angle_constraints_total_count != null)
		{
			sb.append("protein_psi_angle_constraints_total_count = ");
			sb.append(protein_psi_angle_constraints_total_count);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		NA_alpha_angle_constraints_total_count = null;
		NA_beta_angle_constraints_total_count = null;
		NA_chi_angle_constraints_total_count = null;
		NA_delta_angle_constraints_total_count = null;
		NA_epsilon_angle_constraints_total_count = null;
		NA_gamma_angle_constraints_total_count = null;
		NA_other_angle_constraints_total_count = null;
		NA_sugar_pucker_constraints_total_count = null;
		NOE_constraints_total = null;
		NOE_interentity_total_count = null;
		NOE_interproton_distance_evaluation = null;
		NOE_intraresidue_total_count = null;
		NOE_long_range_total_count = null;
		NOE_medium_range_total_count = null;
		NOE_motional_averaging_correction = null;
		NOE_pseudoatom_corrections = null;
		NOE_sequential_total_count = null;
		disulfide_bond_constraints_total_count = null;
		entry_id = null;
		hydrogen_bond_constraints_total_count = null;
		protein_chi_angle_constraints_total_count = null;
		protein_other_angle_constraints_total_count = null;
		protein_phi_angle_constraints_total_count = null;
		protein_psi_angle_constraints_total_count = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_constraints)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_constraints>\n");
			if (NA_alpha_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_alpha-angle_constraints_total_count>" + NA_alpha_angle_constraints_total_count + "</PDBx:NA_alpha-angle_constraints_total_count>\n");
			if (NA_beta_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_beta-angle_constraints_total_count>" + NA_beta_angle_constraints_total_count + "</PDBx:NA_beta-angle_constraints_total_count>\n");
			if (NA_chi_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_chi-angle_constraints_total_count>" + NA_chi_angle_constraints_total_count + "</PDBx:NA_chi-angle_constraints_total_count>\n");
			if (NA_delta_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_delta-angle_constraints_total_count>" + NA_delta_angle_constraints_total_count + "</PDBx:NA_delta-angle_constraints_total_count>\n");
			if (NA_epsilon_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_epsilon-angle_constraints_total_count>" + NA_epsilon_angle_constraints_total_count + "</PDBx:NA_epsilon-angle_constraints_total_count>\n");
			if (NA_gamma_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_gamma-angle_constraints_total_count>" + NA_gamma_angle_constraints_total_count + "</PDBx:NA_gamma-angle_constraints_total_count>\n");
			if (NA_other_angle_constraints_total_count != null) ow.write(indent + " <PDBx:NA_other-angle_constraints_total_count>" + NA_other_angle_constraints_total_count + "</PDBx:NA_other-angle_constraints_total_count>\n");
			if (NA_sugar_pucker_constraints_total_count != null) ow.write(indent + " <PDBx:NA_sugar_pucker_constraints_total_count>" + NA_sugar_pucker_constraints_total_count + "</PDBx:NA_sugar_pucker_constraints_total_count>\n");
			if (NOE_constraints_total != null) ow.write(indent + " <PDBx:NOE_constraints_total>" + NOE_constraints_total + "</PDBx:NOE_constraints_total>\n");
			if (NOE_interentity_total_count != null) ow.write(indent + " <PDBx:NOE_interentity_total_count>" + NOE_interentity_total_count + "</PDBx:NOE_interentity_total_count>\n");
			if (NOE_interproton_distance_evaluation != null) ow.write(indent + " <PDBx:NOE_interproton_distance_evaluation>" + NOE_interproton_distance_evaluation + "</PDBx:NOE_interproton_distance_evaluation>\n");
			if (NOE_intraresidue_total_count != null) ow.write(indent + " <PDBx:NOE_intraresidue_total_count>" + NOE_intraresidue_total_count + "</PDBx:NOE_intraresidue_total_count>\n");
			if (NOE_long_range_total_count != null) ow.write(indent + " <PDBx:NOE_long_range_total_count>" + NOE_long_range_total_count + "</PDBx:NOE_long_range_total_count>\n");
			if (NOE_medium_range_total_count != null) ow.write(indent + " <PDBx:NOE_medium_range_total_count>" + NOE_medium_range_total_count + "</PDBx:NOE_medium_range_total_count>\n");
			if (NOE_motional_averaging_correction != null) ow.write(indent + " <PDBx:NOE_motional_averaging_correction>" + NOE_motional_averaging_correction + "</PDBx:NOE_motional_averaging_correction>\n");
			if (NOE_pseudoatom_corrections != null) ow.write(indent + " <PDBx:NOE_pseudoatom_corrections>" + NOE_pseudoatom_corrections + "</PDBx:NOE_pseudoatom_corrections>\n");
			if (NOE_sequential_total_count != null) ow.write(indent + " <PDBx:NOE_sequential_total_count>" + NOE_sequential_total_count + "</PDBx:NOE_sequential_total_count>\n");
			if (disulfide_bond_constraints_total_count != null) ow.write(indent + " <PDBx:disulfide_bond_constraints_total_count>" + disulfide_bond_constraints_total_count + "</PDBx:disulfide_bond_constraints_total_count>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (hydrogen_bond_constraints_total_count != null) ow.write(indent + " <PDBx:hydrogen_bond_constraints_total_count>" + hydrogen_bond_constraints_total_count + "</PDBx:hydrogen_bond_constraints_total_count>\n");
			if (protein_chi_angle_constraints_total_count != null) ow.write(indent + " <PDBx:protein_chi_angle_constraints_total_count>" + protein_chi_angle_constraints_total_count + "</PDBx:protein_chi_angle_constraints_total_count>\n");
			if (protein_other_angle_constraints_total_count != null) ow.write(indent + " <PDBx:protein_other_angle_constraints_total_count>" + protein_other_angle_constraints_total_count + "</PDBx:protein_other_angle_constraints_total_count>\n");
			if (protein_phi_angle_constraints_total_count != null) ow.write(indent + " <PDBx:protein_phi_angle_constraints_total_count>" + protein_phi_angle_constraints_total_count + "</PDBx:protein_phi_angle_constraints_total_count>\n");
			if (protein_psi_angle_constraints_total_count != null) ow.write(indent + " <PDBx:protein_psi_angle_constraints_total_count>" + protein_psi_angle_constraints_total_count + "</PDBx:protein_psi_angle_constraints_total_count>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_constraints>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
