package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The final force constants, including units, employed for the various
 *  experimental constraints, covalent geometry constraints, and the non-bonded
 *  interaction terms in the target function used for simulated annealing.
 *  
 *  This example is taken from a study of BAF, a dimeric DNA binding protein.
 *  The final force constants in the target function used for simulated
 *  annealing are:  Experimental Constraint terms: Distance (NOE,H-bonds),
 *  Torsion angles, J coupling, 13C shifts, 1H shifts, Dipolar coupling,
 *  D isotope shifts Covalent Geometry Constraint terms: Bond lengths,
 *  Angles, Impropers Non-bonded Interaction terms: van der Waals,
 *  Type of van der Waals term, Conformational database potential,
 *  Radius of gyration.
 *  <PDBx:pdbx_nmr_force_constantsCategory>
 *  <PDBx:pdbx_nmr_force_constants entry_id="1ABC">
 *  <PDBx:exptl_distance_term>30.</PDBx:exptl_distance_term>
 *  <PDBx:exptl_distance_term_units>kcal/mol/A**2</PDBx:exptl_distance_term_units>
 *  <PDBx:exptl_torsion_angles_term>200.</PDBx:exptl_torsion_angles_term>
 *  <PDBx:exptl_torsion_angles_term_units>kcal/mol/rad**2</PDBx:exptl_torsion_angles_term_units>
 *  <PDBx:exptl_J_coupling_term>1.</PDBx:exptl_J_coupling_term>
 *  <PDBx:exptl_J_coupling_term_units>kcal/mol/Hz**2</PDBx:exptl_J_coupling_term_units>
 *  <PDBx:exptl_13C_shift_term>0.5</PDBx:exptl_13C_shift_term>
 *  <PDBx:exptl_13C_shift_term_units>kcal/mol/ppm**2</PDBx:exptl_13C_shift_term_units>
 *  <PDBx:exptl_1H_shift_term>7.5</PDBx:exptl_1H_shift_term>
 *  <PDBx:exptl_1H_shift_term_units>kcal/mol/ppm**2</PDBx:exptl_1H_shift_term_units>
 *  <PDBx:covalent_geom_bond_term>1000.</PDBx:covalent_geom_bond_term>
 *  <PDBx:covalent_geom_bond_term_units>kcal/mol/A**2</PDBx:covalent_geom_bond_term_units>
 *  <PDBx:non-bonded_inter_van_der_Waals_term_type>4.</PDBx:non-bonded_inter_van_der_Waals_term_type>
 *  </PDBx:pdbx_nmr_force_constants>
 *  </PDBx:pdbx_nmr_force_constantsCategory>
 */
public class Pdbx_nmr_force_constants extends org.pdb.beans.Pdbx_nmr_force_constants implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_force_constants";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_force_constants()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_force_constants(
		Datablock datablock,
		java.lang.Float covalent_geom_angles_term,
		java.lang.String covalent_geom_angles_term_units,
		java.lang.Float covalent_geom_bond_term,
		java.lang.String covalent_geom_bond_term_units,
		java.lang.Float covalent_geom_impropers_term,
		java.lang.String covalent_geom_impropers_term_units,
		java.lang.String entry_id,
		java.lang.Float exptl_13C_shift_term,
		java.lang.String exptl_13C_shift_term_units,
		java.lang.Float exptl_1H_shift_term,
		java.lang.String exptl_1H_shift_term_units,
		java.lang.Float exptl_D_isotope_shift_term,
		java.lang.String exptl_D_isotope_shift_term_units,
		java.lang.Float exptl_J_coupling_term,
		java.lang.String exptl_J_coupling_term_units,
		java.lang.Float exptl_dipolar_coupling_term,
		java.lang.String exptl_dipolar_coupling_term_units,
		java.lang.Float exptl_distance_term,
		java.lang.String exptl_distance_term_units,
		java.lang.Float exptl_torsion_angles_term,
		java.lang.String exptl_torsion_angles_term_units,
		java.lang.Float non_bonded_inter_conf_db_potential_term,
		java.lang.Float non_bonded_inter_radius_of_gyration_term,
		java.lang.String non_bonded_inter_radius_of_gyration_term_units,
		java.lang.Float non_bonded_inter_van_der_Waals_term,
		java.lang.String non_bonded_inter_van_der_Waals_term_type,
		java.lang.String non_bonded_inter_van_der_Waals_term_units)
	{
		this.datablock = datablock;
		this.covalent_geom_angles_term = covalent_geom_angles_term;
		this.covalent_geom_angles_term_units = covalent_geom_angles_term_units;
		this.covalent_geom_bond_term = covalent_geom_bond_term;
		this.covalent_geom_bond_term_units = covalent_geom_bond_term_units;
		this.covalent_geom_impropers_term = covalent_geom_impropers_term;
		this.covalent_geom_impropers_term_units = covalent_geom_impropers_term_units;
		this.entry_id = entry_id;
		this.exptl_13C_shift_term = exptl_13C_shift_term;
		this.exptl_13C_shift_term_units = exptl_13C_shift_term_units;
		this.exptl_1H_shift_term = exptl_1H_shift_term;
		this.exptl_1H_shift_term_units = exptl_1H_shift_term_units;
		this.exptl_D_isotope_shift_term = exptl_D_isotope_shift_term;
		this.exptl_D_isotope_shift_term_units = exptl_D_isotope_shift_term_units;
		this.exptl_J_coupling_term = exptl_J_coupling_term;
		this.exptl_J_coupling_term_units = exptl_J_coupling_term_units;
		this.exptl_dipolar_coupling_term = exptl_dipolar_coupling_term;
		this.exptl_dipolar_coupling_term_units = exptl_dipolar_coupling_term_units;
		this.exptl_distance_term = exptl_distance_term;
		this.exptl_distance_term_units = exptl_distance_term_units;
		this.exptl_torsion_angles_term = exptl_torsion_angles_term;
		this.exptl_torsion_angles_term_units = exptl_torsion_angles_term_units;
		this.non_bonded_inter_conf_db_potential_term = non_bonded_inter_conf_db_potential_term;
		this.non_bonded_inter_radius_of_gyration_term = non_bonded_inter_radius_of_gyration_term;
		this.non_bonded_inter_radius_of_gyration_term_units = non_bonded_inter_radius_of_gyration_term_units;
		this.non_bonded_inter_van_der_Waals_term = non_bonded_inter_van_der_Waals_term;
		this.non_bonded_inter_van_der_Waals_term_type = non_bonded_inter_van_der_Waals_term_type;
		this.non_bonded_inter_van_der_Waals_term_units = non_bonded_inter_van_der_Waals_term_units;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_force_constants");
		sb.append("\n");
		if (covalent_geom_angles_term != null)
		{
			sb.append("covalent_geom_angles_term = ");
			sb.append(covalent_geom_angles_term);
			sb.append('\n');
		}
		if (covalent_geom_angles_term_units != null)
		{
			sb.append("covalent_geom_angles_term_units = ");
			sb.append(covalent_geom_angles_term_units);
			sb.append('\n');
		}
		if (covalent_geom_bond_term != null)
		{
			sb.append("covalent_geom_bond_term = ");
			sb.append(covalent_geom_bond_term);
			sb.append('\n');
		}
		if (covalent_geom_bond_term_units != null)
		{
			sb.append("covalent_geom_bond_term_units = ");
			sb.append(covalent_geom_bond_term_units);
			sb.append('\n');
		}
		if (covalent_geom_impropers_term != null)
		{
			sb.append("covalent_geom_impropers_term = ");
			sb.append(covalent_geom_impropers_term);
			sb.append('\n');
		}
		if (covalent_geom_impropers_term_units != null)
		{
			sb.append("covalent_geom_impropers_term_units = ");
			sb.append(covalent_geom_impropers_term_units);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (exptl_13C_shift_term != null)
		{
			sb.append("exptl_13C_shift_term = ");
			sb.append(exptl_13C_shift_term);
			sb.append('\n');
		}
		if (exptl_13C_shift_term_units != null)
		{
			sb.append("exptl_13C_shift_term_units = ");
			sb.append(exptl_13C_shift_term_units);
			sb.append('\n');
		}
		if (exptl_1H_shift_term != null)
		{
			sb.append("exptl_1H_shift_term = ");
			sb.append(exptl_1H_shift_term);
			sb.append('\n');
		}
		if (exptl_1H_shift_term_units != null)
		{
			sb.append("exptl_1H_shift_term_units = ");
			sb.append(exptl_1H_shift_term_units);
			sb.append('\n');
		}
		if (exptl_D_isotope_shift_term != null)
		{
			sb.append("exptl_D_isotope_shift_term = ");
			sb.append(exptl_D_isotope_shift_term);
			sb.append('\n');
		}
		if (exptl_D_isotope_shift_term_units != null)
		{
			sb.append("exptl_D_isotope_shift_term_units = ");
			sb.append(exptl_D_isotope_shift_term_units);
			sb.append('\n');
		}
		if (exptl_J_coupling_term != null)
		{
			sb.append("exptl_J_coupling_term = ");
			sb.append(exptl_J_coupling_term);
			sb.append('\n');
		}
		if (exptl_J_coupling_term_units != null)
		{
			sb.append("exptl_J_coupling_term_units = ");
			sb.append(exptl_J_coupling_term_units);
			sb.append('\n');
		}
		if (exptl_dipolar_coupling_term != null)
		{
			sb.append("exptl_dipolar_coupling_term = ");
			sb.append(exptl_dipolar_coupling_term);
			sb.append('\n');
		}
		if (exptl_dipolar_coupling_term_units != null)
		{
			sb.append("exptl_dipolar_coupling_term_units = ");
			sb.append(exptl_dipolar_coupling_term_units);
			sb.append('\n');
		}
		if (exptl_distance_term != null)
		{
			sb.append("exptl_distance_term = ");
			sb.append(exptl_distance_term);
			sb.append('\n');
		}
		if (exptl_distance_term_units != null)
		{
			sb.append("exptl_distance_term_units = ");
			sb.append(exptl_distance_term_units);
			sb.append('\n');
		}
		if (exptl_torsion_angles_term != null)
		{
			sb.append("exptl_torsion_angles_term = ");
			sb.append(exptl_torsion_angles_term);
			sb.append('\n');
		}
		if (exptl_torsion_angles_term_units != null)
		{
			sb.append("exptl_torsion_angles_term_units = ");
			sb.append(exptl_torsion_angles_term_units);
			sb.append('\n');
		}
		if (non_bonded_inter_conf_db_potential_term != null)
		{
			sb.append("non-bonded_inter_conf_db_potential_term = ");
			sb.append(non_bonded_inter_conf_db_potential_term);
			sb.append('\n');
		}
		if (non_bonded_inter_radius_of_gyration_term != null)
		{
			sb.append("non-bonded_inter_radius_of_gyration_term = ");
			sb.append(non_bonded_inter_radius_of_gyration_term);
			sb.append('\n');
		}
		if (non_bonded_inter_radius_of_gyration_term_units != null)
		{
			sb.append("non-bonded_inter_radius_of_gyration_term_units = ");
			sb.append(non_bonded_inter_radius_of_gyration_term_units);
			sb.append('\n');
		}
		if (non_bonded_inter_van_der_Waals_term != null)
		{
			sb.append("non-bonded_inter_van_der_Waals_term = ");
			sb.append(non_bonded_inter_van_der_Waals_term);
			sb.append('\n');
		}
		if (non_bonded_inter_van_der_Waals_term_type != null)
		{
			sb.append("non-bonded_inter_van_der_Waals_term_type = ");
			sb.append(non_bonded_inter_van_der_Waals_term_type);
			sb.append('\n');
		}
		if (non_bonded_inter_van_der_Waals_term_units != null)
		{
			sb.append("non-bonded_inter_van_der_Waals_term_units = ");
			sb.append(non_bonded_inter_van_der_Waals_term_units);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		covalent_geom_angles_term = null;
		covalent_geom_angles_term_units = null;
		covalent_geom_bond_term = null;
		covalent_geom_bond_term_units = null;
		covalent_geom_impropers_term = null;
		covalent_geom_impropers_term_units = null;
		entry_id = null;
		exptl_13C_shift_term = null;
		exptl_13C_shift_term_units = null;
		exptl_1H_shift_term = null;
		exptl_1H_shift_term_units = null;
		exptl_D_isotope_shift_term = null;
		exptl_D_isotope_shift_term_units = null;
		exptl_J_coupling_term = null;
		exptl_J_coupling_term_units = null;
		exptl_dipolar_coupling_term = null;
		exptl_dipolar_coupling_term_units = null;
		exptl_distance_term = null;
		exptl_distance_term_units = null;
		exptl_torsion_angles_term = null;
		exptl_torsion_angles_term_units = null;
		non_bonded_inter_conf_db_potential_term = null;
		non_bonded_inter_radius_of_gyration_term = null;
		non_bonded_inter_radius_of_gyration_term_units = null;
		non_bonded_inter_van_der_Waals_term = null;
		non_bonded_inter_van_der_Waals_term_type = null;
		non_bonded_inter_van_der_Waals_term_units = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_force_constants)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_force_constants>\n");
			if (covalent_geom_angles_term != null) ow.write(indent + " <PDBx:covalent_geom_angles_term>" + covalent_geom_angles_term + "</PDBx:covalent_geom_angles_term>\n");
			if (covalent_geom_angles_term_units != null) ow.write(indent + " <PDBx:covalent_geom_angles_term_units>" + covalent_geom_angles_term_units + "</PDBx:covalent_geom_angles_term_units>\n");
			if (covalent_geom_bond_term != null) ow.write(indent + " <PDBx:covalent_geom_bond_term>" + covalent_geom_bond_term + "</PDBx:covalent_geom_bond_term>\n");
			if (covalent_geom_bond_term_units != null) ow.write(indent + " <PDBx:covalent_geom_bond_term_units>" + covalent_geom_bond_term_units + "</PDBx:covalent_geom_bond_term_units>\n");
			if (covalent_geom_impropers_term != null) ow.write(indent + " <PDBx:covalent_geom_impropers_term>" + covalent_geom_impropers_term + "</PDBx:covalent_geom_impropers_term>\n");
			if (covalent_geom_impropers_term_units != null) ow.write(indent + " <PDBx:covalent_geom_impropers_term_units>" + covalent_geom_impropers_term_units + "</PDBx:covalent_geom_impropers_term_units>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (exptl_13C_shift_term != null) ow.write(indent + " <PDBx:exptl_13C_shift_term>" + exptl_13C_shift_term + "</PDBx:exptl_13C_shift_term>\n");
			if (exptl_13C_shift_term_units != null) ow.write(indent + " <PDBx:exptl_13C_shift_term_units>" + exptl_13C_shift_term_units + "</PDBx:exptl_13C_shift_term_units>\n");
			if (exptl_1H_shift_term != null) ow.write(indent + " <PDBx:exptl_1H_shift_term>" + exptl_1H_shift_term + "</PDBx:exptl_1H_shift_term>\n");
			if (exptl_1H_shift_term_units != null) ow.write(indent + " <PDBx:exptl_1H_shift_term_units>" + exptl_1H_shift_term_units + "</PDBx:exptl_1H_shift_term_units>\n");
			if (exptl_D_isotope_shift_term != null) ow.write(indent + " <PDBx:exptl_D_isotope_shift_term>" + exptl_D_isotope_shift_term + "</PDBx:exptl_D_isotope_shift_term>\n");
			if (exptl_D_isotope_shift_term_units != null) ow.write(indent + " <PDBx:exptl_D_isotope_shift_term_units>" + exptl_D_isotope_shift_term_units + "</PDBx:exptl_D_isotope_shift_term_units>\n");
			if (exptl_J_coupling_term != null) ow.write(indent + " <PDBx:exptl_J_coupling_term>" + exptl_J_coupling_term + "</PDBx:exptl_J_coupling_term>\n");
			if (exptl_J_coupling_term_units != null) ow.write(indent + " <PDBx:exptl_J_coupling_term_units>" + exptl_J_coupling_term_units + "</PDBx:exptl_J_coupling_term_units>\n");
			if (exptl_dipolar_coupling_term != null) ow.write(indent + " <PDBx:exptl_dipolar_coupling_term>" + exptl_dipolar_coupling_term + "</PDBx:exptl_dipolar_coupling_term>\n");
			if (exptl_dipolar_coupling_term_units != null) ow.write(indent + " <PDBx:exptl_dipolar_coupling_term_units>" + exptl_dipolar_coupling_term_units + "</PDBx:exptl_dipolar_coupling_term_units>\n");
			if (exptl_distance_term != null) ow.write(indent + " <PDBx:exptl_distance_term>" + exptl_distance_term + "</PDBx:exptl_distance_term>\n");
			if (exptl_distance_term_units != null) ow.write(indent + " <PDBx:exptl_distance_term_units>" + exptl_distance_term_units + "</PDBx:exptl_distance_term_units>\n");
			if (exptl_torsion_angles_term != null) ow.write(indent + " <PDBx:exptl_torsion_angles_term>" + exptl_torsion_angles_term + "</PDBx:exptl_torsion_angles_term>\n");
			if (exptl_torsion_angles_term_units != null) ow.write(indent + " <PDBx:exptl_torsion_angles_term_units>" + exptl_torsion_angles_term_units + "</PDBx:exptl_torsion_angles_term_units>\n");
			if (non_bonded_inter_conf_db_potential_term != null) ow.write(indent + " <PDBx:non-bonded_inter_conf_db_potential_term>" + non_bonded_inter_conf_db_potential_term + "</PDBx:non-bonded_inter_conf_db_potential_term>\n");
			if (non_bonded_inter_radius_of_gyration_term != null) ow.write(indent + " <PDBx:non-bonded_inter_radius_of_gyration_term>" + non_bonded_inter_radius_of_gyration_term + "</PDBx:non-bonded_inter_radius_of_gyration_term>\n");
			if (non_bonded_inter_radius_of_gyration_term_units != null) ow.write(indent + " <PDBx:non-bonded_inter_radius_of_gyration_term_units>" + non_bonded_inter_radius_of_gyration_term_units + "</PDBx:non-bonded_inter_radius_of_gyration_term_units>\n");
			if (non_bonded_inter_van_der_Waals_term != null) ow.write(indent + " <PDBx:non-bonded_inter_van_der_Waals_term>" + non_bonded_inter_van_der_Waals_term + "</PDBx:non-bonded_inter_van_der_Waals_term>\n");
			if (non_bonded_inter_van_der_Waals_term_type != null) ow.write(indent + " <PDBx:non-bonded_inter_van_der_Waals_term_type>" + non_bonded_inter_van_der_Waals_term_type + "</PDBx:non-bonded_inter_van_der_Waals_term_type>\n");
			if (non_bonded_inter_van_der_Waals_term_units != null) ow.write(indent + " <PDBx:non-bonded_inter_van_der_Waals_term_units>" + non_bonded_inter_van_der_Waals_term_units + "</PDBx:non-bonded_inter_van_der_Waals_term_units>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_force_constants>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
