package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Describe the method and details of the refinement of the deposited structure.
 *  This example is drawn from the MCP-1 structure.
 *  <PDBx:pdbx_nmr_refineCategory>
 *  <PDBx:pdbx_nmr_refine entry_id="1ABC">
 *  <PDBx:method>torsion angle dynamics</PDBx:method>
 *  </PDBx:pdbx_nmr_refine>
 *  </PDBx:pdbx_nmr_refineCategory>
 */
public class Pdbx_nmr_refine extends org.pdb.beans.Pdbx_nmr_refine implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_refine";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_refine()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_refine(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_refine");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_refine)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_refine>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_refine>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
