package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Complete description of each NMR sample, including the solvent
 *  system used.
 *  
 *  This example was taken from the study of MCP-1 which is a dimer under the
 *  conditions studied.  Three solutions with different isotope compositions were
 *  studied.
 *  
 *  <PDBx:pdbx_nmr_sample_detailsCategory>
 *  <PDBx:pdbx_nmr_sample_details solution_id="1">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>2 mM U-15N,13C, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  <PDBx:pdbx_nmr_sample_details solution_id="2">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>1 mM U-50&#37; 15N, MCP-1 1 mM U-50&#37; 13C, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  <PDBx:pdbx_nmr_sample_details solution_id="3">
 *  <PDBx:solvent_system>MCP-1</PDBx:solvent_system>
 *  <PDBx:contents>2 mM U-15N, H2O 90 &#37;, D2O 10 &#37;</PDBx:contents>
 *  </PDBx:pdbx_nmr_sample_details>
 *  </PDBx:pdbx_nmr_sample_detailsCategory>
 */
public class Pdbx_nmr_sample_details extends org.pdb.beans.Pdbx_nmr_sample_details implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nmr_sample_details";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nmr_sample_details()
	{
	}

	/** Full constructor */
	public Pdbx_nmr_sample_details(
		Datablock datablock,
		java.lang.String contents,
		java.lang.String solution_id,
		java.lang.String solvent_system)
	{
		this.datablock = datablock;
		this.contents = contents;
		this.solution_id = solution_id;
		this.solvent_system = solvent_system;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nmr_sample_details");
		sb.append("\n");
		if (contents != null)
		{
			sb.append("contents = ");
			sb.append(contents);
			sb.append('\n');
		}
		if (solution_id != null)
		{
			sb.append("solution_id = ");
			sb.append(solution_id);
			sb.append('\n');
		}
		if (solvent_system != null)
		{
			sb.append("solvent_system = ");
			sb.append(solvent_system);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		contents = null;
		solution_id = null;
		solvent_system = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nmr_sample_details)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nmr_sample_details>\n");
			if (contents != null) ow.write(indent + " <PDBx:contents>" + contents + "</PDBx:contents>\n");
			if (solution_id != null) ow.write(indent + " <PDBx:solution_id>" + solution_id + "</PDBx:solution_id>\n");
			if (solvent_system != null) ow.write(indent + " <PDBx:solvent_system>" + solvent_system + "</PDBx:solvent_system>\n");
			ow.write(indent + "</PDBx:pdbx_nmr_sample_details>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
