package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  The PDBX_NONPOLY_SCHEME category provides residue level nomenclature
 *  mapping for non-polymer entities.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_nonpoly_schemeCategory>
 *  <PDBx:pdbx_nonpoly_scheme asym_id="C" ndb_seq_num="100">
 *  <PDBx:entity_id>3</PDBx:entity_id>
 *  <PDBx:mon_id>HOH</PDBx:mon_id>
 *  <PDBx:pdb_seq_num>100</PDBx:pdb_seq_num>
 *  <PDBx:auth_seq_num>100</PDBx:auth_seq_num>
 *  <PDBx:pdb_mon_id>HOH</PDBx:pdb_mon_id>
 *  <PDBx:auth_mon_id>HOH</PDBx:auth_mon_id>
 *  <PDBx:pdb_strand_id>C</PDBx:pdb_strand_id>
 *  </PDBx:pdbx_nonpoly_scheme>
 *  </PDBx:pdbx_nonpoly_schemeCategory>
 * </pre>
 */
public class Pdbx_nonpoly_scheme extends org.pdb.beans.Pdbx_nonpoly_scheme implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_nonpoly_scheme";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_nonpoly_scheme()
	{
	}

	/** Full constructor */
	public Pdbx_nonpoly_scheme(
		Datablock datablock,
		java.lang.String asym_id,
		java.lang.String auth_mon_id,
		java.lang.String auth_seq_num,
		java.lang.String entity_id,
		java.lang.String mon_id,
		java.lang.String ndb_seq_num,
		java.lang.String pdb_ins_code,
		java.lang.String pdb_mon_id,
		java.lang.String pdb_seq_num,
		java.lang.String pdb_strand_id)
	{
		this.datablock = datablock;
		this.asym_id = asym_id;
		this.auth_mon_id = auth_mon_id;
		this.auth_seq_num = auth_seq_num;
		this.entity_id = entity_id;
		this.mon_id = mon_id;
		this.ndb_seq_num = ndb_seq_num;
		this.pdb_ins_code = pdb_ins_code;
		this.pdb_mon_id = pdb_mon_id;
		this.pdb_seq_num = pdb_seq_num;
		this.pdb_strand_id = pdb_strand_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_nonpoly_scheme");
		sb.append("\n");
		if (asym_id != null)
		{
			sb.append("asym_id = ");
			sb.append(asym_id);
			sb.append('\n');
		}
		if (auth_mon_id != null)
		{
			sb.append("auth_mon_id = ");
			sb.append(auth_mon_id);
			sb.append('\n');
		}
		if (auth_seq_num != null)
		{
			sb.append("auth_seq_num = ");
			sb.append(auth_seq_num);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (mon_id != null)
		{
			sb.append("mon_id = ");
			sb.append(mon_id);
			sb.append('\n');
		}
		if (ndb_seq_num != null)
		{
			sb.append("ndb_seq_num = ");
			sb.append(ndb_seq_num);
			sb.append('\n');
		}
		if (pdb_ins_code != null)
		{
			sb.append("pdb_ins_code = ");
			sb.append(pdb_ins_code);
			sb.append('\n');
		}
		if (pdb_mon_id != null)
		{
			sb.append("pdb_mon_id = ");
			sb.append(pdb_mon_id);
			sb.append('\n');
		}
		if (pdb_seq_num != null)
		{
			sb.append("pdb_seq_num = ");
			sb.append(pdb_seq_num);
			sb.append('\n');
		}
		if (pdb_strand_id != null)
		{
			sb.append("pdb_strand_id = ");
			sb.append(pdb_strand_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		asym_id = null;
		auth_mon_id = null;
		auth_seq_num = null;
		entity_id = null;
		mon_id = null;
		ndb_seq_num = null;
		pdb_ins_code = null;
		pdb_mon_id = null;
		pdb_seq_num = null;
		pdb_strand_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_nonpoly_scheme)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_nonpoly_scheme>\n");
			if (asym_id != null) ow.write(indent + " <PDBx:asym_id>" + asym_id + "</PDBx:asym_id>\n");
			if (auth_mon_id != null) ow.write(indent + " <PDBx:auth_mon_id>" + auth_mon_id + "</PDBx:auth_mon_id>\n");
			if (auth_seq_num != null) ow.write(indent + " <PDBx:auth_seq_num>" + auth_seq_num + "</PDBx:auth_seq_num>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (mon_id != null) ow.write(indent + " <PDBx:mon_id>" + mon_id + "</PDBx:mon_id>\n");
			if (ndb_seq_num != null) ow.write(indent + " <PDBx:ndb_seq_num>" + ndb_seq_num + "</PDBx:ndb_seq_num>\n");
			if (pdb_ins_code != null) ow.write(indent + " <PDBx:pdb_ins_code>" + pdb_ins_code + "</PDBx:pdb_ins_code>\n");
			if (pdb_mon_id != null) ow.write(indent + " <PDBx:pdb_mon_id>" + pdb_mon_id + "</PDBx:pdb_mon_id>\n");
			if (pdb_seq_num != null) ow.write(indent + " <PDBx:pdb_seq_num>" + pdb_seq_num + "</PDBx:pdb_seq_num>\n");
			if (pdb_strand_id != null) ow.write(indent + " <PDBx:pdb_strand_id>" + pdb_strand_id + "</PDBx:pdb_strand_id>\n");
			ow.write(indent + "</PDBx:pdbx_nonpoly_scheme>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
