package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  record the details (coordinates etc.) of anomalous scatters.
 *  
 *  
 *  
 * <pre>
 *  Example 1 -  anomalous scatters is Se
 *  <PDBx:pdbx_phasing_MAD_set_siteCategory>
 *  <PDBx:pdbx_phasing_MAD_set_site id="1">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>25.9407</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>-0.103471</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>17.4094</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  <PDBx:pdbx_phasing_MAD_set_site id="2">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>30.6534</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>6.62359</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>9.93063</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  <PDBx:pdbx_phasing_MAD_set_site id="3">
 *  <PDBx:atom_type_symbol>SE</PDBx:atom_type_symbol>
 *  <PDBx:Cartn_x>-3.26506</PDBx:Cartn_x>
 *  <PDBx:Cartn_y>15.5546</PDBx:Cartn_y>
 *  <PDBx:Cartn_z>53.9529</PDBx:Cartn_z>
 *  </PDBx:pdbx_phasing_MAD_set_site>
 *  </PDBx:pdbx_phasing_MAD_set_siteCategory>
 * </pre>
 */
public class Pdbx_phasing_MAD_set_site extends org.pdb.beans.Pdbx_phasing_MAD_set_site implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_phasing_MAD_set_site";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_phasing_MAD_set_site()
	{
	}

	/** Full constructor */
	public Pdbx_phasing_MAD_set_site(
		Datablock datablock,
		java.lang.Float Cartn_x,
		java.lang.Float Cartn_x_esd,
		java.lang.Float Cartn_y,
		java.lang.Float Cartn_y_esd,
		java.lang.Float Cartn_z,
		java.lang.Float Cartn_z_esd,
		java.lang.String atom_type_symbol,
		java.lang.Float b_iso,
		java.lang.Float b_iso_esd,
		java.lang.Float fract_x,
		java.lang.Float fract_x_esd,
		java.lang.Float fract_y,
		java.lang.Float fract_y_esd,
		java.lang.Float fract_z,
		java.lang.Float fract_z_esd,
		java.lang.String id_,
		java.lang.Float occupancy,
		java.lang.Float occupancy_esd,
		java.lang.Float occupancy_iso,
		java.lang.String set_id)
	{
		this.datablock = datablock;
		this.Cartn_x = Cartn_x;
		this.Cartn_x_esd = Cartn_x_esd;
		this.Cartn_y = Cartn_y;
		this.Cartn_y_esd = Cartn_y_esd;
		this.Cartn_z = Cartn_z;
		this.Cartn_z_esd = Cartn_z_esd;
		this.atom_type_symbol = atom_type_symbol;
		this.b_iso = b_iso;
		this.b_iso_esd = b_iso_esd;
		this.fract_x = fract_x;
		this.fract_x_esd = fract_x_esd;
		this.fract_y = fract_y;
		this.fract_y_esd = fract_y_esd;
		this.fract_z = fract_z;
		this.fract_z_esd = fract_z_esd;
		this.id_ = id_;
		this.occupancy = occupancy;
		this.occupancy_esd = occupancy_esd;
		this.occupancy_iso = occupancy_iso;
		this.set_id = set_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_phasing_MAD_set_site");
		sb.append("\n");
		if (Cartn_x != null)
		{
			sb.append("Cartn_x = ");
			sb.append(Cartn_x);
			sb.append('\n');
		}
		if (Cartn_x_esd != null)
		{
			sb.append("Cartn_x_esd = ");
			sb.append(Cartn_x_esd);
			sb.append('\n');
		}
		if (Cartn_y != null)
		{
			sb.append("Cartn_y = ");
			sb.append(Cartn_y);
			sb.append('\n');
		}
		if (Cartn_y_esd != null)
		{
			sb.append("Cartn_y_esd = ");
			sb.append(Cartn_y_esd);
			sb.append('\n');
		}
		if (Cartn_z != null)
		{
			sb.append("Cartn_z = ");
			sb.append(Cartn_z);
			sb.append('\n');
		}
		if (Cartn_z_esd != null)
		{
			sb.append("Cartn_z_esd = ");
			sb.append(Cartn_z_esd);
			sb.append('\n');
		}
		if (atom_type_symbol != null)
		{
			sb.append("atom_type_symbol = ");
			sb.append(atom_type_symbol);
			sb.append('\n');
		}
		if (b_iso != null)
		{
			sb.append("b_iso = ");
			sb.append(b_iso);
			sb.append('\n');
		}
		if (b_iso_esd != null)
		{
			sb.append("b_iso_esd = ");
			sb.append(b_iso_esd);
			sb.append('\n');
		}
		if (fract_x != null)
		{
			sb.append("fract_x = ");
			sb.append(fract_x);
			sb.append('\n');
		}
		if (fract_x_esd != null)
		{
			sb.append("fract_x_esd = ");
			sb.append(fract_x_esd);
			sb.append('\n');
		}
		if (fract_y != null)
		{
			sb.append("fract_y = ");
			sb.append(fract_y);
			sb.append('\n');
		}
		if (fract_y_esd != null)
		{
			sb.append("fract_y_esd = ");
			sb.append(fract_y_esd);
			sb.append('\n');
		}
		if (fract_z != null)
		{
			sb.append("fract_z = ");
			sb.append(fract_z);
			sb.append('\n');
		}
		if (fract_z_esd != null)
		{
			sb.append("fract_z_esd = ");
			sb.append(fract_z_esd);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (occupancy != null)
		{
			sb.append("occupancy = ");
			sb.append(occupancy);
			sb.append('\n');
		}
		if (occupancy_esd != null)
		{
			sb.append("occupancy_esd = ");
			sb.append(occupancy_esd);
			sb.append('\n');
		}
		if (occupancy_iso != null)
		{
			sb.append("occupancy_iso = ");
			sb.append(occupancy_iso);
			sb.append('\n');
		}
		if (set_id != null)
		{
			sb.append("set_id = ");
			sb.append(set_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Cartn_x = null;
		Cartn_x_esd = null;
		Cartn_y = null;
		Cartn_y_esd = null;
		Cartn_z = null;
		Cartn_z_esd = null;
		atom_type_symbol = null;
		b_iso = null;
		b_iso_esd = null;
		fract_x = null;
		fract_x_esd = null;
		fract_y = null;
		fract_y_esd = null;
		fract_z = null;
		fract_z_esd = null;
		id_ = null;
		occupancy = null;
		occupancy_esd = null;
		occupancy_iso = null;
		set_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_phasing_MAD_set_site)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_phasing_MAD_set_site>\n");
			if (Cartn_x != null) ow.write(indent + " <PDBx:Cartn_x>" + Cartn_x + "</PDBx:Cartn_x>\n");
			if (Cartn_x_esd != null) ow.write(indent + " <PDBx:Cartn_x_esd>" + Cartn_x_esd + "</PDBx:Cartn_x_esd>\n");
			if (Cartn_y != null) ow.write(indent + " <PDBx:Cartn_y>" + Cartn_y + "</PDBx:Cartn_y>\n");
			if (Cartn_y_esd != null) ow.write(indent + " <PDBx:Cartn_y_esd>" + Cartn_y_esd + "</PDBx:Cartn_y_esd>\n");
			if (Cartn_z != null) ow.write(indent + " <PDBx:Cartn_z>" + Cartn_z + "</PDBx:Cartn_z>\n");
			if (Cartn_z_esd != null) ow.write(indent + " <PDBx:Cartn_z_esd>" + Cartn_z_esd + "</PDBx:Cartn_z_esd>\n");
			if (atom_type_symbol != null) ow.write(indent + " <PDBx:atom_type_symbol>" + atom_type_symbol + "</PDBx:atom_type_symbol>\n");
			if (b_iso != null) ow.write(indent + " <PDBx:b_iso>" + b_iso + "</PDBx:b_iso>\n");
			if (b_iso_esd != null) ow.write(indent + " <PDBx:b_iso_esd>" + b_iso_esd + "</PDBx:b_iso_esd>\n");
			if (fract_x != null) ow.write(indent + " <PDBx:fract_x>" + fract_x + "</PDBx:fract_x>\n");
			if (fract_x_esd != null) ow.write(indent + " <PDBx:fract_x_esd>" + fract_x_esd + "</PDBx:fract_x_esd>\n");
			if (fract_y != null) ow.write(indent + " <PDBx:fract_y>" + fract_y + "</PDBx:fract_y>\n");
			if (fract_y_esd != null) ow.write(indent + " <PDBx:fract_y_esd>" + fract_y_esd + "</PDBx:fract_y_esd>\n");
			if (fract_z != null) ow.write(indent + " <PDBx:fract_z>" + fract_z + "</PDBx:fract_z>\n");
			if (fract_z_esd != null) ow.write(indent + " <PDBx:fract_z_esd>" + fract_z_esd + "</PDBx:fract_z_esd>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (occupancy != null) ow.write(indent + " <PDBx:occupancy>" + occupancy + "</PDBx:occupancy>\n");
			if (occupancy_esd != null) ow.write(indent + " <PDBx:occupancy_esd>" + occupancy_esd + "</PDBx:occupancy_esd>\n");
			if (occupancy_iso != null) ow.write(indent + " <PDBx:occupancy_iso>" + occupancy_iso + "</PDBx:occupancy_iso>\n");
			if (set_id != null) ow.write(indent + " <PDBx:set_id>" + set_id + "</PDBx:set_id>\n");
			ow.write(indent + "</PDBx:pdbx_phasing_MAD_set_site>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
