package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_PHASING_MR category record details about
 *  molecular replacement.
 *  
 * <pre>
 *  Example 1 - molecular replacement example from program CNS.
 *  <PDBx:pdbx_phasing_MRCategory>
 *  <PDBx:pdbx_phasing_MR entry_id="ABC001">
 *  <PDBx:method_rotation>real-space rotation search</PDBx:method_rotation>
 *  <PDBx:d_res_high_rotation>3.8</PDBx:d_res_high_rotation>
 *  <PDBx:d_res_low_rotation>13.0</PDBx:d_res_low_rotation>
 *  <PDBx:sigma_F_rotation>1.0</PDBx:sigma_F_rotation>
 *  <PDBx:reflns_percent_rotation>97.8</PDBx:reflns_percent_rotation>
 *  <PDBx:method_translation>gerneral using PC-refinement= e2e2</PDBx:method_translation>
 *  <PDBx:d_res_high_translation>4.0</PDBx:d_res_high_translation>
 *  <PDBx:d_res_low_translation>15.0</PDBx:d_res_low_translation>
 *  <PDBx:sigma_F_translation>0.</PDBx:sigma_F_translation>
 *  <PDBx:reflns_percent_translation>97.7</PDBx:reflns_percent_translation>
 *  <PDBx:correlation_coeff_Fo_to_Fc>0.586</PDBx:correlation_coeff_Fo_to_Fc>
 *  <PDBx:packing>0.3086</PDBx:packing>
 *  </PDBx:pdbx_phasing_MR>
 *  </PDBx:pdbx_phasing_MRCategory>
 * </pre>
 */
public class Pdbx_phasing_MR extends org.pdb.beans.Pdbx_phasing_MR implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_phasing_MR";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_phasing_MR()
	{
	}

	/** Full constructor */
	public Pdbx_phasing_MR(
		Datablock datablock,
		java.lang.Float R_factor,
		java.lang.Float R_rigid_body,
		java.lang.Float correlation_coeff_Fo_to_Fc,
		java.lang.Float correlation_coeff_Io_to_Ic,
		java.lang.Float d_res_high_rotation,
		java.lang.Float d_res_high_translation,
		java.lang.Float d_res_low_rotation,
		java.lang.Float d_res_low_translation,
		java.lang.String entry_id,
		java.lang.String method_rotation,
		java.lang.String method_translation,
		java.lang.String model_details,
		java.lang.String native_set_id,
		java.lang.Float packing,
		java.lang.Float reflns_percent_rotation,
		java.lang.Float reflns_percent_translation,
		java.lang.Float sigma_F_rotation,
		java.lang.Float sigma_F_translation,
		java.lang.Float sigma_I_rotation,
		java.lang.Float sigma_I_translation)
	{
		this.datablock = datablock;
		this.R_factor = R_factor;
		this.R_rigid_body = R_rigid_body;
		this.correlation_coeff_Fo_to_Fc = correlation_coeff_Fo_to_Fc;
		this.correlation_coeff_Io_to_Ic = correlation_coeff_Io_to_Ic;
		this.d_res_high_rotation = d_res_high_rotation;
		this.d_res_high_translation = d_res_high_translation;
		this.d_res_low_rotation = d_res_low_rotation;
		this.d_res_low_translation = d_res_low_translation;
		this.entry_id = entry_id;
		this.method_rotation = method_rotation;
		this.method_translation = method_translation;
		this.model_details = model_details;
		this.native_set_id = native_set_id;
		this.packing = packing;
		this.reflns_percent_rotation = reflns_percent_rotation;
		this.reflns_percent_translation = reflns_percent_translation;
		this.sigma_F_rotation = sigma_F_rotation;
		this.sigma_F_translation = sigma_F_translation;
		this.sigma_I_rotation = sigma_I_rotation;
		this.sigma_I_translation = sigma_I_translation;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_phasing_MR");
		sb.append("\n");
		if (R_factor != null)
		{
			sb.append("R_factor = ");
			sb.append(R_factor);
			sb.append('\n');
		}
		if (R_rigid_body != null)
		{
			sb.append("R_rigid_body = ");
			sb.append(R_rigid_body);
			sb.append('\n');
		}
		if (correlation_coeff_Fo_to_Fc != null)
		{
			sb.append("correlation_coeff_Fo_to_Fc = ");
			sb.append(correlation_coeff_Fo_to_Fc);
			sb.append('\n');
		}
		if (correlation_coeff_Io_to_Ic != null)
		{
			sb.append("correlation_coeff_Io_to_Ic = ");
			sb.append(correlation_coeff_Io_to_Ic);
			sb.append('\n');
		}
		if (d_res_high_rotation != null)
		{
			sb.append("d_res_high_rotation = ");
			sb.append(d_res_high_rotation);
			sb.append('\n');
		}
		if (d_res_high_translation != null)
		{
			sb.append("d_res_high_translation = ");
			sb.append(d_res_high_translation);
			sb.append('\n');
		}
		if (d_res_low_rotation != null)
		{
			sb.append("d_res_low_rotation = ");
			sb.append(d_res_low_rotation);
			sb.append('\n');
		}
		if (d_res_low_translation != null)
		{
			sb.append("d_res_low_translation = ");
			sb.append(d_res_low_translation);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method_rotation != null)
		{
			sb.append("method_rotation = ");
			sb.append(method_rotation);
			sb.append('\n');
		}
		if (method_translation != null)
		{
			sb.append("method_translation = ");
			sb.append(method_translation);
			sb.append('\n');
		}
		if (model_details != null)
		{
			sb.append("model_details = ");
			sb.append(model_details);
			sb.append('\n');
		}
		if (native_set_id != null)
		{
			sb.append("native_set_id = ");
			sb.append(native_set_id);
			sb.append('\n');
		}
		if (packing != null)
		{
			sb.append("packing = ");
			sb.append(packing);
			sb.append('\n');
		}
		if (reflns_percent_rotation != null)
		{
			sb.append("reflns_percent_rotation = ");
			sb.append(reflns_percent_rotation);
			sb.append('\n');
		}
		if (reflns_percent_translation != null)
		{
			sb.append("reflns_percent_translation = ");
			sb.append(reflns_percent_translation);
			sb.append('\n');
		}
		if (sigma_F_rotation != null)
		{
			sb.append("sigma_F_rotation = ");
			sb.append(sigma_F_rotation);
			sb.append('\n');
		}
		if (sigma_F_translation != null)
		{
			sb.append("sigma_F_translation = ");
			sb.append(sigma_F_translation);
			sb.append('\n');
		}
		if (sigma_I_rotation != null)
		{
			sb.append("sigma_I_rotation = ");
			sb.append(sigma_I_rotation);
			sb.append('\n');
		}
		if (sigma_I_translation != null)
		{
			sb.append("sigma_I_translation = ");
			sb.append(sigma_I_translation);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_factor = null;
		R_rigid_body = null;
		correlation_coeff_Fo_to_Fc = null;
		correlation_coeff_Io_to_Ic = null;
		d_res_high_rotation = null;
		d_res_high_translation = null;
		d_res_low_rotation = null;
		d_res_low_translation = null;
		entry_id = null;
		method_rotation = null;
		method_translation = null;
		model_details = null;
		native_set_id = null;
		packing = null;
		reflns_percent_rotation = null;
		reflns_percent_translation = null;
		sigma_F_rotation = null;
		sigma_F_translation = null;
		sigma_I_rotation = null;
		sigma_I_translation = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_phasing_MR)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_phasing_MR>\n");
			if (R_factor != null) ow.write(indent + " <PDBx:R_factor>" + R_factor + "</PDBx:R_factor>\n");
			if (R_rigid_body != null) ow.write(indent + " <PDBx:R_rigid_body>" + R_rigid_body + "</PDBx:R_rigid_body>\n");
			if (correlation_coeff_Fo_to_Fc != null) ow.write(indent + " <PDBx:correlation_coeff_Fo_to_Fc>" + correlation_coeff_Fo_to_Fc + "</PDBx:correlation_coeff_Fo_to_Fc>\n");
			if (correlation_coeff_Io_to_Ic != null) ow.write(indent + " <PDBx:correlation_coeff_Io_to_Ic>" + correlation_coeff_Io_to_Ic + "</PDBx:correlation_coeff_Io_to_Ic>\n");
			if (d_res_high_rotation != null) ow.write(indent + " <PDBx:d_res_high_rotation>" + d_res_high_rotation + "</PDBx:d_res_high_rotation>\n");
			if (d_res_high_translation != null) ow.write(indent + " <PDBx:d_res_high_translation>" + d_res_high_translation + "</PDBx:d_res_high_translation>\n");
			if (d_res_low_rotation != null) ow.write(indent + " <PDBx:d_res_low_rotation>" + d_res_low_rotation + "</PDBx:d_res_low_rotation>\n");
			if (d_res_low_translation != null) ow.write(indent + " <PDBx:d_res_low_translation>" + d_res_low_translation + "</PDBx:d_res_low_translation>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method_rotation != null) ow.write(indent + " <PDBx:method_rotation>" + method_rotation + "</PDBx:method_rotation>\n");
			if (method_translation != null) ow.write(indent + " <PDBx:method_translation>" + method_translation + "</PDBx:method_translation>\n");
			if (model_details != null) ow.write(indent + " <PDBx:model_details>" + model_details + "</PDBx:model_details>\n");
			if (native_set_id != null) ow.write(indent + " <PDBx:native_set_id>" + native_set_id + "</PDBx:native_set_id>\n");
			if (packing != null) ow.write(indent + " <PDBx:packing>" + packing + "</PDBx:packing>\n");
			if (reflns_percent_rotation != null) ow.write(indent + " <PDBx:reflns_percent_rotation>" + reflns_percent_rotation + "</PDBx:reflns_percent_rotation>\n");
			if (reflns_percent_translation != null) ow.write(indent + " <PDBx:reflns_percent_translation>" + reflns_percent_translation + "</PDBx:reflns_percent_translation>\n");
			if (sigma_F_rotation != null) ow.write(indent + " <PDBx:sigma_F_rotation>" + sigma_F_rotation + "</PDBx:sigma_F_rotation>\n");
			if (sigma_F_translation != null) ow.write(indent + " <PDBx:sigma_F_translation>" + sigma_F_translation + "</PDBx:sigma_F_translation>\n");
			if (sigma_I_rotation != null) ow.write(indent + " <PDBx:sigma_I_rotation>" + sigma_I_rotation + "</PDBx:sigma_I_rotation>\n");
			if (sigma_I_translation != null) ow.write(indent + " <PDBx:sigma_I_translation>" + sigma_I_translation + "</PDBx:sigma_I_translation>\n");
			ow.write(indent + "</PDBx:pdbx_phasing_MR>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
