package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_PHASING_DM_SHELL category record details about
 *  density modification in resolution shell.
 *  
 * <pre>
 *  Example 1 - density modification with shells
 *  <PDBx:pdbx_phasing_dm_shellCategory>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="100.00" d_res_high="7.73">
 *  <PDBx:reflns>502</PDBx:reflns>
 *  <PDBx:fom>0.879</PDBx:fom>
 *  <PDBx:delta_phi_final>24.7</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="7.73" d_res_high="6.24">
 *  <PDBx:reflns>506</PDBx:reflns>
 *  <PDBx:fom>0.857</PDBx:fom>
 *  <PDBx:delta_phi_final>29.2</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="6.24" d_res_high="5.50">
 *  <PDBx:reflns>504</PDBx:reflns>
 *  <PDBx:fom>0.838</PDBx:fom>
 *  <PDBx:delta_phi_final>29.2</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="5.50" d_res_high="5.02">
 *  <PDBx:reflns>502</PDBx:reflns>
 *  <PDBx:fom>0.851</PDBx:fom>
 *  <PDBx:delta_phi_final>25.3</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  <PDBx:pdbx_phasing_dm_shell d_res_low="5.02" d_res_high="4.67">
 *  <PDBx:reflns>503</PDBx:reflns>
 *  <PDBx:fom>0.831</PDBx:fom>
 *  <PDBx:delta_phi_final>22.7</PDBx:delta_phi_final>
 *  </PDBx:pdbx_phasing_dm_shell>
 *  </PDBx:pdbx_phasing_dm_shellCategory>
 * </pre>
 */
public class Pdbx_phasing_dm_shell extends org.pdb.beans.Pdbx_phasing_dm_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_phasing_dm_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_phasing_dm_shell()
	{
	}

	/** Full constructor */
	public Pdbx_phasing_dm_shell(
		Datablock datablock,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Float delta_phi_final,
		java.lang.Float delta_phi_initial,
		java.lang.Float fom,
		java.lang.Float fom_acentric,
		java.lang.Float fom_centric,
		java.lang.Integer reflns,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_centric)
	{
		this.datablock = datablock;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.delta_phi_final = delta_phi_final;
		this.delta_phi_initial = delta_phi_initial;
		this.fom = fom;
		this.fom_acentric = fom_acentric;
		this.fom_centric = fom_centric;
		this.reflns = reflns;
		this.reflns_acentric = reflns_acentric;
		this.reflns_centric = reflns_centric;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_phasing_dm_shell");
		sb.append("\n");
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (delta_phi_final != null)
		{
			sb.append("delta_phi_final = ");
			sb.append(delta_phi_final);
			sb.append('\n');
		}
		if (delta_phi_initial != null)
		{
			sb.append("delta_phi_initial = ");
			sb.append(delta_phi_initial);
			sb.append('\n');
		}
		if (fom != null)
		{
			sb.append("fom = ");
			sb.append(fom);
			sb.append('\n');
		}
		if (fom_acentric != null)
		{
			sb.append("fom_acentric = ");
			sb.append(fom_acentric);
			sb.append('\n');
		}
		if (fom_centric != null)
		{
			sb.append("fom_centric = ");
			sb.append(fom_centric);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		d_res_high = null;
		d_res_low = null;
		delta_phi_final = null;
		delta_phi_initial = null;
		fom = null;
		fom_acentric = null;
		fom_centric = null;
		reflns = null;
		reflns_acentric = null;
		reflns_centric = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_phasing_dm_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_phasing_dm_shell>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (delta_phi_final != null) ow.write(indent + " <PDBx:delta_phi_final>" + delta_phi_final + "</PDBx:delta_phi_final>\n");
			if (delta_phi_initial != null) ow.write(indent + " <PDBx:delta_phi_initial>" + delta_phi_initial + "</PDBx:delta_phi_initial>\n");
			if (fom != null) ow.write(indent + " <PDBx:fom>" + fom + "</PDBx:fom>\n");
			if (fom_acentric != null) ow.write(indent + " <PDBx:fom_acentric>" + fom_acentric + "</PDBx:fom_acentric>\n");
			if (fom_centric != null) ow.write(indent + " <PDBx:fom_centric>" + fom_centric + "</PDBx:fom_centric>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			ow.write(indent + "</PDBx:pdbx_phasing_dm_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
