package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_POINT_SYMMETRY category record details about the
 *  point symmetry group associated with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_point_symmetryCategory>
 *  <PDBx:pdbx_point_symmetry entry_id="1ABC">
 *  <PDBx:Schoenflies_symbol>I</PDBx:Schoenflies_symbol>
 *  </PDBx:pdbx_point_symmetry>
 *  </PDBx:pdbx_point_symmetryCategory>
 * </pre>
 */
public class Pdbx_point_symmetry extends org.pdb.beans.Pdbx_point_symmetry implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_point_symmetry";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_point_symmetry()
	{
	}

	/** Full constructor */
	public Pdbx_point_symmetry(
		Datablock datablock,
		java.lang.String H_M_notation,
		java.lang.String Schoenflies_symbol,
		java.lang.Integer circular_symmetry,
		java.lang.String entry_id)
	{
		this.datablock = datablock;
		this.H_M_notation = H_M_notation;
		this.Schoenflies_symbol = Schoenflies_symbol;
		this.circular_symmetry = circular_symmetry;
		this.entry_id = entry_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_point_symmetry");
		sb.append("\n");
		if (H_M_notation != null)
		{
			sb.append("H-M_notation = ");
			sb.append(H_M_notation);
			sb.append('\n');
		}
		if (Schoenflies_symbol != null)
		{
			sb.append("Schoenflies_symbol = ");
			sb.append(Schoenflies_symbol);
			sb.append('\n');
		}
		if (circular_symmetry != null)
		{
			sb.append("circular_symmetry = ");
			sb.append(circular_symmetry);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		H_M_notation = null;
		Schoenflies_symbol = null;
		circular_symmetry = null;
		entry_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_point_symmetry)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_point_symmetry>\n");
			if (H_M_notation != null) ow.write(indent + " <PDBx:H-M_notation>" + H_M_notation + "</PDBx:H-M_notation>\n");
			if (Schoenflies_symbol != null) ow.write(indent + " <PDBx:Schoenflies_symbol>" + Schoenflies_symbol + "</PDBx:Schoenflies_symbol>\n");
			if (circular_symmetry != null) ow.write(indent + " <PDBx:circular_symmetry>" + circular_symmetry + "</PDBx:circular_symmetry>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			ow.write(indent + "</PDBx:pdbx_point_symmetry>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
