package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Describes the origin of the experimental data used in this
 *  entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_re_refinementCategory>
 *  <PDBx:pdbx_re_refinement entry_id="1ABC">
 *  <PDBx:citation_id>2</PDBx:citation_id>
 *  <PDBx:details>Re-refinement of data from entry 1ABC</PDBx:details>
 *  </PDBx:pdbx_re_refinement>
 *  </PDBx:pdbx_re_refinementCategory>
 * </pre>
 */
public class Pdbx_re_refinement extends org.pdb.beans.Pdbx_re_refinement implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_re_refinement";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_re_refinement()
	{
	}

	/** Full constructor */
	public Pdbx_re_refinement(
		Datablock datablock,
		java.lang.String citation_id,
		java.lang.String details,
		java.lang.String entry_id)
	{
		this.datablock = datablock;
		this.citation_id = citation_id;
		this.details = details;
		this.entry_id = entry_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_re_refinement");
		sb.append("\n");
		if (citation_id != null)
		{
			sb.append("citation_id = ");
			sb.append(citation_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		citation_id = null;
		details = null;
		entry_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_re_refinement)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_re_refinement>\n");
			if (citation_id != null) ow.write(indent + " <PDBx:citation_id>" + citation_id + "</PDBx:citation_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			ow.write(indent + "</PDBx:pdbx_re_refinement>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
