package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_REFINE category record details about
 *  additional structure refinement parameters which are needed
 *  to complete legacy REMARK 3 refinement templates in PDB
 *  format files.
 *  
 * <pre>
 *  Example 1 - PDB placeholders for refinement program SHELX
 *  <PDBx:pdbx_refineCategory>
 *  <PDBx:pdbx_refine entry_id="ABC001">
 *  <PDBx:R_factor_all_4sig_cutoff>0.174</PDBx:R_factor_all_4sig_cutoff>
 *  <PDBx:R_factor_obs_4sig_cutoff>0.169</PDBx:R_factor_obs_4sig_cutoff>
 *  <PDBx:number_reflns_obs_4sig_cutoff>1263.</PDBx:number_reflns_obs_4sig_cutoff>
 *  <PDBx:free_R_factor_4sig_cutoff>0.216</PDBx:free_R_factor_4sig_cutoff>
 *  <PDBx:free_R_val_test_set_ct_4sig_cutoff>164.</PDBx:free_R_val_test_set_ct_4sig_cutoff>
 *  <PDBx:free_R_val_test_set_size_perc_4sig_cutoff>1.29</PDBx:free_R_val_test_set_size_perc_4sig_cutoff>
 *  </PDBx:pdbx_refine>
 *  </PDBx:pdbx_refineCategory>
 * </pre>
 */
public class Pdbx_refine extends org.pdb.beans.Pdbx_refine implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_refine";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_refine()
	{
	}

	/** Full constructor */
	public Pdbx_refine(
		Datablock datablock,
		java.lang.Float R_factor_all_4sig_cutoff,
		java.lang.Float R_factor_all_no_cutoff,
		java.lang.Float R_factor_obs_4sig_cutoff,
		java.lang.Float R_factor_obs_no_cutoff,
		java.lang.String entry_id,
		java.lang.Float free_R_error_no_cutoff,
		java.lang.Float free_R_factor_4sig_cutoff,
		java.lang.Float free_R_factor_no_cutoff,
		java.lang.Float free_R_val_4sig_cutoff,
		java.lang.Float free_R_val_test_set_ct_4sig_cutoff,
		java.lang.Float free_R_val_test_set_ct_no_cutoff,
		java.lang.Float free_R_val_test_set_size_perc_4sig_cutoff,
		java.lang.Float free_R_val_test_set_size_perc_no_cutoff,
		java.lang.Float number_reflns_obs_4sig_cutoff,
		java.lang.Float number_reflns_obs_no_cutoff)
	{
		this.datablock = datablock;
		this.R_factor_all_4sig_cutoff = R_factor_all_4sig_cutoff;
		this.R_factor_all_no_cutoff = R_factor_all_no_cutoff;
		this.R_factor_obs_4sig_cutoff = R_factor_obs_4sig_cutoff;
		this.R_factor_obs_no_cutoff = R_factor_obs_no_cutoff;
		this.entry_id = entry_id;
		this.free_R_error_no_cutoff = free_R_error_no_cutoff;
		this.free_R_factor_4sig_cutoff = free_R_factor_4sig_cutoff;
		this.free_R_factor_no_cutoff = free_R_factor_no_cutoff;
		this.free_R_val_4sig_cutoff = free_R_val_4sig_cutoff;
		this.free_R_val_test_set_ct_4sig_cutoff = free_R_val_test_set_ct_4sig_cutoff;
		this.free_R_val_test_set_ct_no_cutoff = free_R_val_test_set_ct_no_cutoff;
		this.free_R_val_test_set_size_perc_4sig_cutoff = free_R_val_test_set_size_perc_4sig_cutoff;
		this.free_R_val_test_set_size_perc_no_cutoff = free_R_val_test_set_size_perc_no_cutoff;
		this.number_reflns_obs_4sig_cutoff = number_reflns_obs_4sig_cutoff;
		this.number_reflns_obs_no_cutoff = number_reflns_obs_no_cutoff;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_refine");
		sb.append("\n");
		if (R_factor_all_4sig_cutoff != null)
		{
			sb.append("R_factor_all_4sig_cutoff = ");
			sb.append(R_factor_all_4sig_cutoff);
			sb.append('\n');
		}
		if (R_factor_all_no_cutoff != null)
		{
			sb.append("R_factor_all_no_cutoff = ");
			sb.append(R_factor_all_no_cutoff);
			sb.append('\n');
		}
		if (R_factor_obs_4sig_cutoff != null)
		{
			sb.append("R_factor_obs_4sig_cutoff = ");
			sb.append(R_factor_obs_4sig_cutoff);
			sb.append('\n');
		}
		if (R_factor_obs_no_cutoff != null)
		{
			sb.append("R_factor_obs_no_cutoff = ");
			sb.append(R_factor_obs_no_cutoff);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (free_R_error_no_cutoff != null)
		{
			sb.append("free_R_error_no_cutoff = ");
			sb.append(free_R_error_no_cutoff);
			sb.append('\n');
		}
		if (free_R_factor_4sig_cutoff != null)
		{
			sb.append("free_R_factor_4sig_cutoff = ");
			sb.append(free_R_factor_4sig_cutoff);
			sb.append('\n');
		}
		if (free_R_factor_no_cutoff != null)
		{
			sb.append("free_R_factor_no_cutoff = ");
			sb.append(free_R_factor_no_cutoff);
			sb.append('\n');
		}
		if (free_R_val_4sig_cutoff != null)
		{
			sb.append("free_R_val_4sig_cutoff = ");
			sb.append(free_R_val_4sig_cutoff);
			sb.append('\n');
		}
		if (free_R_val_test_set_ct_4sig_cutoff != null)
		{
			sb.append("free_R_val_test_set_ct_4sig_cutoff = ");
			sb.append(free_R_val_test_set_ct_4sig_cutoff);
			sb.append('\n');
		}
		if (free_R_val_test_set_ct_no_cutoff != null)
		{
			sb.append("free_R_val_test_set_ct_no_cutoff = ");
			sb.append(free_R_val_test_set_ct_no_cutoff);
			sb.append('\n');
		}
		if (free_R_val_test_set_size_perc_4sig_cutoff != null)
		{
			sb.append("free_R_val_test_set_size_perc_4sig_cutoff = ");
			sb.append(free_R_val_test_set_size_perc_4sig_cutoff);
			sb.append('\n');
		}
		if (free_R_val_test_set_size_perc_no_cutoff != null)
		{
			sb.append("free_R_val_test_set_size_perc_no_cutoff = ");
			sb.append(free_R_val_test_set_size_perc_no_cutoff);
			sb.append('\n');
		}
		if (number_reflns_obs_4sig_cutoff != null)
		{
			sb.append("number_reflns_obs_4sig_cutoff = ");
			sb.append(number_reflns_obs_4sig_cutoff);
			sb.append('\n');
		}
		if (number_reflns_obs_no_cutoff != null)
		{
			sb.append("number_reflns_obs_no_cutoff = ");
			sb.append(number_reflns_obs_no_cutoff);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_factor_all_4sig_cutoff = null;
		R_factor_all_no_cutoff = null;
		R_factor_obs_4sig_cutoff = null;
		R_factor_obs_no_cutoff = null;
		entry_id = null;
		free_R_error_no_cutoff = null;
		free_R_factor_4sig_cutoff = null;
		free_R_factor_no_cutoff = null;
		free_R_val_4sig_cutoff = null;
		free_R_val_test_set_ct_4sig_cutoff = null;
		free_R_val_test_set_ct_no_cutoff = null;
		free_R_val_test_set_size_perc_4sig_cutoff = null;
		free_R_val_test_set_size_perc_no_cutoff = null;
		number_reflns_obs_4sig_cutoff = null;
		number_reflns_obs_no_cutoff = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_refine)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_refine>\n");
			if (R_factor_all_4sig_cutoff != null) ow.write(indent + " <PDBx:R_factor_all_4sig_cutoff>" + R_factor_all_4sig_cutoff + "</PDBx:R_factor_all_4sig_cutoff>\n");
			if (R_factor_all_no_cutoff != null) ow.write(indent + " <PDBx:R_factor_all_no_cutoff>" + R_factor_all_no_cutoff + "</PDBx:R_factor_all_no_cutoff>\n");
			if (R_factor_obs_4sig_cutoff != null) ow.write(indent + " <PDBx:R_factor_obs_4sig_cutoff>" + R_factor_obs_4sig_cutoff + "</PDBx:R_factor_obs_4sig_cutoff>\n");
			if (R_factor_obs_no_cutoff != null) ow.write(indent + " <PDBx:R_factor_obs_no_cutoff>" + R_factor_obs_no_cutoff + "</PDBx:R_factor_obs_no_cutoff>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (free_R_error_no_cutoff != null) ow.write(indent + " <PDBx:free_R_error_no_cutoff>" + free_R_error_no_cutoff + "</PDBx:free_R_error_no_cutoff>\n");
			if (free_R_factor_4sig_cutoff != null) ow.write(indent + " <PDBx:free_R_factor_4sig_cutoff>" + free_R_factor_4sig_cutoff + "</PDBx:free_R_factor_4sig_cutoff>\n");
			if (free_R_factor_no_cutoff != null) ow.write(indent + " <PDBx:free_R_factor_no_cutoff>" + free_R_factor_no_cutoff + "</PDBx:free_R_factor_no_cutoff>\n");
			if (free_R_val_4sig_cutoff != null) ow.write(indent + " <PDBx:free_R_val_4sig_cutoff>" + free_R_val_4sig_cutoff + "</PDBx:free_R_val_4sig_cutoff>\n");
			if (free_R_val_test_set_ct_4sig_cutoff != null) ow.write(indent + " <PDBx:free_R_val_test_set_ct_4sig_cutoff>" + free_R_val_test_set_ct_4sig_cutoff + "</PDBx:free_R_val_test_set_ct_4sig_cutoff>\n");
			if (free_R_val_test_set_ct_no_cutoff != null) ow.write(indent + " <PDBx:free_R_val_test_set_ct_no_cutoff>" + free_R_val_test_set_ct_no_cutoff + "</PDBx:free_R_val_test_set_ct_no_cutoff>\n");
			if (free_R_val_test_set_size_perc_4sig_cutoff != null) ow.write(indent + " <PDBx:free_R_val_test_set_size_perc_4sig_cutoff>" + free_R_val_test_set_size_perc_4sig_cutoff + "</PDBx:free_R_val_test_set_size_perc_4sig_cutoff>\n");
			if (free_R_val_test_set_size_perc_no_cutoff != null) ow.write(indent + " <PDBx:free_R_val_test_set_size_perc_no_cutoff>" + free_R_val_test_set_size_perc_no_cutoff + "</PDBx:free_R_val_test_set_size_perc_no_cutoff>\n");
			if (number_reflns_obs_4sig_cutoff != null) ow.write(indent + " <PDBx:number_reflns_obs_4sig_cutoff>" + number_reflns_obs_4sig_cutoff + "</PDBx:number_reflns_obs_4sig_cutoff>\n");
			if (number_reflns_obs_no_cutoff != null) ow.write(indent + " <PDBx:number_reflns_obs_no_cutoff>" + number_reflns_obs_no_cutoff + "</PDBx:number_reflns_obs_no_cutoff>\n");
			ow.write(indent + "</PDBx:pdbx_refine>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
