package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Auxilary parameter and topology files used in refinement.
 *  <PDBx:pdbx_refine_aux_fileCategory>
 *  <PDBx:pdbx_refine_aux_file serial_no="1">
 *  <PDBx:file_name>parm_hol.dat</PDBx:file_name>
 *  <PDBx:file_type>PARAMETER</PDBx:file_type>
 *  </PDBx:pdbx_refine_aux_file>
 *  </PDBx:pdbx_refine_aux_fileCategory>
 */
public class Pdbx_refine_aux_file extends org.pdb.beans.Pdbx_refine_aux_file implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_refine_aux_file";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_refine_aux_file()
	{
	}

	/** Full constructor */
	public Pdbx_refine_aux_file(
		Datablock datablock,
		java.lang.String file_name,
		java.lang.String file_type,
		java.lang.String serial_no)
	{
		this.datablock = datablock;
		this.file_name = file_name;
		this.file_type = file_type;
		this.serial_no = serial_no;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_refine_aux_file");
		sb.append("\n");
		if (file_name != null)
		{
			sb.append("file_name = ");
			sb.append(file_name);
			sb.append('\n');
		}
		if (file_type != null)
		{
			sb.append("file_type = ");
			sb.append(file_type);
			sb.append('\n');
		}
		if (serial_no != null)
		{
			sb.append("serial_no = ");
			sb.append(serial_no);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		file_name = null;
		file_type = null;
		serial_no = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_refine_aux_file)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_refine_aux_file>\n");
			if (file_name != null) ow.write(indent + " <PDBx:file_name>" + file_name + "</PDBx:file_name>\n");
			if (file_type != null) ow.write(indent + " <PDBx:file_type>" + file_type + "</PDBx:file_type>\n");
			if (serial_no != null) ow.write(indent + " <PDBx:serial_no>" + serial_no + "</PDBx:serial_no>\n");
			ow.write(indent + "</PDBx:pdbx_refine_aux_file>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
