package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_REFINE_COMPONENT category record
 *  statistics of the final model relative to the density map.
 *  
 * <pre>
 *  Example 1 -
 * </pre>
 */
public class Pdbx_refine_component extends org.pdb.beans.Pdbx_refine_component implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_refine_component";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_refine_component()
	{
	}

	/** Full constructor */
	public Pdbx_refine_component(
		Datablock datablock,
		java.lang.Float B_iso,
		java.lang.Float B_iso_main_chain,
		java.lang.Float B_iso_side_chain,
		java.lang.String auth_asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.Float connect,
		java.lang.Float correlation,
		java.lang.Float correlation_main_chain,
		java.lang.Float correlation_side_chain,
		java.lang.Float density_index,
		java.lang.Float density_index_main_chain,
		java.lang.Float density_index_side_chain,
		java.lang.Float density_ratio,
		java.lang.Float density_ratio_main_chain,
		java.lang.Float density_ratio_side_chain,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id,
		java.lang.Float real_space_R,
		java.lang.Float real_space_R_main_chain,
		java.lang.Float real_space_R_side_chain,
		java.lang.Float shift,
		java.lang.Float shift_main_chain,
		java.lang.Float shift_side_chain)
	{
		this.datablock = datablock;
		this.B_iso = B_iso;
		this.B_iso_main_chain = B_iso_main_chain;
		this.B_iso_side_chain = B_iso_side_chain;
		this.auth_asym_id = auth_asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.connect = connect;
		this.correlation = correlation;
		this.correlation_main_chain = correlation_main_chain;
		this.correlation_side_chain = correlation_side_chain;
		this.density_index = density_index;
		this.density_index_main_chain = density_index_main_chain;
		this.density_index_side_chain = density_index_side_chain;
		this.density_ratio = density_ratio;
		this.density_ratio_main_chain = density_ratio_main_chain;
		this.density_ratio_side_chain = density_ratio_side_chain;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
		this.real_space_R = real_space_R;
		this.real_space_R_main_chain = real_space_R_main_chain;
		this.real_space_R_side_chain = real_space_R_side_chain;
		this.shift = shift;
		this.shift_main_chain = shift_main_chain;
		this.shift_side_chain = shift_side_chain;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_refine_component");
		sb.append("\n");
		if (B_iso != null)
		{
			sb.append("B_iso = ");
			sb.append(B_iso);
			sb.append('\n');
		}
		if (B_iso_main_chain != null)
		{
			sb.append("B_iso_main_chain = ");
			sb.append(B_iso_main_chain);
			sb.append('\n');
		}
		if (B_iso_side_chain != null)
		{
			sb.append("B_iso_side_chain = ");
			sb.append(B_iso_side_chain);
			sb.append('\n');
		}
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (connect != null)
		{
			sb.append("connect = ");
			sb.append(connect);
			sb.append('\n');
		}
		if (correlation != null)
		{
			sb.append("correlation = ");
			sb.append(correlation);
			sb.append('\n');
		}
		if (correlation_main_chain != null)
		{
			sb.append("correlation_main_chain = ");
			sb.append(correlation_main_chain);
			sb.append('\n');
		}
		if (correlation_side_chain != null)
		{
			sb.append("correlation_side_chain = ");
			sb.append(correlation_side_chain);
			sb.append('\n');
		}
		if (density_index != null)
		{
			sb.append("density_index = ");
			sb.append(density_index);
			sb.append('\n');
		}
		if (density_index_main_chain != null)
		{
			sb.append("density_index_main_chain = ");
			sb.append(density_index_main_chain);
			sb.append('\n');
		}
		if (density_index_side_chain != null)
		{
			sb.append("density_index_side_chain = ");
			sb.append(density_index_side_chain);
			sb.append('\n');
		}
		if (density_ratio != null)
		{
			sb.append("density_ratio = ");
			sb.append(density_ratio);
			sb.append('\n');
		}
		if (density_ratio_main_chain != null)
		{
			sb.append("density_ratio_main_chain = ");
			sb.append(density_ratio_main_chain);
			sb.append('\n');
		}
		if (density_ratio_side_chain != null)
		{
			sb.append("density_ratio_side_chain = ");
			sb.append(density_ratio_side_chain);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		if (real_space_R != null)
		{
			sb.append("real_space_R = ");
			sb.append(real_space_R);
			sb.append('\n');
		}
		if (real_space_R_main_chain != null)
		{
			sb.append("real_space_R_main_chain = ");
			sb.append(real_space_R_main_chain);
			sb.append('\n');
		}
		if (real_space_R_side_chain != null)
		{
			sb.append("real_space_R_side_chain = ");
			sb.append(real_space_R_side_chain);
			sb.append('\n');
		}
		if (shift != null)
		{
			sb.append("shift = ");
			sb.append(shift);
			sb.append('\n');
		}
		if (shift_main_chain != null)
		{
			sb.append("shift_main_chain = ");
			sb.append(shift_main_chain);
			sb.append('\n');
		}
		if (shift_side_chain != null)
		{
			sb.append("shift_side_chain = ");
			sb.append(shift_side_chain);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B_iso = null;
		B_iso_main_chain = null;
		B_iso_side_chain = null;
		auth_asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		connect = null;
		correlation = null;
		correlation_main_chain = null;
		correlation_side_chain = null;
		density_index = null;
		density_index_main_chain = null;
		density_index_side_chain = null;
		density_ratio = null;
		density_ratio_main_chain = null;
		density_ratio_side_chain = null;
		label_alt_id = null;
		label_asym_id = null;
		label_comp_id = null;
		label_seq_id = null;
		real_space_R = null;
		real_space_R_main_chain = null;
		real_space_R_side_chain = null;
		shift = null;
		shift_main_chain = null;
		shift_side_chain = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_refine_component)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_refine_component>\n");
			if (B_iso != null) ow.write(indent + " <PDBx:B_iso>" + B_iso + "</PDBx:B_iso>\n");
			if (B_iso_main_chain != null) ow.write(indent + " <PDBx:B_iso_main_chain>" + B_iso_main_chain + "</PDBx:B_iso_main_chain>\n");
			if (B_iso_side_chain != null) ow.write(indent + " <PDBx:B_iso_side_chain>" + B_iso_side_chain + "</PDBx:B_iso_side_chain>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (connect != null) ow.write(indent + " <PDBx:connect>" + connect + "</PDBx:connect>\n");
			if (correlation != null) ow.write(indent + " <PDBx:correlation>" + correlation + "</PDBx:correlation>\n");
			if (correlation_main_chain != null) ow.write(indent + " <PDBx:correlation_main_chain>" + correlation_main_chain + "</PDBx:correlation_main_chain>\n");
			if (correlation_side_chain != null) ow.write(indent + " <PDBx:correlation_side_chain>" + correlation_side_chain + "</PDBx:correlation_side_chain>\n");
			if (density_index != null) ow.write(indent + " <PDBx:density_index>" + density_index + "</PDBx:density_index>\n");
			if (density_index_main_chain != null) ow.write(indent + " <PDBx:density_index_main_chain>" + density_index_main_chain + "</PDBx:density_index_main_chain>\n");
			if (density_index_side_chain != null) ow.write(indent + " <PDBx:density_index_side_chain>" + density_index_side_chain + "</PDBx:density_index_side_chain>\n");
			if (density_ratio != null) ow.write(indent + " <PDBx:density_ratio>" + density_ratio + "</PDBx:density_ratio>\n");
			if (density_ratio_main_chain != null) ow.write(indent + " <PDBx:density_ratio_main_chain>" + density_ratio_main_chain + "</PDBx:density_ratio_main_chain>\n");
			if (density_ratio_side_chain != null) ow.write(indent + " <PDBx:density_ratio_side_chain>" + density_ratio_side_chain + "</PDBx:density_ratio_side_chain>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			if (real_space_R != null) ow.write(indent + " <PDBx:real_space_R>" + real_space_R + "</PDBx:real_space_R>\n");
			if (real_space_R_main_chain != null) ow.write(indent + " <PDBx:real_space_R_main_chain>" + real_space_R_main_chain + "</PDBx:real_space_R_main_chain>\n");
			if (real_space_R_side_chain != null) ow.write(indent + " <PDBx:real_space_R_side_chain>" + real_space_R_side_chain + "</PDBx:real_space_R_side_chain>\n");
			if (shift != null) ow.write(indent + " <PDBx:shift>" + shift + "</PDBx:shift>\n");
			if (shift_main_chain != null) ow.write(indent + " <PDBx:shift_main_chain>" + shift_main_chain + "</PDBx:shift_main_chain>\n");
			if (shift_side_chain != null) ow.write(indent + " <PDBx:shift_side_chain>" + shift_side_chain + "</PDBx:shift_side_chain>\n");
			ow.write(indent + "</PDBx:pdbx_refine_component>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
