package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Details decribing crystallographic twinning.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_reflns_twinCategory>
 *  <PDBx:pdbx_reflns_twin diffrn_id="1" crystal_id="1">
 *  <PDBx:type>merohedral</PDBx:type>
 *  <PDBx:operator>h,-h-k,-l</PDBx:operator>
 *  <PDBx:fraction>.43</PDBx:fraction>
 *  <PDBx:mean_I2_over_mean_I_square>1.3</PDBx:mean_I2_over_mean_I_square>
 *  <PDBx:mean_F_square_over_mean_F2>.84</PDBx:mean_F_square_over_mean_F2>
 *  </PDBx:pdbx_reflns_twin>
 *  </PDBx:pdbx_reflns_twinCategory>
 * </pre>
 */
public class Pdbx_reflns_twin extends org.pdb.beans.Pdbx_reflns_twin implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_reflns_twin";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_reflns_twin()
	{
	}

	/** Full constructor */
	public Pdbx_reflns_twin(
		Datablock datablock,
		java.lang.String crystal_id,
		java.lang.String diffrn_id,
		java.lang.Float fraction,
		java.lang.Float mean_F_square_over_mean_F2,
		java.lang.Float mean_I2_over_mean_I_square,
		java.lang.String operator,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.crystal_id = crystal_id;
		this.diffrn_id = diffrn_id;
		this.fraction = fraction;
		this.mean_F_square_over_mean_F2 = mean_F_square_over_mean_F2;
		this.mean_I2_over_mean_I_square = mean_I2_over_mean_I_square;
		this.operator = operator;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_reflns_twin");
		sb.append("\n");
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (diffrn_id != null)
		{
			sb.append("diffrn_id = ");
			sb.append(diffrn_id);
			sb.append('\n');
		}
		if (fraction != null)
		{
			sb.append("fraction = ");
			sb.append(fraction);
			sb.append('\n');
		}
		if (mean_F_square_over_mean_F2 != null)
		{
			sb.append("mean_F_square_over_mean_F2 = ");
			sb.append(mean_F_square_over_mean_F2);
			sb.append('\n');
		}
		if (mean_I2_over_mean_I_square != null)
		{
			sb.append("mean_I2_over_mean_I_square = ");
			sb.append(mean_I2_over_mean_I_square);
			sb.append('\n');
		}
		if (operator != null)
		{
			sb.append("operator = ");
			sb.append(operator);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		crystal_id = null;
		diffrn_id = null;
		fraction = null;
		mean_F_square_over_mean_F2 = null;
		mean_I2_over_mean_I_square = null;
		operator = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_reflns_twin)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_reflns_twin>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (diffrn_id != null) ow.write(indent + " <PDBx:diffrn_id>" + diffrn_id + "</PDBx:diffrn_id>\n");
			if (fraction != null) ow.write(indent + " <PDBx:fraction>" + fraction + "</PDBx:fraction>\n");
			if (mean_F_square_over_mean_F2 != null) ow.write(indent + " <PDBx:mean_F_square_over_mean_F2>" + mean_F_square_over_mean_F2 + "</PDBx:mean_F_square_over_mean_F2>\n");
			if (mean_I2_over_mean_I_square != null) ow.write(indent + " <PDBx:mean_I2_over_mean_I_square>" + mean_I2_over_mean_I_square + "</PDBx:mean_I2_over_mean_I_square>\n");
			if (operator != null) ow.write(indent + " <PDBx:operator>" + operator + "</PDBx:operator>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_reflns_twin>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
