package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_SOLN_SCATTER category record details about a
 *  solution scattering experiment
 * <pre>
 *  Example 1 - based on PDB entry 1HAQ
 *  <PDBx:pdbx_soln_scatterCategory>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="1">
 *  <PDBx:type>x-ray</PDBx:type>
 *  <PDBx:source_type>SRS BEAMLINE 2.1</PDBx:source_type>
 *  <PDBx:source_class>synchrotron</PDBx:source_class>
 *  <PDBx:source_beamline>2.1</PDBx:source_beamline>
 *  <PDBx:detector_type>500-channel quadrant</PDBx:detector_type>
 *  <PDBx:temperature>288.</PDBx:temperature>
 *  <PDBx:num_time_frames>10</PDBx:num_time_frames>
 *  <PDBx:concentration_range>0.7 - 14</PDBx:concentration_range>
 *  <PDBx:buffer_name>tris</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.1</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.4</PDBx:mean_guiner_radius_esd>
 *  <PDBx:min_mean_cross_sectional_radii_gyration>4.4</PDBx:min_mean_cross_sectional_radii_gyration>
 *  <PDBx:min_mean_cross_sectional_radii_gyration_esd>0.2</PDBx:min_mean_cross_sectional_radii_gyration_esd>
 *  <PDBx:max_mean_cross_sectional_radii_gyration>1.7</PDBx:max_mean_cross_sectional_radii_gyration>
 *  <PDBx:protein_length>40</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="2">
 *  <PDBx:type>neutron</PDBx:type>
 *  <PDBx:source_type>ILL</PDBx:source_type>
 *  <PDBx:source_class>neutron source</PDBx:source_class>
 *  <PDBx:source_beamline_instrument>D11, D22</PDBx:source_beamline_instrument>
 *  <PDBx:detector_type>area</PDBx:detector_type>
 *  <PDBx:concentration_range>0.4 - 9.6</PDBx:concentration_range>
 *  <PDBx:buffer_name>PBS in 99.9&#37; D2O</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.3</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.4</PDBx:mean_guiner_radius_esd>
 *  <PDBx:min_mean_cross_sectional_radii_gyration>3.9</PDBx:min_mean_cross_sectional_radii_gyration>
 *  <PDBx:min_mean_cross_sectional_radii_gyration_esd>0.2</PDBx:min_mean_cross_sectional_radii_gyration_esd>
 *  <PDBx:max_mean_cross_sectional_radii_gyration>1.51</PDBx:max_mean_cross_sectional_radii_gyration>
 *  <PDBx:protein_length>37.0 - 39.0</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  <PDBx:pdbx_soln_scatter entry_id="1HAQ" id="3">
 *  <PDBx:type>neutron</PDBx:type>
 *  <PDBx:source_type>ISIS</PDBx:source_type>
 *  <PDBx:source_class>neutron source</PDBx:source_class>
 *  <PDBx:source_beamline>Pulsed Neutron</PDBx:source_beamline>
 *  <PDBx:source_beamline_instrument>LOQ</PDBx:source_beamline_instrument>
 *  <PDBx:detector_type>AREA (TIME-OF-FLIGHT)</PDBx:detector_type>
 *  <PDBx:concentration_range>3.7, 6.1</PDBx:concentration_range>
 *  <PDBx:buffer_name>PBS in 99.9&#37; D2O</PDBx:buffer_name>
 *  <PDBx:mean_guiner_radius>11.7</PDBx:mean_guiner_radius>
 *  <PDBx:mean_guiner_radius_esd>0.5</PDBx:mean_guiner_radius_esd>
 *  <PDBx:protein_length>40.0</PDBx:protein_length>
 *  </PDBx:pdbx_soln_scatter>
 *  </PDBx:pdbx_soln_scatterCategory>
 * </pre>
 */
public class Pdbx_soln_scatter extends org.pdb.beans.Pdbx_soln_scatter implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_soln_scatter";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_soln_scatter()
	{
	}

	/** Full constructor */
	public Pdbx_soln_scatter(
		Datablock datablock,
		java.lang.String buffer_name,
		java.lang.Float concentration_range,
		java.lang.String data_analysis_software_list,
		java.lang.String data_reduction_software_list,
		java.lang.String detector_specific,
		java.lang.String detector_type,
		java.lang.String entry_id,
		java.lang.String id_,
		java.lang.Float max_mean_cross_sectional_radii_gyration,
		java.lang.Float max_mean_cross_sectional_radii_gyration_esd,
		java.lang.Float mean_guiner_radius,
		java.lang.Float mean_guiner_radius_esd,
		java.lang.Float min_mean_cross_sectional_radii_gyration,
		java.lang.Float min_mean_cross_sectional_radii_gyration_esd,
		java.lang.Integer num_time_frames,
		java.lang.String protein_length,
		java.lang.Float sample_pH,
		java.lang.String source_beamline,
		java.lang.String source_beamline_instrument,
		java.lang.String source_class,
		java.lang.String source_type,
		java.lang.Float temperature,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.buffer_name = buffer_name;
		this.concentration_range = concentration_range;
		this.data_analysis_software_list = data_analysis_software_list;
		this.data_reduction_software_list = data_reduction_software_list;
		this.detector_specific = detector_specific;
		this.detector_type = detector_type;
		this.entry_id = entry_id;
		this.id_ = id_;
		this.max_mean_cross_sectional_radii_gyration = max_mean_cross_sectional_radii_gyration;
		this.max_mean_cross_sectional_radii_gyration_esd = max_mean_cross_sectional_radii_gyration_esd;
		this.mean_guiner_radius = mean_guiner_radius;
		this.mean_guiner_radius_esd = mean_guiner_radius_esd;
		this.min_mean_cross_sectional_radii_gyration = min_mean_cross_sectional_radii_gyration;
		this.min_mean_cross_sectional_radii_gyration_esd = min_mean_cross_sectional_radii_gyration_esd;
		this.num_time_frames = num_time_frames;
		this.protein_length = protein_length;
		this.sample_pH = sample_pH;
		this.source_beamline = source_beamline;
		this.source_beamline_instrument = source_beamline_instrument;
		this.source_class = source_class;
		this.source_type = source_type;
		this.temperature = temperature;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_soln_scatter");
		sb.append("\n");
		if (buffer_name != null)
		{
			sb.append("buffer_name = ");
			sb.append(buffer_name);
			sb.append('\n');
		}
		if (concentration_range != null)
		{
			sb.append("concentration_range = ");
			sb.append(concentration_range);
			sb.append('\n');
		}
		if (data_analysis_software_list != null)
		{
			sb.append("data_analysis_software_list = ");
			sb.append(data_analysis_software_list);
			sb.append('\n');
		}
		if (data_reduction_software_list != null)
		{
			sb.append("data_reduction_software_list = ");
			sb.append(data_reduction_software_list);
			sb.append('\n');
		}
		if (detector_specific != null)
		{
			sb.append("detector_specific = ");
			sb.append(detector_specific);
			sb.append('\n');
		}
		if (detector_type != null)
		{
			sb.append("detector_type = ");
			sb.append(detector_type);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (max_mean_cross_sectional_radii_gyration != null)
		{
			sb.append("max_mean_cross_sectional_radii_gyration = ");
			sb.append(max_mean_cross_sectional_radii_gyration);
			sb.append('\n');
		}
		if (max_mean_cross_sectional_radii_gyration_esd != null)
		{
			sb.append("max_mean_cross_sectional_radii_gyration_esd = ");
			sb.append(max_mean_cross_sectional_radii_gyration_esd);
			sb.append('\n');
		}
		if (mean_guiner_radius != null)
		{
			sb.append("mean_guiner_radius = ");
			sb.append(mean_guiner_radius);
			sb.append('\n');
		}
		if (mean_guiner_radius_esd != null)
		{
			sb.append("mean_guiner_radius_esd = ");
			sb.append(mean_guiner_radius_esd);
			sb.append('\n');
		}
		if (min_mean_cross_sectional_radii_gyration != null)
		{
			sb.append("min_mean_cross_sectional_radii_gyration = ");
			sb.append(min_mean_cross_sectional_radii_gyration);
			sb.append('\n');
		}
		if (min_mean_cross_sectional_radii_gyration_esd != null)
		{
			sb.append("min_mean_cross_sectional_radii_gyration_esd = ");
			sb.append(min_mean_cross_sectional_radii_gyration_esd);
			sb.append('\n');
		}
		if (num_time_frames != null)
		{
			sb.append("num_time_frames = ");
			sb.append(num_time_frames);
			sb.append('\n');
		}
		if (protein_length != null)
		{
			sb.append("protein_length = ");
			sb.append(protein_length);
			sb.append('\n');
		}
		if (sample_pH != null)
		{
			sb.append("sample_pH = ");
			sb.append(sample_pH);
			sb.append('\n');
		}
		if (source_beamline != null)
		{
			sb.append("source_beamline = ");
			sb.append(source_beamline);
			sb.append('\n');
		}
		if (source_beamline_instrument != null)
		{
			sb.append("source_beamline_instrument = ");
			sb.append(source_beamline_instrument);
			sb.append('\n');
		}
		if (source_class != null)
		{
			sb.append("source_class = ");
			sb.append(source_class);
			sb.append('\n');
		}
		if (source_type != null)
		{
			sb.append("source_type = ");
			sb.append(source_type);
			sb.append('\n');
		}
		if (temperature != null)
		{
			sb.append("temperature = ");
			sb.append(temperature);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		buffer_name = null;
		concentration_range = null;
		data_analysis_software_list = null;
		data_reduction_software_list = null;
		detector_specific = null;
		detector_type = null;
		entry_id = null;
		id_ = null;
		max_mean_cross_sectional_radii_gyration = null;
		max_mean_cross_sectional_radii_gyration_esd = null;
		mean_guiner_radius = null;
		mean_guiner_radius_esd = null;
		min_mean_cross_sectional_radii_gyration = null;
		min_mean_cross_sectional_radii_gyration_esd = null;
		num_time_frames = null;
		protein_length = null;
		sample_pH = null;
		source_beamline = null;
		source_beamline_instrument = null;
		source_class = null;
		source_type = null;
		temperature = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_soln_scatter)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_soln_scatter>\n");
			if (buffer_name != null) ow.write(indent + " <PDBx:buffer_name>" + buffer_name + "</PDBx:buffer_name>\n");
			if (concentration_range != null) ow.write(indent + " <PDBx:concentration_range>" + concentration_range + "</PDBx:concentration_range>\n");
			if (data_analysis_software_list != null) ow.write(indent + " <PDBx:data_analysis_software_list>" + data_analysis_software_list + "</PDBx:data_analysis_software_list>\n");
			if (data_reduction_software_list != null) ow.write(indent + " <PDBx:data_reduction_software_list>" + data_reduction_software_list + "</PDBx:data_reduction_software_list>\n");
			if (detector_specific != null) ow.write(indent + " <PDBx:detector_specific>" + detector_specific + "</PDBx:detector_specific>\n");
			if (detector_type != null) ow.write(indent + " <PDBx:detector_type>" + detector_type + "</PDBx:detector_type>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (max_mean_cross_sectional_radii_gyration != null) ow.write(indent + " <PDBx:max_mean_cross_sectional_radii_gyration>" + max_mean_cross_sectional_radii_gyration + "</PDBx:max_mean_cross_sectional_radii_gyration>\n");
			if (max_mean_cross_sectional_radii_gyration_esd != null) ow.write(indent + " <PDBx:max_mean_cross_sectional_radii_gyration_esd>" + max_mean_cross_sectional_radii_gyration_esd + "</PDBx:max_mean_cross_sectional_radii_gyration_esd>\n");
			if (mean_guiner_radius != null) ow.write(indent + " <PDBx:mean_guiner_radius>" + mean_guiner_radius + "</PDBx:mean_guiner_radius>\n");
			if (mean_guiner_radius_esd != null) ow.write(indent + " <PDBx:mean_guiner_radius_esd>" + mean_guiner_radius_esd + "</PDBx:mean_guiner_radius_esd>\n");
			if (min_mean_cross_sectional_radii_gyration != null) ow.write(indent + " <PDBx:min_mean_cross_sectional_radii_gyration>" + min_mean_cross_sectional_radii_gyration + "</PDBx:min_mean_cross_sectional_radii_gyration>\n");
			if (min_mean_cross_sectional_radii_gyration_esd != null) ow.write(indent + " <PDBx:min_mean_cross_sectional_radii_gyration_esd>" + min_mean_cross_sectional_radii_gyration_esd + "</PDBx:min_mean_cross_sectional_radii_gyration_esd>\n");
			if (num_time_frames != null) ow.write(indent + " <PDBx:num_time_frames>" + num_time_frames + "</PDBx:num_time_frames>\n");
			if (protein_length != null) ow.write(indent + " <PDBx:protein_length>" + protein_length + "</PDBx:protein_length>\n");
			if (sample_pH != null) ow.write(indent + " <PDBx:sample_pH>" + sample_pH + "</PDBx:sample_pH>\n");
			if (source_beamline != null) ow.write(indent + " <PDBx:source_beamline>" + source_beamline + "</PDBx:source_beamline>\n");
			if (source_beamline_instrument != null) ow.write(indent + " <PDBx:source_beamline_instrument>" + source_beamline_instrument + "</PDBx:source_beamline_instrument>\n");
			if (source_class != null) ow.write(indent + " <PDBx:source_class>" + source_class + "</PDBx:source_class>\n");
			if (source_type != null) ow.write(indent + " <PDBx:source_type>" + source_type + "</PDBx:source_type>\n");
			if (temperature != null) ow.write(indent + " <PDBx:temperature>" + temperature + "</PDBx:temperature>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:pdbx_soln_scatter>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
