package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_OPER_LIST category describe
 *  Cartesian rotation and translation operations required to
 *  generate or transform the coordinates deposited with this entry.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_oper_listCategory>
 *  <PDBx:pdbx_struct_oper_list id="2">
 *  <PDBx:matrix11>0.247</PDBx:matrix11>
 *  <PDBx:matrix12>0.935</PDBx:matrix12>
 *  <PDBx:matrix13>0.256</PDBx:matrix13>
 *  <PDBx:matrix21>0.929</PDBx:matrix21>
 *  <PDBx:matrix22>0.153</PDBx:matrix22>
 *  <PDBx:matrix23>0.337</PDBx:matrix23>
 *  <PDBx:matrix31>0.276</PDBx:matrix31>
 *  <PDBx:matrix32>0.321</PDBx:matrix32>
 *  <PDBx:matrix33>-0.906</PDBx:matrix33>
 *  <PDBx:vector1>-8.253</PDBx:vector1>
 *  <PDBx:vector2>-11.743</PDBx:vector2>
 *  <PDBx:vector3>-1.782</PDBx:vector3>
 *  <PDBx:type>point symmetry operation</PDBx:type>
 *  </PDBx:pdbx_struct_oper_list>
 *  </PDBx:pdbx_struct_oper_listCategory>
 * </pre>
 */
public class Pdbx_struct_oper_list extends org.pdb.beans.Pdbx_struct_oper_list implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_oper_list";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_oper_list()
	{
	}

	/** Full constructor */
	public Pdbx_struct_oper_list(
		Datablock datablock,
		java.lang.String id_,
		java.lang.Float matrix11,
		java.lang.Float matrix12,
		java.lang.Float matrix13,
		java.lang.Float matrix21,
		java.lang.Float matrix22,
		java.lang.Float matrix23,
		java.lang.Float matrix31,
		java.lang.Float matrix32,
		java.lang.Float matrix33,
		java.lang.String name,
		java.lang.String type,
		java.lang.Float vector1,
		java.lang.Float vector2,
		java.lang.Float vector3)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.matrix11 = matrix11;
		this.matrix12 = matrix12;
		this.matrix13 = matrix13;
		this.matrix21 = matrix21;
		this.matrix22 = matrix22;
		this.matrix23 = matrix23;
		this.matrix31 = matrix31;
		this.matrix32 = matrix32;
		this.matrix33 = matrix33;
		this.name = name;
		this.type = type;
		this.vector1 = vector1;
		this.vector2 = vector2;
		this.vector3 = vector3;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_oper_list");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (matrix11 != null)
		{
			sb.append("matrix11 = ");
			sb.append(matrix11);
			sb.append('\n');
		}
		if (matrix12 != null)
		{
			sb.append("matrix12 = ");
			sb.append(matrix12);
			sb.append('\n');
		}
		if (matrix13 != null)
		{
			sb.append("matrix13 = ");
			sb.append(matrix13);
			sb.append('\n');
		}
		if (matrix21 != null)
		{
			sb.append("matrix21 = ");
			sb.append(matrix21);
			sb.append('\n');
		}
		if (matrix22 != null)
		{
			sb.append("matrix22 = ");
			sb.append(matrix22);
			sb.append('\n');
		}
		if (matrix23 != null)
		{
			sb.append("matrix23 = ");
			sb.append(matrix23);
			sb.append('\n');
		}
		if (matrix31 != null)
		{
			sb.append("matrix31 = ");
			sb.append(matrix31);
			sb.append('\n');
		}
		if (matrix32 != null)
		{
			sb.append("matrix32 = ");
			sb.append(matrix32);
			sb.append('\n');
		}
		if (matrix33 != null)
		{
			sb.append("matrix33 = ");
			sb.append(matrix33);
			sb.append('\n');
		}
		if (name != null)
		{
			sb.append("name = ");
			sb.append(name);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (vector1 != null)
		{
			sb.append("vector1 = ");
			sb.append(vector1);
			sb.append('\n');
		}
		if (vector2 != null)
		{
			sb.append("vector2 = ");
			sb.append(vector2);
			sb.append('\n');
		}
		if (vector3 != null)
		{
			sb.append("vector3 = ");
			sb.append(vector3);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		matrix11 = null;
		matrix12 = null;
		matrix13 = null;
		matrix21 = null;
		matrix22 = null;
		matrix23 = null;
		matrix31 = null;
		matrix32 = null;
		matrix33 = null;
		name = null;
		type = null;
		vector1 = null;
		vector2 = null;
		vector3 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_oper_list)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_oper_list>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (matrix11 != null) ow.write(indent + " <PDBx:matrix11>" + matrix11 + "</PDBx:matrix11>\n");
			if (matrix12 != null) ow.write(indent + " <PDBx:matrix12>" + matrix12 + "</PDBx:matrix12>\n");
			if (matrix13 != null) ow.write(indent + " <PDBx:matrix13>" + matrix13 + "</PDBx:matrix13>\n");
			if (matrix21 != null) ow.write(indent + " <PDBx:matrix21>" + matrix21 + "</PDBx:matrix21>\n");
			if (matrix22 != null) ow.write(indent + " <PDBx:matrix22>" + matrix22 + "</PDBx:matrix22>\n");
			if (matrix23 != null) ow.write(indent + " <PDBx:matrix23>" + matrix23 + "</PDBx:matrix23>\n");
			if (matrix31 != null) ow.write(indent + " <PDBx:matrix31>" + matrix31 + "</PDBx:matrix31>\n");
			if (matrix32 != null) ow.write(indent + " <PDBx:matrix32>" + matrix32 + "</PDBx:matrix32>\n");
			if (matrix33 != null) ow.write(indent + " <PDBx:matrix33>" + matrix33 + "</PDBx:matrix33>\n");
			if (name != null) ow.write(indent + " <PDBx:name>" + name + "</PDBx:name>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (vector1 != null) ow.write(indent + " <PDBx:vector1>" + vector1 + "</PDBx:vector1>\n");
			if (vector2 != null) ow.write(indent + " <PDBx:vector2>" + vector2 + "</PDBx:vector2>\n");
			if (vector3 != null) ow.write(indent + " <PDBx:vector3>" + vector3 + "</PDBx:vector3>\n");
			ow.write(indent + "</PDBx:pdbx_struct_oper_list>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
