package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_REF_SEQ_FEATURE_PROP category provide a
 *  mechanism for identifying and annotating properties of sequence features.
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_struct_ref_seq_feature_propCategory>
 *  <PDBx:pdbx_struct_ref_seq_feature_prop feature_id="1" property_id="1">
 *  <PDBx:beg_db_mon_id>GLU</PDBx:beg_db_mon_id>
 *  <PDBx:end_db_mon_id>PHE</PDBx:end_db_mon_id>
 *  <PDBx:beg_db_seq_id>100</PDBx:beg_db_seq_id>
 *  <PDBx:end_db_seq_id>104</PDBx:end_db_seq_id>
 *  <PDBx:type>VARIABLE_SPLICING</PDBx:type>
 *  <PDBx:value>VSP_003456</PDBx:value>
 *  <PDBx:details>  Special splice at ... </PDBx:details>
 *  </PDBx:pdbx_struct_ref_seq_feature_prop>
 *  </PDBx:pdbx_struct_ref_seq_feature_propCategory>
 * </pre>
 */
public class Pdbx_struct_ref_seq_feature_prop extends org.pdb.beans.Pdbx_struct_ref_seq_feature_prop implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_ref_seq_feature_prop";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_ref_seq_feature_prop()
	{
	}

	/** Full constructor */
	public Pdbx_struct_ref_seq_feature_prop(
		Datablock datablock,
		java.lang.String beg_db_mon_id,
		java.lang.Integer beg_db_seq_id,
		java.lang.String details,
		java.lang.String end_db_mon_id,
		java.lang.Integer end_db_seq_id,
		java.lang.Integer feature_id,
		java.lang.Integer property_id,
		java.lang.String type,
		java.lang.String value)
	{
		this.datablock = datablock;
		this.beg_db_mon_id = beg_db_mon_id;
		this.beg_db_seq_id = beg_db_seq_id;
		this.details = details;
		this.end_db_mon_id = end_db_mon_id;
		this.end_db_seq_id = end_db_seq_id;
		this.feature_id = feature_id;
		this.property_id = property_id;
		this.type = type;
		this.value = value;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_ref_seq_feature_prop");
		sb.append("\n");
		if (beg_db_mon_id != null)
		{
			sb.append("beg_db_mon_id = ");
			sb.append(beg_db_mon_id);
			sb.append('\n');
		}
		if (beg_db_seq_id != null)
		{
			sb.append("beg_db_seq_id = ");
			sb.append(beg_db_seq_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (end_db_mon_id != null)
		{
			sb.append("end_db_mon_id = ");
			sb.append(end_db_mon_id);
			sb.append('\n');
		}
		if (end_db_seq_id != null)
		{
			sb.append("end_db_seq_id = ");
			sb.append(end_db_seq_id);
			sb.append('\n');
		}
		if (feature_id != null)
		{
			sb.append("feature_id = ");
			sb.append(feature_id);
			sb.append('\n');
		}
		if (property_id != null)
		{
			sb.append("property_id = ");
			sb.append(property_id);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_db_mon_id = null;
		beg_db_seq_id = null;
		details = null;
		end_db_mon_id = null;
		end_db_seq_id = null;
		feature_id = null;
		property_id = null;
		type = null;
		value = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_ref_seq_feature_prop)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_ref_seq_feature_prop>\n");
			if (beg_db_mon_id != null) ow.write(indent + " <PDBx:beg_db_mon_id>" + beg_db_mon_id + "</PDBx:beg_db_mon_id>\n");
			if (beg_db_seq_id != null) ow.write(indent + " <PDBx:beg_db_seq_id>" + beg_db_seq_id + "</PDBx:beg_db_seq_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (end_db_mon_id != null) ow.write(indent + " <PDBx:end_db_mon_id>" + end_db_mon_id + "</PDBx:end_db_mon_id>\n");
			if (end_db_seq_id != null) ow.write(indent + " <PDBx:end_db_seq_id>" + end_db_seq_id + "</PDBx:end_db_seq_id>\n");
			if (feature_id != null) ow.write(indent + " <PDBx:feature_id>" + feature_id + "</PDBx:feature_id>\n");
			if (property_id != null) ow.write(indent + " <PDBx:property_id>" + property_id + "</PDBx:property_id>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			ow.write(indent + "</PDBx:pdbx_struct_ref_seq_feature_prop>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
