package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_STRUCT_SHEET_HBOND category record details
 *  about the hydrogen bonding between residue ranges in a beta sheet.
 *  This category is provided for cases where only a single hydrogen
 *  bond is used to register the two residue ranges.   Category
 *  STRUCT_SHEET_HBOND should be used when the initial and terminal
 *  hydrogen bonds for strand pair are known.
 */
public class Pdbx_struct_sheet_hbond extends org.pdb.beans.Pdbx_struct_sheet_hbond implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_struct_sheet_hbond";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_struct_sheet_hbond()
	{
	}

	/** Full constructor */
	public Pdbx_struct_sheet_hbond(
		Datablock datablock,
		java.lang.String range_1_PDB_ins_code,
		java.lang.String range_1_auth_asym_id,
		java.lang.String range_1_auth_atom_id,
		java.lang.String range_1_auth_comp_id,
		java.lang.String range_1_auth_seq_id,
		java.lang.String range_1_label_asym_id,
		java.lang.String range_1_label_atom_id,
		java.lang.String range_1_label_comp_id,
		java.lang.Integer range_1_label_seq_id,
		java.lang.String range_2_PDB_ins_code,
		java.lang.String range_2_auth_asym_id,
		java.lang.String range_2_auth_atom_id,
		java.lang.String range_2_auth_comp_id,
		java.lang.String range_2_auth_seq_id,
		java.lang.String range_2_label_asym_id,
		java.lang.String range_2_label_atom_id,
		java.lang.String range_2_label_comp_id,
		java.lang.Integer range_2_label_seq_id,
		java.lang.String range_id_1,
		java.lang.String range_id_2,
		java.lang.String sheet_id)
	{
		this.datablock = datablock;
		this.range_1_PDB_ins_code = range_1_PDB_ins_code;
		this.range_1_auth_asym_id = range_1_auth_asym_id;
		this.range_1_auth_atom_id = range_1_auth_atom_id;
		this.range_1_auth_comp_id = range_1_auth_comp_id;
		this.range_1_auth_seq_id = range_1_auth_seq_id;
		this.range_1_label_asym_id = range_1_label_asym_id;
		this.range_1_label_atom_id = range_1_label_atom_id;
		this.range_1_label_comp_id = range_1_label_comp_id;
		this.range_1_label_seq_id = range_1_label_seq_id;
		this.range_2_PDB_ins_code = range_2_PDB_ins_code;
		this.range_2_auth_asym_id = range_2_auth_asym_id;
		this.range_2_auth_atom_id = range_2_auth_atom_id;
		this.range_2_auth_comp_id = range_2_auth_comp_id;
		this.range_2_auth_seq_id = range_2_auth_seq_id;
		this.range_2_label_asym_id = range_2_label_asym_id;
		this.range_2_label_atom_id = range_2_label_atom_id;
		this.range_2_label_comp_id = range_2_label_comp_id;
		this.range_2_label_seq_id = range_2_label_seq_id;
		this.range_id_1 = range_id_1;
		this.range_id_2 = range_id_2;
		this.sheet_id = sheet_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_struct_sheet_hbond");
		sb.append("\n");
		if (range_1_PDB_ins_code != null)
		{
			sb.append("range_1_PDB_ins_code = ");
			sb.append(range_1_PDB_ins_code);
			sb.append('\n');
		}
		if (range_1_auth_asym_id != null)
		{
			sb.append("range_1_auth_asym_id = ");
			sb.append(range_1_auth_asym_id);
			sb.append('\n');
		}
		if (range_1_auth_atom_id != null)
		{
			sb.append("range_1_auth_atom_id = ");
			sb.append(range_1_auth_atom_id);
			sb.append('\n');
		}
		if (range_1_auth_comp_id != null)
		{
			sb.append("range_1_auth_comp_id = ");
			sb.append(range_1_auth_comp_id);
			sb.append('\n');
		}
		if (range_1_auth_seq_id != null)
		{
			sb.append("range_1_auth_seq_id = ");
			sb.append(range_1_auth_seq_id);
			sb.append('\n');
		}
		if (range_1_label_asym_id != null)
		{
			sb.append("range_1_label_asym_id = ");
			sb.append(range_1_label_asym_id);
			sb.append('\n');
		}
		if (range_1_label_atom_id != null)
		{
			sb.append("range_1_label_atom_id = ");
			sb.append(range_1_label_atom_id);
			sb.append('\n');
		}
		if (range_1_label_comp_id != null)
		{
			sb.append("range_1_label_comp_id = ");
			sb.append(range_1_label_comp_id);
			sb.append('\n');
		}
		if (range_1_label_seq_id != null)
		{
			sb.append("range_1_label_seq_id = ");
			sb.append(range_1_label_seq_id);
			sb.append('\n');
		}
		if (range_2_PDB_ins_code != null)
		{
			sb.append("range_2_PDB_ins_code = ");
			sb.append(range_2_PDB_ins_code);
			sb.append('\n');
		}
		if (range_2_auth_asym_id != null)
		{
			sb.append("range_2_auth_asym_id = ");
			sb.append(range_2_auth_asym_id);
			sb.append('\n');
		}
		if (range_2_auth_atom_id != null)
		{
			sb.append("range_2_auth_atom_id = ");
			sb.append(range_2_auth_atom_id);
			sb.append('\n');
		}
		if (range_2_auth_comp_id != null)
		{
			sb.append("range_2_auth_comp_id = ");
			sb.append(range_2_auth_comp_id);
			sb.append('\n');
		}
		if (range_2_auth_seq_id != null)
		{
			sb.append("range_2_auth_seq_id = ");
			sb.append(range_2_auth_seq_id);
			sb.append('\n');
		}
		if (range_2_label_asym_id != null)
		{
			sb.append("range_2_label_asym_id = ");
			sb.append(range_2_label_asym_id);
			sb.append('\n');
		}
		if (range_2_label_atom_id != null)
		{
			sb.append("range_2_label_atom_id = ");
			sb.append(range_2_label_atom_id);
			sb.append('\n');
		}
		if (range_2_label_comp_id != null)
		{
			sb.append("range_2_label_comp_id = ");
			sb.append(range_2_label_comp_id);
			sb.append('\n');
		}
		if (range_2_label_seq_id != null)
		{
			sb.append("range_2_label_seq_id = ");
			sb.append(range_2_label_seq_id);
			sb.append('\n');
		}
		if (range_id_1 != null)
		{
			sb.append("range_id_1 = ");
			sb.append(range_id_1);
			sb.append('\n');
		}
		if (range_id_2 != null)
		{
			sb.append("range_id_2 = ");
			sb.append(range_id_2);
			sb.append('\n');
		}
		if (sheet_id != null)
		{
			sb.append("sheet_id = ");
			sb.append(sheet_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		range_1_PDB_ins_code = null;
		range_1_auth_asym_id = null;
		range_1_auth_atom_id = null;
		range_1_auth_comp_id = null;
		range_1_auth_seq_id = null;
		range_1_label_asym_id = null;
		range_1_label_atom_id = null;
		range_1_label_comp_id = null;
		range_1_label_seq_id = null;
		range_2_PDB_ins_code = null;
		range_2_auth_asym_id = null;
		range_2_auth_atom_id = null;
		range_2_auth_comp_id = null;
		range_2_auth_seq_id = null;
		range_2_label_asym_id = null;
		range_2_label_atom_id = null;
		range_2_label_comp_id = null;
		range_2_label_seq_id = null;
		range_id_1 = null;
		range_id_2 = null;
		sheet_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_struct_sheet_hbond)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_struct_sheet_hbond>\n");
			if (range_1_PDB_ins_code != null) ow.write(indent + " <PDBx:range_1_PDB_ins_code>" + range_1_PDB_ins_code + "</PDBx:range_1_PDB_ins_code>\n");
			if (range_1_auth_asym_id != null) ow.write(indent + " <PDBx:range_1_auth_asym_id>" + range_1_auth_asym_id + "</PDBx:range_1_auth_asym_id>\n");
			if (range_1_auth_atom_id != null) ow.write(indent + " <PDBx:range_1_auth_atom_id>" + range_1_auth_atom_id + "</PDBx:range_1_auth_atom_id>\n");
			if (range_1_auth_comp_id != null) ow.write(indent + " <PDBx:range_1_auth_comp_id>" + range_1_auth_comp_id + "</PDBx:range_1_auth_comp_id>\n");
			if (range_1_auth_seq_id != null) ow.write(indent + " <PDBx:range_1_auth_seq_id>" + range_1_auth_seq_id + "</PDBx:range_1_auth_seq_id>\n");
			if (range_1_label_asym_id != null) ow.write(indent + " <PDBx:range_1_label_asym_id>" + range_1_label_asym_id + "</PDBx:range_1_label_asym_id>\n");
			if (range_1_label_atom_id != null) ow.write(indent + " <PDBx:range_1_label_atom_id>" + range_1_label_atom_id + "</PDBx:range_1_label_atom_id>\n");
			if (range_1_label_comp_id != null) ow.write(indent + " <PDBx:range_1_label_comp_id>" + range_1_label_comp_id + "</PDBx:range_1_label_comp_id>\n");
			if (range_1_label_seq_id != null) ow.write(indent + " <PDBx:range_1_label_seq_id>" + range_1_label_seq_id + "</PDBx:range_1_label_seq_id>\n");
			if (range_2_PDB_ins_code != null) ow.write(indent + " <PDBx:range_2_PDB_ins_code>" + range_2_PDB_ins_code + "</PDBx:range_2_PDB_ins_code>\n");
			if (range_2_auth_asym_id != null) ow.write(indent + " <PDBx:range_2_auth_asym_id>" + range_2_auth_asym_id + "</PDBx:range_2_auth_asym_id>\n");
			if (range_2_auth_atom_id != null) ow.write(indent + " <PDBx:range_2_auth_atom_id>" + range_2_auth_atom_id + "</PDBx:range_2_auth_atom_id>\n");
			if (range_2_auth_comp_id != null) ow.write(indent + " <PDBx:range_2_auth_comp_id>" + range_2_auth_comp_id + "</PDBx:range_2_auth_comp_id>\n");
			if (range_2_auth_seq_id != null) ow.write(indent + " <PDBx:range_2_auth_seq_id>" + range_2_auth_seq_id + "</PDBx:range_2_auth_seq_id>\n");
			if (range_2_label_asym_id != null) ow.write(indent + " <PDBx:range_2_label_asym_id>" + range_2_label_asym_id + "</PDBx:range_2_label_asym_id>\n");
			if (range_2_label_atom_id != null) ow.write(indent + " <PDBx:range_2_label_atom_id>" + range_2_label_atom_id + "</PDBx:range_2_label_atom_id>\n");
			if (range_2_label_comp_id != null) ow.write(indent + " <PDBx:range_2_label_comp_id>" + range_2_label_comp_id + "</PDBx:range_2_label_comp_id>\n");
			if (range_2_label_seq_id != null) ow.write(indent + " <PDBx:range_2_label_seq_id>" + range_2_label_seq_id + "</PDBx:range_2_label_seq_id>\n");
			if (range_id_1 != null) ow.write(indent + " <PDBx:range_id_1>" + range_id_1 + "</PDBx:range_id_1>\n");
			if (range_id_2 != null) ow.write(indent + " <PDBx:range_id_2>" + range_id_2 + "</PDBx:range_id_2>\n");
			if (sheet_id != null) ow.write(indent + " <PDBx:sheet_id>" + sheet_id + "</PDBx:sheet_id>\n");
			ow.write(indent + "</PDBx:pdbx_struct_sheet_hbond>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
