package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PDBX_VERSION category record details about the
 *  current internal version of this entry.
 *  
 *  
 * <pre>
 *  Example 1 -
 *  <PDBx:pdbx_versionCategory>
 *  <PDBx:pdbx_version entry_id="1ABC" major_version="3" minor_version="12">
 *  <PDBx:revision_date>2006-12-08</PDBx:revision_date>
 *  <PDBx:details>  Update version information. </PDBx:details>
 *  </PDBx:pdbx_version>
 *  </PDBx:pdbx_versionCategory>
 * </pre>
 */
public class Pdbx_version extends org.pdb.beans.Pdbx_version implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "pdbx_version";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Pdbx_version()
	{
	}

	/** Full constructor */
	public Pdbx_version(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.Integer major_version,
		java.lang.Integer minor_version,
		java.util.Date revision_date)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.major_version = major_version;
		this.minor_version = minor_version;
		this.revision_date = revision_date;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Pdbx_version");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (major_version != null)
		{
			sb.append("major_version = ");
			sb.append(major_version);
			sb.append('\n');
		}
		if (minor_version != null)
		{
			sb.append("minor_version = ");
			sb.append(minor_version);
			sb.append('\n');
		}
		if (revision_date != null)
		{
			sb.append("revision_date = ");
			sb.append(revision_date);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		major_version = null;
		minor_version = null;
		revision_date = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Pdbx_version)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:pdbx_version>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (major_version != null) ow.write(indent + " <PDBx:major_version>" + major_version + "</PDBx:major_version>\n");
			if (minor_version != null) ow.write(indent + " <PDBx:minor_version>" + minor_version + "</PDBx:minor_version>\n");
			if (revision_date != null) ow.write(indent + " <PDBx:revision_date>" + revision_date + "</PDBx:revision_date>\n");
			ow.write(indent + "</PDBx:pdbx_version>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
