package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING category record details about the
 *  phasing of the structure, listing the various methods used in
 *  the phasing process. Details about the application of each
 *  method are listed in the appropriate subcategories.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:phasingCategory>
 *  <PDBx:phasing method="mir"></PDBx:phasing>
 *  <PDBx:phasing method="averaging"></PDBx:phasing>
 *  </PDBx:phasingCategory>
 * </pre>
 */
public class Phasing extends org.pdb.beans.Phasing implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing()
	{
	}

	/** Full constructor */
	public Phasing(
		Datablock datablock,
		java.lang.String method)
	{
		this.datablock = datablock;
		this.method = method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing");
		sb.append("\n");
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			ow.write(indent + "</PDBx:phasing>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
