package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MAD_CLUST category record details
 *  about a cluster of experiments that contributed to the
 *  generation of a set of phases.
 *  
 * <pre>
 *  Example 1 - based on a paper by Shapiro et al. [Nature (London)
 *  (1995), 374, 327-337].
 *  <PDBx:phasing_MAD_clustCategory>
 *  <PDBx:phasing_MAD_clust id="4 wavelength" expt_id="1">
 *  <PDBx:number_set>4</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  <PDBx:phasing_MAD_clust id="5 wavelength" expt_id="1">
 *  <PDBx:number_set>5</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  <PDBx:phasing_MAD_clust id="5 wavelength" expt_id="2">
 *  <PDBx:number_set>5</PDBx:number_set>
 *  </PDBx:phasing_MAD_clust>
 *  </PDBx:phasing_MAD_clustCategory>
 * </pre>
 */
public class Phasing_MAD_clust extends org.pdb.beans.Phasing_MAD_clust implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MAD_clust";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MAD_clust()
	{
	}

	/** Full constructor */
	public Phasing_MAD_clust(
		Datablock datablock,
		java.lang.String expt_id,
		java.lang.String id_,
		java.lang.Integer number_set)
	{
		this.datablock = datablock;
		this.expt_id = expt_id;
		this.id_ = id_;
		this.number_set = number_set;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MAD_clust");
		sb.append("\n");
		if (expt_id != null)
		{
			sb.append("expt_id = ");
			sb.append(expt_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (number_set != null)
		{
			sb.append("number_set = ");
			sb.append(number_set);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		expt_id = null;
		id_ = null;
		number_set = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MAD_clust)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MAD_clust>\n");
			if (expt_id != null) ow.write(indent + " <PDBx:expt_id>" + expt_id + "</PDBx:expt_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (number_set != null) ow.write(indent + " <PDBx:number_set>" + number_set + "</PDBx:number_set>\n");
			ow.write(indent + "</PDBx:phasing_MAD_clust>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
