package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR_DER category record details
 *  about individual derivatives used in the phasing of the
 *  structure when methods involving isomorphous replacement are
 *  involved.
 *  
 *  A derivative in this context does not necessarily equate with
 *  a data set; for instance, the same data set could be used to
 *  one resolution limit as an isomorphous scatterer and to a
 *  different resolution (and with a different sigma cutoff) as an
 *  anomalous scatterer. These would be treated as two distinct
 *  derivatives, although both derivatives would point to the same
 *  data sets via  attribute der_set_id in category phasing_MIR_der and
 *  attribute native_set_id in category phasing_MIR_der.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738].
 *  <PDBx:phasing_MIR_derCategory>
 *  <PDBx:phasing_MIR_der id="KAu(CN)2">
 *  <PDBx:number_of_sites>3</PDBx:number_of_sites>
 *  <PDBx:details>major site interpreted in difference Patterson</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="K2HgI4">
 *  <PDBx:number_of_sites>6</PDBx:number_of_sites>
 *  <PDBx:details>sites found in cross-difference Fourier</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="K3IrCl6">
 *  <PDBx:number_of_sites>2</PDBx:number_of_sites>
 *  <PDBx:details>sites found in cross-difference Fourier</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  <PDBx:phasing_MIR_der id="All">
 *  <PDBx:number_of_sites>11</PDBx:number_of_sites>
 *  <PDBx:details>data for all three derivatives combined</PDBx:details>
 *  </PDBx:phasing_MIR_der>
 *  </PDBx:phasing_MIR_derCategory>
 * </pre>
 */
public class Phasing_MIR_der extends org.pdb.beans.Phasing_MIR_der implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR_der";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR_der()
	{
	}

	/** Full constructor */
	public Phasing_MIR_der(
		Datablock datablock,
		java.lang.Float R_cullis_acentric,
		java.lang.Float R_cullis_anomalous,
		java.lang.Float R_cullis_centric,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String der_set_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String native_set_id,
		java.lang.Integer number_of_sites,
		java.lang.Float pdbx_R_cullis,
		java.lang.Float pdbx_R_kraut,
		java.lang.Float pdbx_R_kraut_acentric,
		java.lang.Float pdbx_R_kraut_centric,
		java.lang.Float pdbx_fom,
		java.lang.Float pdbx_fom_acentric,
		java.lang.Float pdbx_fom_centric,
		java.lang.Float pdbx_loc,
		java.lang.Float pdbx_loc_acentric,
		java.lang.Float pdbx_loc_centric,
		java.lang.Float pdbx_power,
		java.lang.Integer pdbx_reflns,
		java.lang.Float power_acentric,
		java.lang.Float power_centric,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_anomalous,
		java.lang.Integer reflns_centric,
		java.lang.String reflns_criteria)
	{
		this.datablock = datablock;
		this.R_cullis_acentric = R_cullis_acentric;
		this.R_cullis_anomalous = R_cullis_anomalous;
		this.R_cullis_centric = R_cullis_centric;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.der_set_id = der_set_id;
		this.details = details;
		this.id_ = id_;
		this.native_set_id = native_set_id;
		this.number_of_sites = number_of_sites;
		this.pdbx_R_cullis = pdbx_R_cullis;
		this.pdbx_R_kraut = pdbx_R_kraut;
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
		this.pdbx_fom = pdbx_fom;
		this.pdbx_fom_acentric = pdbx_fom_acentric;
		this.pdbx_fom_centric = pdbx_fom_centric;
		this.pdbx_loc = pdbx_loc;
		this.pdbx_loc_acentric = pdbx_loc_acentric;
		this.pdbx_loc_centric = pdbx_loc_centric;
		this.pdbx_power = pdbx_power;
		this.pdbx_reflns = pdbx_reflns;
		this.power_acentric = power_acentric;
		this.power_centric = power_centric;
		this.reflns_acentric = reflns_acentric;
		this.reflns_anomalous = reflns_anomalous;
		this.reflns_centric = reflns_centric;
		this.reflns_criteria = reflns_criteria;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR_der");
		sb.append("\n");
		if (R_cullis_acentric != null)
		{
			sb.append("R_cullis_acentric = ");
			sb.append(R_cullis_acentric);
			sb.append('\n');
		}
		if (R_cullis_anomalous != null)
		{
			sb.append("R_cullis_anomalous = ");
			sb.append(R_cullis_anomalous);
			sb.append('\n');
		}
		if (R_cullis_centric != null)
		{
			sb.append("R_cullis_centric = ");
			sb.append(R_cullis_centric);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (der_set_id != null)
		{
			sb.append("der_set_id = ");
			sb.append(der_set_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (native_set_id != null)
		{
			sb.append("native_set_id = ");
			sb.append(native_set_id);
			sb.append('\n');
		}
		if (number_of_sites != null)
		{
			sb.append("number_of_sites = ");
			sb.append(number_of_sites);
			sb.append('\n');
		}
		if (pdbx_R_cullis != null)
		{
			sb.append("pdbx_R_cullis = ");
			sb.append(pdbx_R_cullis);
			sb.append('\n');
		}
		if (pdbx_R_kraut != null)
		{
			sb.append("pdbx_R_kraut = ");
			sb.append(pdbx_R_kraut);
			sb.append('\n');
		}
		if (pdbx_R_kraut_acentric != null)
		{
			sb.append("pdbx_R_kraut_acentric = ");
			sb.append(pdbx_R_kraut_acentric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_centric != null)
		{
			sb.append("pdbx_R_kraut_centric = ");
			sb.append(pdbx_R_kraut_centric);
			sb.append('\n');
		}
		if (pdbx_fom != null)
		{
			sb.append("pdbx_fom = ");
			sb.append(pdbx_fom);
			sb.append('\n');
		}
		if (pdbx_fom_acentric != null)
		{
			sb.append("pdbx_fom_acentric = ");
			sb.append(pdbx_fom_acentric);
			sb.append('\n');
		}
		if (pdbx_fom_centric != null)
		{
			sb.append("pdbx_fom_centric = ");
			sb.append(pdbx_fom_centric);
			sb.append('\n');
		}
		if (pdbx_loc != null)
		{
			sb.append("pdbx_loc = ");
			sb.append(pdbx_loc);
			sb.append('\n');
		}
		if (pdbx_loc_acentric != null)
		{
			sb.append("pdbx_loc_acentric = ");
			sb.append(pdbx_loc_acentric);
			sb.append('\n');
		}
		if (pdbx_loc_centric != null)
		{
			sb.append("pdbx_loc_centric = ");
			sb.append(pdbx_loc_centric);
			sb.append('\n');
		}
		if (pdbx_power != null)
		{
			sb.append("pdbx_power = ");
			sb.append(pdbx_power);
			sb.append('\n');
		}
		if (pdbx_reflns != null)
		{
			sb.append("pdbx_reflns = ");
			sb.append(pdbx_reflns);
			sb.append('\n');
		}
		if (power_acentric != null)
		{
			sb.append("power_acentric = ");
			sb.append(power_acentric);
			sb.append('\n');
		}
		if (power_centric != null)
		{
			sb.append("power_centric = ");
			sb.append(power_centric);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_anomalous != null)
		{
			sb.append("reflns_anomalous = ");
			sb.append(reflns_anomalous);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		if (reflns_criteria != null)
		{
			sb.append("reflns_criteria = ");
			sb.append(reflns_criteria);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_cullis_acentric = null;
		R_cullis_anomalous = null;
		R_cullis_centric = null;
		d_res_high = null;
		d_res_low = null;
		der_set_id = null;
		details = null;
		id_ = null;
		native_set_id = null;
		number_of_sites = null;
		pdbx_R_cullis = null;
		pdbx_R_kraut = null;
		pdbx_R_kraut_acentric = null;
		pdbx_R_kraut_centric = null;
		pdbx_fom = null;
		pdbx_fom_acentric = null;
		pdbx_fom_centric = null;
		pdbx_loc = null;
		pdbx_loc_acentric = null;
		pdbx_loc_centric = null;
		pdbx_power = null;
		pdbx_reflns = null;
		power_acentric = null;
		power_centric = null;
		reflns_acentric = null;
		reflns_anomalous = null;
		reflns_centric = null;
		reflns_criteria = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR_der)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR_der>\n");
			if (R_cullis_acentric != null) ow.write(indent + " <PDBx:R_cullis_acentric>" + R_cullis_acentric + "</PDBx:R_cullis_acentric>\n");
			if (R_cullis_anomalous != null) ow.write(indent + " <PDBx:R_cullis_anomalous>" + R_cullis_anomalous + "</PDBx:R_cullis_anomalous>\n");
			if (R_cullis_centric != null) ow.write(indent + " <PDBx:R_cullis_centric>" + R_cullis_centric + "</PDBx:R_cullis_centric>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (der_set_id != null) ow.write(indent + " <PDBx:der_set_id>" + der_set_id + "</PDBx:der_set_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (native_set_id != null) ow.write(indent + " <PDBx:native_set_id>" + native_set_id + "</PDBx:native_set_id>\n");
			if (number_of_sites != null) ow.write(indent + " <PDBx:number_of_sites>" + number_of_sites + "</PDBx:number_of_sites>\n");
			if (pdbx_R_cullis != null) ow.write(indent + " <PDBx:pdbx_R_cullis>" + pdbx_R_cullis + "</PDBx:pdbx_R_cullis>\n");
			if (pdbx_R_kraut != null) ow.write(indent + " <PDBx:pdbx_R_kraut>" + pdbx_R_kraut + "</PDBx:pdbx_R_kraut>\n");
			if (pdbx_R_kraut_acentric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_acentric>" + pdbx_R_kraut_acentric + "</PDBx:pdbx_R_kraut_acentric>\n");
			if (pdbx_R_kraut_centric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_centric>" + pdbx_R_kraut_centric + "</PDBx:pdbx_R_kraut_centric>\n");
			if (pdbx_fom != null) ow.write(indent + " <PDBx:pdbx_fom>" + pdbx_fom + "</PDBx:pdbx_fom>\n");
			if (pdbx_fom_acentric != null) ow.write(indent + " <PDBx:pdbx_fom_acentric>" + pdbx_fom_acentric + "</PDBx:pdbx_fom_acentric>\n");
			if (pdbx_fom_centric != null) ow.write(indent + " <PDBx:pdbx_fom_centric>" + pdbx_fom_centric + "</PDBx:pdbx_fom_centric>\n");
			if (pdbx_loc != null) ow.write(indent + " <PDBx:pdbx_loc>" + pdbx_loc + "</PDBx:pdbx_loc>\n");
			if (pdbx_loc_acentric != null) ow.write(indent + " <PDBx:pdbx_loc_acentric>" + pdbx_loc_acentric + "</PDBx:pdbx_loc_acentric>\n");
			if (pdbx_loc_centric != null) ow.write(indent + " <PDBx:pdbx_loc_centric>" + pdbx_loc_centric + "</PDBx:pdbx_loc_centric>\n");
			if (pdbx_power != null) ow.write(indent + " <PDBx:pdbx_power>" + pdbx_power + "</PDBx:pdbx_power>\n");
			if (pdbx_reflns != null) ow.write(indent + " <PDBx:pdbx_reflns>" + pdbx_reflns + "</PDBx:pdbx_reflns>\n");
			if (power_acentric != null) ow.write(indent + " <PDBx:power_acentric>" + power_acentric + "</PDBx:power_acentric>\n");
			if (power_centric != null) ow.write(indent + " <PDBx:power_centric>" + power_centric + "</PDBx:power_centric>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_anomalous != null) ow.write(indent + " <PDBx:reflns_anomalous>" + reflns_anomalous + "</PDBx:reflns_anomalous>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			if (reflns_criteria != null) ow.write(indent + " <PDBx:reflns_criteria>" + reflns_criteria + "</PDBx:reflns_criteria>\n");
			ow.write(indent + "</PDBx:phasing_MIR_der>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
