package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR_DER_REFLN category record details
 *  about the calculated structure factors obtained in an MIR
 *  phasing experiment.
 *  
 *  This list may contain information from a number of different
 *  derivatives;  attribute der_id in category phasing_MIR_der_refln indicates to which
 *  derivative a given record corresponds. (A derivative in this
 *  context does not necessarily equate with a data set; see the
 *  definition of the PHASING_MIR_DER category for a
 *  discussion of the meaning of derivative.)
 *  
 *  It is not necessary for the data items describing the measured
 *  value of F to appear in this list, as they will be
 *  given in the PHASING_SET_REFLN category. However, these
 *  items can also be listed here for completeness.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the 6,1,25 reflection
 *  of an Hg/Pt derivative of protein NS1.
 *  <PDBx:phasing_MIR_der_reflnCategory>
 *  <PDBx:phasing_MIR_der_refln index_h="6" index_k="1" index_l="25" der_id="HGPT1" set_id="NS1-96">
 *  <PDBx:F_calc_au>106.66</PDBx:F_calc_au>
 *  <PDBx:F_meas_au>204.67</PDBx:F_meas_au>
 *  <PDBx:F_meas_sigma>6.21</PDBx:F_meas_sigma>
 *  <PDBx:HL_A_iso>-3.15</PDBx:HL_A_iso>
 *  <PDBx:HL_B_iso>-0.76</PDBx:HL_B_iso>
 *  <PDBx:HL_C_iso>0.65</PDBx:HL_C_iso>
 *  <PDBx:HL_D_iso>0.23</PDBx:HL_D_iso>
 *  <PDBx:phase_calc>194.48</PDBx:phase_calc>
 *  </PDBx:phasing_MIR_der_refln>
 *  </PDBx:phasing_MIR_der_reflnCategory>
 * </pre>
 */
public class Phasing_MIR_der_refln extends org.pdb.beans.Phasing_MIR_der_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR_der_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR_der_refln()
	{
	}

	/** Full constructor */
	public Phasing_MIR_der_refln(
		Datablock datablock,
		java.lang.Float F_calc,
		java.lang.Float F_calc_au,
		java.lang.Float F_meas,
		java.lang.Float F_meas_au,
		java.lang.Float F_meas_sigma,
		java.lang.Float F_meas_sigma_au,
		java.lang.Float HL_A_iso,
		java.lang.Float HL_B_iso,
		java.lang.Float HL_C_iso,
		java.lang.Float HL_D_iso,
		java.lang.String der_id,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float phase_calc,
		java.lang.String set_id)
	{
		this.datablock = datablock;
		this.F_calc = F_calc;
		this.F_calc_au = F_calc_au;
		this.F_meas = F_meas;
		this.F_meas_au = F_meas_au;
		this.F_meas_sigma = F_meas_sigma;
		this.F_meas_sigma_au = F_meas_sigma_au;
		this.HL_A_iso = HL_A_iso;
		this.HL_B_iso = HL_B_iso;
		this.HL_C_iso = HL_C_iso;
		this.HL_D_iso = HL_D_iso;
		this.der_id = der_id;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.phase_calc = phase_calc;
		this.set_id = set_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR_der_refln");
		sb.append("\n");
		if (F_calc != null)
		{
			sb.append("F_calc = ");
			sb.append(F_calc);
			sb.append('\n');
		}
		if (F_calc_au != null)
		{
			sb.append("F_calc_au = ");
			sb.append(F_calc_au);
			sb.append('\n');
		}
		if (F_meas != null)
		{
			sb.append("F_meas = ");
			sb.append(F_meas);
			sb.append('\n');
		}
		if (F_meas_au != null)
		{
			sb.append("F_meas_au = ");
			sb.append(F_meas_au);
			sb.append('\n');
		}
		if (F_meas_sigma != null)
		{
			sb.append("F_meas_sigma = ");
			sb.append(F_meas_sigma);
			sb.append('\n');
		}
		if (F_meas_sigma_au != null)
		{
			sb.append("F_meas_sigma_au = ");
			sb.append(F_meas_sigma_au);
			sb.append('\n');
		}
		if (HL_A_iso != null)
		{
			sb.append("HL_A_iso = ");
			sb.append(HL_A_iso);
			sb.append('\n');
		}
		if (HL_B_iso != null)
		{
			sb.append("HL_B_iso = ");
			sb.append(HL_B_iso);
			sb.append('\n');
		}
		if (HL_C_iso != null)
		{
			sb.append("HL_C_iso = ");
			sb.append(HL_C_iso);
			sb.append('\n');
		}
		if (HL_D_iso != null)
		{
			sb.append("HL_D_iso = ");
			sb.append(HL_D_iso);
			sb.append('\n');
		}
		if (der_id != null)
		{
			sb.append("der_id = ");
			sb.append(der_id);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (phase_calc != null)
		{
			sb.append("phase_calc = ");
			sb.append(phase_calc);
			sb.append('\n');
		}
		if (set_id != null)
		{
			sb.append("set_id = ");
			sb.append(set_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		F_calc = null;
		F_calc_au = null;
		F_meas = null;
		F_meas_au = null;
		F_meas_sigma = null;
		F_meas_sigma_au = null;
		HL_A_iso = null;
		HL_B_iso = null;
		HL_C_iso = null;
		HL_D_iso = null;
		der_id = null;
		index_h = null;
		index_k = null;
		index_l = null;
		phase_calc = null;
		set_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR_der_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR_der_refln>\n");
			if (F_calc != null) ow.write(indent + " <PDBx:F_calc>" + F_calc + "</PDBx:F_calc>\n");
			if (F_calc_au != null) ow.write(indent + " <PDBx:F_calc_au>" + F_calc_au + "</PDBx:F_calc_au>\n");
			if (F_meas != null) ow.write(indent + " <PDBx:F_meas>" + F_meas + "</PDBx:F_meas>\n");
			if (F_meas_au != null) ow.write(indent + " <PDBx:F_meas_au>" + F_meas_au + "</PDBx:F_meas_au>\n");
			if (F_meas_sigma != null) ow.write(indent + " <PDBx:F_meas_sigma>" + F_meas_sigma + "</PDBx:F_meas_sigma>\n");
			if (F_meas_sigma_au != null) ow.write(indent + " <PDBx:F_meas_sigma_au>" + F_meas_sigma_au + "</PDBx:F_meas_sigma_au>\n");
			if (HL_A_iso != null) ow.write(indent + " <PDBx:HL_A_iso>" + HL_A_iso + "</PDBx:HL_A_iso>\n");
			if (HL_B_iso != null) ow.write(indent + " <PDBx:HL_B_iso>" + HL_B_iso + "</PDBx:HL_B_iso>\n");
			if (HL_C_iso != null) ow.write(indent + " <PDBx:HL_C_iso>" + HL_C_iso + "</PDBx:HL_C_iso>\n");
			if (HL_D_iso != null) ow.write(indent + " <PDBx:HL_D_iso>" + HL_D_iso + "</PDBx:HL_D_iso>\n");
			if (der_id != null) ow.write(indent + " <PDBx:der_id>" + der_id + "</PDBx:der_id>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (phase_calc != null) ow.write(indent + " <PDBx:phase_calc>" + phase_calc + "</PDBx:phase_calc>\n");
			if (set_id != null) ow.write(indent + " <PDBx:set_id>" + set_id + "</PDBx:set_id>\n");
			ow.write(indent + "</PDBx:phasing_MIR_der_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
