package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_MIR_SHELL category record statistics
 *  for an isomorphous replacement phasing experiment.broken
 *  down into shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on a paper by Zanotti et al. [J. Biol. Chem.
 *  (1993), 268, 10728-10738]
 *  with addition of an arbitrary low-resolution limit.
 *  <PDBx:phasing_MIR_shellCategory>
 *  <PDBx:phasing_MIR_shell d_res_low="15.0" d_res_high="8.3">
 *  <PDBx:reflns>80</PDBx:reflns>
 *  <PDBx:FOM>0.69</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="8.3" d_res_high="6.4">
 *  <PDBx:reflns>184</PDBx:reflns>
 *  <PDBx:FOM>0.73</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="6.4" d_res_high="5.2">
 *  <PDBx:reflns>288</PDBx:reflns>
 *  <PDBx:FOM>0.72</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="5.2" d_res_high="4.4">
 *  <PDBx:reflns>406</PDBx:reflns>
 *  <PDBx:FOM>0.65</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="4.4" d_res_high="3.8">
 *  <PDBx:reflns>554</PDBx:reflns>
 *  <PDBx:FOM>0.54</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="3.8" d_res_high="3.4">
 *  <PDBx:reflns>730</PDBx:reflns>
 *  <PDBx:FOM>0.53</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  <PDBx:phasing_MIR_shell d_res_low="3.4" d_res_high="3.0">
 *  <PDBx:reflns>939</PDBx:reflns>
 *  <PDBx:FOM>0.50</PDBx:FOM>
 *  </PDBx:phasing_MIR_shell>
 *  </PDBx:phasing_MIR_shellCategory>
 * </pre>
 */
public class Phasing_MIR_shell extends org.pdb.beans.Phasing_MIR_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_MIR_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_MIR_shell()
	{
	}

	/** Full constructor */
	public Phasing_MIR_shell(
		Datablock datablock,
		java.lang.Float FOM,
		java.lang.Float FOM_acentric,
		java.lang.Float FOM_centric,
		java.lang.Float R_cullis,
		java.lang.Float R_kraut,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Float loc,
		java.lang.Float mean_phase,
		java.lang.Float pdbx_R_cullis_acentric,
		java.lang.Float pdbx_R_cullis_centric,
		java.lang.Float pdbx_R_kraut_acentric,
		java.lang.Float pdbx_R_kraut_centric,
		java.lang.Float pdbx_loc_acentric,
		java.lang.Float pdbx_loc_centric,
		java.lang.Float pdbx_power_acentric,
		java.lang.Float pdbx_power_centric,
		java.lang.Float power,
		java.lang.Integer reflns,
		java.lang.Integer reflns_acentric,
		java.lang.Integer reflns_anomalous,
		java.lang.Integer reflns_centric)
	{
		this.datablock = datablock;
		this.FOM = FOM;
		this.FOM_acentric = FOM_acentric;
		this.FOM_centric = FOM_centric;
		this.R_cullis = R_cullis;
		this.R_kraut = R_kraut;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.loc = loc;
		this.mean_phase = mean_phase;
		this.pdbx_R_cullis_acentric = pdbx_R_cullis_acentric;
		this.pdbx_R_cullis_centric = pdbx_R_cullis_centric;
		this.pdbx_R_kraut_acentric = pdbx_R_kraut_acentric;
		this.pdbx_R_kraut_centric = pdbx_R_kraut_centric;
		this.pdbx_loc_acentric = pdbx_loc_acentric;
		this.pdbx_loc_centric = pdbx_loc_centric;
		this.pdbx_power_acentric = pdbx_power_acentric;
		this.pdbx_power_centric = pdbx_power_centric;
		this.power = power;
		this.reflns = reflns;
		this.reflns_acentric = reflns_acentric;
		this.reflns_anomalous = reflns_anomalous;
		this.reflns_centric = reflns_centric;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_MIR_shell");
		sb.append("\n");
		if (FOM != null)
		{
			sb.append("FOM = ");
			sb.append(FOM);
			sb.append('\n');
		}
		if (FOM_acentric != null)
		{
			sb.append("FOM_acentric = ");
			sb.append(FOM_acentric);
			sb.append('\n');
		}
		if (FOM_centric != null)
		{
			sb.append("FOM_centric = ");
			sb.append(FOM_centric);
			sb.append('\n');
		}
		if (R_cullis != null)
		{
			sb.append("R_cullis = ");
			sb.append(R_cullis);
			sb.append('\n');
		}
		if (R_kraut != null)
		{
			sb.append("R_kraut = ");
			sb.append(R_kraut);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (loc != null)
		{
			sb.append("loc = ");
			sb.append(loc);
			sb.append('\n');
		}
		if (mean_phase != null)
		{
			sb.append("mean_phase = ");
			sb.append(mean_phase);
			sb.append('\n');
		}
		if (pdbx_R_cullis_acentric != null)
		{
			sb.append("pdbx_R_cullis_acentric = ");
			sb.append(pdbx_R_cullis_acentric);
			sb.append('\n');
		}
		if (pdbx_R_cullis_centric != null)
		{
			sb.append("pdbx_R_cullis_centric = ");
			sb.append(pdbx_R_cullis_centric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_acentric != null)
		{
			sb.append("pdbx_R_kraut_acentric = ");
			sb.append(pdbx_R_kraut_acentric);
			sb.append('\n');
		}
		if (pdbx_R_kraut_centric != null)
		{
			sb.append("pdbx_R_kraut_centric = ");
			sb.append(pdbx_R_kraut_centric);
			sb.append('\n');
		}
		if (pdbx_loc_acentric != null)
		{
			sb.append("pdbx_loc_acentric = ");
			sb.append(pdbx_loc_acentric);
			sb.append('\n');
		}
		if (pdbx_loc_centric != null)
		{
			sb.append("pdbx_loc_centric = ");
			sb.append(pdbx_loc_centric);
			sb.append('\n');
		}
		if (pdbx_power_acentric != null)
		{
			sb.append("pdbx_power_acentric = ");
			sb.append(pdbx_power_acentric);
			sb.append('\n');
		}
		if (pdbx_power_centric != null)
		{
			sb.append("pdbx_power_centric = ");
			sb.append(pdbx_power_centric);
			sb.append('\n');
		}
		if (power != null)
		{
			sb.append("power = ");
			sb.append(power);
			sb.append('\n');
		}
		if (reflns != null)
		{
			sb.append("reflns = ");
			sb.append(reflns);
			sb.append('\n');
		}
		if (reflns_acentric != null)
		{
			sb.append("reflns_acentric = ");
			sb.append(reflns_acentric);
			sb.append('\n');
		}
		if (reflns_anomalous != null)
		{
			sb.append("reflns_anomalous = ");
			sb.append(reflns_anomalous);
			sb.append('\n');
		}
		if (reflns_centric != null)
		{
			sb.append("reflns_centric = ");
			sb.append(reflns_centric);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		FOM = null;
		FOM_acentric = null;
		FOM_centric = null;
		R_cullis = null;
		R_kraut = null;
		d_res_high = null;
		d_res_low = null;
		loc = null;
		mean_phase = null;
		pdbx_R_cullis_acentric = null;
		pdbx_R_cullis_centric = null;
		pdbx_R_kraut_acentric = null;
		pdbx_R_kraut_centric = null;
		pdbx_loc_acentric = null;
		pdbx_loc_centric = null;
		pdbx_power_acentric = null;
		pdbx_power_centric = null;
		power = null;
		reflns = null;
		reflns_acentric = null;
		reflns_anomalous = null;
		reflns_centric = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_MIR_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_MIR_shell>\n");
			if (FOM != null) ow.write(indent + " <PDBx:FOM>" + FOM + "</PDBx:FOM>\n");
			if (FOM_acentric != null) ow.write(indent + " <PDBx:FOM_acentric>" + FOM_acentric + "</PDBx:FOM_acentric>\n");
			if (FOM_centric != null) ow.write(indent + " <PDBx:FOM_centric>" + FOM_centric + "</PDBx:FOM_centric>\n");
			if (R_cullis != null) ow.write(indent + " <PDBx:R_cullis>" + R_cullis + "</PDBx:R_cullis>\n");
			if (R_kraut != null) ow.write(indent + " <PDBx:R_kraut>" + R_kraut + "</PDBx:R_kraut>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (loc != null) ow.write(indent + " <PDBx:loc>" + loc + "</PDBx:loc>\n");
			if (mean_phase != null) ow.write(indent + " <PDBx:mean_phase>" + mean_phase + "</PDBx:mean_phase>\n");
			if (pdbx_R_cullis_acentric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_acentric>" + pdbx_R_cullis_acentric + "</PDBx:pdbx_R_cullis_acentric>\n");
			if (pdbx_R_cullis_centric != null) ow.write(indent + " <PDBx:pdbx_R_cullis_centric>" + pdbx_R_cullis_centric + "</PDBx:pdbx_R_cullis_centric>\n");
			if (pdbx_R_kraut_acentric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_acentric>" + pdbx_R_kraut_acentric + "</PDBx:pdbx_R_kraut_acentric>\n");
			if (pdbx_R_kraut_centric != null) ow.write(indent + " <PDBx:pdbx_R_kraut_centric>" + pdbx_R_kraut_centric + "</PDBx:pdbx_R_kraut_centric>\n");
			if (pdbx_loc_acentric != null) ow.write(indent + " <PDBx:pdbx_loc_acentric>" + pdbx_loc_acentric + "</PDBx:pdbx_loc_acentric>\n");
			if (pdbx_loc_centric != null) ow.write(indent + " <PDBx:pdbx_loc_centric>" + pdbx_loc_centric + "</PDBx:pdbx_loc_centric>\n");
			if (pdbx_power_acentric != null) ow.write(indent + " <PDBx:pdbx_power_acentric>" + pdbx_power_acentric + "</PDBx:pdbx_power_acentric>\n");
			if (pdbx_power_centric != null) ow.write(indent + " <PDBx:pdbx_power_centric>" + pdbx_power_centric + "</PDBx:pdbx_power_centric>\n");
			if (power != null) ow.write(indent + " <PDBx:power>" + power + "</PDBx:power>\n");
			if (reflns != null) ow.write(indent + " <PDBx:reflns>" + reflns + "</PDBx:reflns>\n");
			if (reflns_acentric != null) ow.write(indent + " <PDBx:reflns_acentric>" + reflns_acentric + "</PDBx:reflns_acentric>\n");
			if (reflns_anomalous != null) ow.write(indent + " <PDBx:reflns_anomalous>" + reflns_anomalous + "</PDBx:reflns_anomalous>\n");
			if (reflns_centric != null) ow.write(indent + " <PDBx:reflns_centric>" + reflns_centric + "</PDBx:reflns_centric>\n");
			ow.write(indent + "</PDBx:phasing_MIR_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
