package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_AVERAGING category record details
 *  about the phasing of the structure where methods involving
 *  averaging of multiple observations of the molecule in the
 *  asymmetric unit are involved.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:phasing_averagingCategory>
 *  <PDBx:phasing_averaging entry_id="EXAMHYPO">
 *  <PDBx:method> Iterative threefold averaging alternating with phase
 *  extensions by 0.5 reciprocal lattice units per cycle.</PDBx:method>
 *  <PDBx:details> The position of the threefold axis was redetermined every
 *  five cycles.</PDBx:details>
 *  </PDBx:phasing_averaging>
 *  </PDBx:phasing_averagingCategory>
 * </pre>
 */
public class Phasing_averaging extends org.pdb.beans.Phasing_averaging implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_averaging";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_averaging()
	{
	}

	/** Full constructor */
	public Phasing_averaging(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.String method)
	{
		this.datablock = datablock;
		this.details = details;
		this.entry_id = entry_id;
		this.method = method;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_averaging");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (method != null)
		{
			sb.append("method = ");
			sb.append(method);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entry_id = null;
		method = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_averaging)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_averaging>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (method != null) ow.write(indent + " <PDBx:method>" + method + "</PDBx:method>\n");
			ow.write(indent + "</PDBx:phasing_averaging>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
