package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PHASING_SET_REFLN category record the values
 *  of the measured structure factors used in a phasing experiment.
 *  This list may contain information from a number of different
 *  data sets;  attribute set_id in category phasing_set_refln indicates the data set
 *  to which a given record corresponds.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the 15,15,32
 *  reflection of an Hg/Pt derivative of protein NS1.
 *  <PDBx:phasing_set_reflnCategory>
 *  <PDBx:phasing_set_refln set_id="NS1-96" index_h="15" index_k="15" index_l="32">
 *  <PDBx:F_meas_au>181.79</PDBx:F_meas_au>
 *  <PDBx:F_meas_sigma_au>3.72</PDBx:F_meas_sigma_au>
 *  </PDBx:phasing_set_refln>
 *  </PDBx:phasing_set_reflnCategory>
 * </pre>
 */
public class Phasing_set_refln extends org.pdb.beans.Phasing_set_refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "phasing_set_refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Phasing_set_refln()
	{
	}

	/** Full constructor */
	public Phasing_set_refln(
		Datablock datablock,
		java.lang.Float F_meas,
		java.lang.Float F_meas_au,
		java.lang.Float F_meas_sigma,
		java.lang.Float F_meas_sigma_au,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.String set_id)
	{
		this.datablock = datablock;
		this.F_meas = F_meas;
		this.F_meas_au = F_meas_au;
		this.F_meas_sigma = F_meas_sigma;
		this.F_meas_sigma_au = F_meas_sigma_au;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.set_id = set_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Phasing_set_refln");
		sb.append("\n");
		if (F_meas != null)
		{
			sb.append("F_meas = ");
			sb.append(F_meas);
			sb.append('\n');
		}
		if (F_meas_au != null)
		{
			sb.append("F_meas_au = ");
			sb.append(F_meas_au);
			sb.append('\n');
		}
		if (F_meas_sigma != null)
		{
			sb.append("F_meas_sigma = ");
			sb.append(F_meas_sigma);
			sb.append('\n');
		}
		if (F_meas_sigma_au != null)
		{
			sb.append("F_meas_sigma_au = ");
			sb.append(F_meas_sigma_au);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (set_id != null)
		{
			sb.append("set_id = ");
			sb.append(set_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		F_meas = null;
		F_meas_au = null;
		F_meas_sigma = null;
		F_meas_sigma_au = null;
		index_h = null;
		index_k = null;
		index_l = null;
		set_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Phasing_set_refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:phasing_set_refln>\n");
			if (F_meas != null) ow.write(indent + " <PDBx:F_meas>" + F_meas + "</PDBx:F_meas>\n");
			if (F_meas_au != null) ow.write(indent + " <PDBx:F_meas_au>" + F_meas_au + "</PDBx:F_meas_au>\n");
			if (F_meas_sigma != null) ow.write(indent + " <PDBx:F_meas_sigma>" + F_meas_sigma + "</PDBx:F_meas_sigma>\n");
			if (F_meas_sigma_au != null) ow.write(indent + " <PDBx:F_meas_sigma_au>" + F_meas_sigma_au + "</PDBx:F_meas_sigma_au>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (set_id != null) ow.write(indent + " <PDBx:set_id>" + set_id + "</PDBx:set_id>\n");
			ow.write(indent + "</PDBx:phasing_set_refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
