package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the PUBL_BODY category permit the labelling of
 *  different text sections within the body of a paper.
 *  Note that these should not be used in a paper which has
 *  a standard format with sections tagged by specific data names
 *  (such as in Acta Crystallographica Section C). Typically,
 *  each journal will supply a list of the specific items it
 *  requires in its Notes for Authors.
 *  
 * <pre>
 *  Example 1 - based on a paper by R. Restori & D. Schwarzenbach
 *  [Acta Cryst. (1996), A52, 369-378].
 *  <PDBx:publ_bodyCategory>
 *  <PDBx:publ_body element="section" label="1">
 *  <PDBx:title>Introduction</PDBx:title>
 *  <PDBx:format>cif</PDBx:format>
 *  <PDBx:contents> X-ray diffraction from a crystalline material provides
 *  information on the thermally and spatially averaged
 *  electron density in the crystal...</PDBx:contents>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="section" label="2">
 *  <PDBx:title>Theory</PDBx:title>
 *  <PDBx:format>tex</PDBx:format>
 *  <PDBx:contents> In the rigid-atom approximation, the dynamic electron
 *  density of an atom is described by the convolution
 *  product of the static atomic density and a probability
 *  density function,
 *  $\rho_{dyn}(\bf r) = \rho_{stat}(\bf r) * P(\bf r). \eqno(1)$</PDBx:contents>
 *  </PDBx:publ_body>
 *  </PDBx:publ_bodyCategory>
 *  
 *  
 *  Example 2 - based on a paper by R. J. Papoular, Y. Vekhter & P. Coppens
 *  [Acta Cryst. (1996), A52, 397-407].
 *  <PDBx:publ_bodyCategory>
 *  <PDBx:publ_body element="section" label="3">
 *  <PDBx:title> The two-channel method for retrieval of the deformation
 *  electron density</PDBx:title>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsection" label="3.1">
 *  <PDBx:title>The two-channel entropy S[\D\r(r)]</PDBx:title>
 *  <PDBx:contents> As the wide dynamic range involved in the total electron
 *  density...</PDBx:contents>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsection" label="3.2">
 *  <PDBx:title>Uniform vs informative prior model densities</PDBx:title>
 *  </PDBx:publ_body>
 *  <PDBx:publ_body element="subsubsection" label="3.2.1">
 *  <PDBx:title>Use of uniform models</PDBx:title>
 *  <PDBx:contents> Straightforward algebra leads to expressions analogous
 *  to...</PDBx:contents>
 *  </PDBx:publ_body>
 *  </PDBx:publ_bodyCategory>
 * </pre>
 */
public class Publ_body extends org.pdb.beans.Publ_body implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "publ_body";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Publ_body()
	{
	}

	/** Full constructor */
	public Publ_body(
		Datablock datablock,
		java.lang.String contents,
		java.lang.String element,
		java.lang.String format,
		java.lang.String label,
		java.lang.String title)
	{
		this.datablock = datablock;
		this.contents = contents;
		this.element = element;
		this.format = format;
		this.label = label;
		this.title = title;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Publ_body");
		sb.append("\n");
		if (contents != null)
		{
			sb.append("contents = ");
			sb.append(contents);
			sb.append('\n');
		}
		if (element != null)
		{
			sb.append("element = ");
			sb.append(element);
			sb.append('\n');
		}
		if (format != null)
		{
			sb.append("format = ");
			sb.append(format);
			sb.append('\n');
		}
		if (label != null)
		{
			sb.append("label = ");
			sb.append(label);
			sb.append('\n');
		}
		if (title != null)
		{
			sb.append("title = ");
			sb.append(title);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		contents = null;
		element = null;
		format = null;
		label = null;
		title = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Publ_body)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:publ_body>\n");
			if (contents != null) ow.write(indent + " <PDBx:contents>" + contents + "</PDBx:contents>\n");
			if (element != null) ow.write(indent + " <PDBx:element>" + element + "</PDBx:element>\n");
			if (format != null) ow.write(indent + " <PDBx:format>" + format + "</PDBx:format>\n");
			if (label != null) ow.write(indent + " <PDBx:label>" + label + "</PDBx:label>\n");
			if (title != null) ow.write(indent + " <PDBx:title>" + title + "</PDBx:title>\n");
			ow.write(indent + "</PDBx:publ_body>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
