package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_B_ISO category record details about
 *  the treatment of isotropic B factors (displacement parameters)
 *  during refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_B_isoCategory>
 *  <PDBx:refine_B_iso class="protein">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  <PDBx:refine_B_iso class="solvent">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  <PDBx:refine_B_iso class="inhibitor">
 *  <PDBx:treatment>isotropic</PDBx:treatment>
 *  </PDBx:refine_B_iso>
 *  </PDBx:refine_B_isoCategory>
 * </pre>
 */
public class Refine_B_iso extends org.pdb.beans.Refine_B_iso implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_B_iso";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_B_iso()
	{
	}

	/** Full constructor */
	public Refine_B_iso(
		Datablock datablock,
		java.lang.String class_,
		java.lang.String details,
		java.lang.String treatment,
		java.lang.Float value)
	{
		this.datablock = datablock;
		this.class_ = class_;
		this.details = details;
		this.treatment = treatment;
		this.value = value;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_B_iso");
		sb.append("\n");
		if (class_ != null)
		{
			sb.append("class = ");
			sb.append(class_);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (treatment != null)
		{
			sb.append("treatment = ");
			sb.append(treatment);
			sb.append('\n');
		}
		if (value != null)
		{
			sb.append("value = ");
			sb.append(value);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		class_ = null;
		details = null;
		treatment = null;
		value = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_B_iso)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_B_iso>\n");
			if (class_ != null) ow.write(indent + " <PDBx:class>" + class_ + "</PDBx:class>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (treatment != null) ow.write(indent + " <PDBx:treatment>" + treatment + "</PDBx:treatment>\n");
			if (value != null) ow.write(indent + " <PDBx:value>" + value + "</PDBx:value>\n");
			ow.write(indent + "</PDBx:refine_B_iso>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
