package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_ANALYZE category record details
 *  about the refined structure that are often used to analyze the
 *  refinement and assess its quality. A given computer program
 *  may or may not produce values corresponding to these data
 *  names.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_analyzeCategory>
 *  <PDBx:refine_analyze entry_id="5HVP">
 *  <PDBx:Luzzati_coordinate_error_obs>0.056</PDBx:Luzzati_coordinate_error_obs>
 *  <PDBx:Luzzati_d_res_low_obs>2.51</PDBx:Luzzati_d_res_low_obs>
 *  </PDBx:refine_analyze>
 *  </PDBx:refine_analyzeCategory>
 * </pre>
 */
public class Refine_analyze extends org.pdb.beans.Refine_analyze implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_analyze";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_analyze()
	{
	}

	/** Full constructor */
	public Refine_analyze(
		Datablock datablock,
		java.lang.Float Luzzati_coordinate_error_free,
		java.lang.Float Luzzati_coordinate_error_obs,
		java.lang.Float Luzzati_d_res_low_free,
		java.lang.Float Luzzati_d_res_low_obs,
		java.lang.Float Luzzati_sigma_a_free,
		java.lang.String Luzzati_sigma_a_free_details,
		java.lang.Float Luzzati_sigma_a_obs,
		java.lang.String Luzzati_sigma_a_obs_details,
		java.lang.Float RG_d_res_high,
		java.lang.Float RG_d_res_low,
		java.lang.Float RG_free,
		java.lang.Float RG_free_work_ratio,
		java.lang.Float RG_work,
		java.lang.String entry_id,
		java.lang.Float number_disordered_residues,
		java.lang.Float occupancy_sum_hydrogen,
		java.lang.Float occupancy_sum_non_hydrogen,
		java.lang.Float pdbx_Luzzati_d_res_high_obs)
	{
		this.datablock = datablock;
		this.Luzzati_coordinate_error_free = Luzzati_coordinate_error_free;
		this.Luzzati_coordinate_error_obs = Luzzati_coordinate_error_obs;
		this.Luzzati_d_res_low_free = Luzzati_d_res_low_free;
		this.Luzzati_d_res_low_obs = Luzzati_d_res_low_obs;
		this.Luzzati_sigma_a_free = Luzzati_sigma_a_free;
		this.Luzzati_sigma_a_free_details = Luzzati_sigma_a_free_details;
		this.Luzzati_sigma_a_obs = Luzzati_sigma_a_obs;
		this.Luzzati_sigma_a_obs_details = Luzzati_sigma_a_obs_details;
		this.RG_d_res_high = RG_d_res_high;
		this.RG_d_res_low = RG_d_res_low;
		this.RG_free = RG_free;
		this.RG_free_work_ratio = RG_free_work_ratio;
		this.RG_work = RG_work;
		this.entry_id = entry_id;
		this.number_disordered_residues = number_disordered_residues;
		this.occupancy_sum_hydrogen = occupancy_sum_hydrogen;
		this.occupancy_sum_non_hydrogen = occupancy_sum_non_hydrogen;
		this.pdbx_Luzzati_d_res_high_obs = pdbx_Luzzati_d_res_high_obs;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_analyze");
		sb.append("\n");
		if (Luzzati_coordinate_error_free != null)
		{
			sb.append("Luzzati_coordinate_error_free = ");
			sb.append(Luzzati_coordinate_error_free);
			sb.append('\n');
		}
		if (Luzzati_coordinate_error_obs != null)
		{
			sb.append("Luzzati_coordinate_error_obs = ");
			sb.append(Luzzati_coordinate_error_obs);
			sb.append('\n');
		}
		if (Luzzati_d_res_low_free != null)
		{
			sb.append("Luzzati_d_res_low_free = ");
			sb.append(Luzzati_d_res_low_free);
			sb.append('\n');
		}
		if (Luzzati_d_res_low_obs != null)
		{
			sb.append("Luzzati_d_res_low_obs = ");
			sb.append(Luzzati_d_res_low_obs);
			sb.append('\n');
		}
		if (Luzzati_sigma_a_free != null)
		{
			sb.append("Luzzati_sigma_a_free = ");
			sb.append(Luzzati_sigma_a_free);
			sb.append('\n');
		}
		if (Luzzati_sigma_a_free_details != null)
		{
			sb.append("Luzzati_sigma_a_free_details = ");
			sb.append(Luzzati_sigma_a_free_details);
			sb.append('\n');
		}
		if (Luzzati_sigma_a_obs != null)
		{
			sb.append("Luzzati_sigma_a_obs = ");
			sb.append(Luzzati_sigma_a_obs);
			sb.append('\n');
		}
		if (Luzzati_sigma_a_obs_details != null)
		{
			sb.append("Luzzati_sigma_a_obs_details = ");
			sb.append(Luzzati_sigma_a_obs_details);
			sb.append('\n');
		}
		if (RG_d_res_high != null)
		{
			sb.append("RG_d_res_high = ");
			sb.append(RG_d_res_high);
			sb.append('\n');
		}
		if (RG_d_res_low != null)
		{
			sb.append("RG_d_res_low = ");
			sb.append(RG_d_res_low);
			sb.append('\n');
		}
		if (RG_free != null)
		{
			sb.append("RG_free = ");
			sb.append(RG_free);
			sb.append('\n');
		}
		if (RG_free_work_ratio != null)
		{
			sb.append("RG_free_work_ratio = ");
			sb.append(RG_free_work_ratio);
			sb.append('\n');
		}
		if (RG_work != null)
		{
			sb.append("RG_work = ");
			sb.append(RG_work);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (number_disordered_residues != null)
		{
			sb.append("number_disordered_residues = ");
			sb.append(number_disordered_residues);
			sb.append('\n');
		}
		if (occupancy_sum_hydrogen != null)
		{
			sb.append("occupancy_sum_hydrogen = ");
			sb.append(occupancy_sum_hydrogen);
			sb.append('\n');
		}
		if (occupancy_sum_non_hydrogen != null)
		{
			sb.append("occupancy_sum_non_hydrogen = ");
			sb.append(occupancy_sum_non_hydrogen);
			sb.append('\n');
		}
		if (pdbx_Luzzati_d_res_high_obs != null)
		{
			sb.append("pdbx_Luzzati_d_res_high_obs = ");
			sb.append(pdbx_Luzzati_d_res_high_obs);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Luzzati_coordinate_error_free = null;
		Luzzati_coordinate_error_obs = null;
		Luzzati_d_res_low_free = null;
		Luzzati_d_res_low_obs = null;
		Luzzati_sigma_a_free = null;
		Luzzati_sigma_a_free_details = null;
		Luzzati_sigma_a_obs = null;
		Luzzati_sigma_a_obs_details = null;
		RG_d_res_high = null;
		RG_d_res_low = null;
		RG_free = null;
		RG_free_work_ratio = null;
		RG_work = null;
		entry_id = null;
		number_disordered_residues = null;
		occupancy_sum_hydrogen = null;
		occupancy_sum_non_hydrogen = null;
		pdbx_Luzzati_d_res_high_obs = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_analyze)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_analyze>\n");
			if (Luzzati_coordinate_error_free != null) ow.write(indent + " <PDBx:Luzzati_coordinate_error_free>" + Luzzati_coordinate_error_free + "</PDBx:Luzzati_coordinate_error_free>\n");
			if (Luzzati_coordinate_error_obs != null) ow.write(indent + " <PDBx:Luzzati_coordinate_error_obs>" + Luzzati_coordinate_error_obs + "</PDBx:Luzzati_coordinate_error_obs>\n");
			if (Luzzati_d_res_low_free != null) ow.write(indent + " <PDBx:Luzzati_d_res_low_free>" + Luzzati_d_res_low_free + "</PDBx:Luzzati_d_res_low_free>\n");
			if (Luzzati_d_res_low_obs != null) ow.write(indent + " <PDBx:Luzzati_d_res_low_obs>" + Luzzati_d_res_low_obs + "</PDBx:Luzzati_d_res_low_obs>\n");
			if (Luzzati_sigma_a_free != null) ow.write(indent + " <PDBx:Luzzati_sigma_a_free>" + Luzzati_sigma_a_free + "</PDBx:Luzzati_sigma_a_free>\n");
			if (Luzzati_sigma_a_free_details != null) ow.write(indent + " <PDBx:Luzzati_sigma_a_free_details>" + Luzzati_sigma_a_free_details + "</PDBx:Luzzati_sigma_a_free_details>\n");
			if (Luzzati_sigma_a_obs != null) ow.write(indent + " <PDBx:Luzzati_sigma_a_obs>" + Luzzati_sigma_a_obs + "</PDBx:Luzzati_sigma_a_obs>\n");
			if (Luzzati_sigma_a_obs_details != null) ow.write(indent + " <PDBx:Luzzati_sigma_a_obs_details>" + Luzzati_sigma_a_obs_details + "</PDBx:Luzzati_sigma_a_obs_details>\n");
			if (RG_d_res_high != null) ow.write(indent + " <PDBx:RG_d_res_high>" + RG_d_res_high + "</PDBx:RG_d_res_high>\n");
			if (RG_d_res_low != null) ow.write(indent + " <PDBx:RG_d_res_low>" + RG_d_res_low + "</PDBx:RG_d_res_low>\n");
			if (RG_free != null) ow.write(indent + " <PDBx:RG_free>" + RG_free + "</PDBx:RG_free>\n");
			if (RG_free_work_ratio != null) ow.write(indent + " <PDBx:RG_free_work_ratio>" + RG_free_work_ratio + "</PDBx:RG_free_work_ratio>\n");
			if (RG_work != null) ow.write(indent + " <PDBx:RG_work>" + RG_work + "</PDBx:RG_work>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (number_disordered_residues != null) ow.write(indent + " <PDBx:number_disordered_residues>" + number_disordered_residues + "</PDBx:number_disordered_residues>\n");
			if (occupancy_sum_hydrogen != null) ow.write(indent + " <PDBx:occupancy_sum_hydrogen>" + occupancy_sum_hydrogen + "</PDBx:occupancy_sum_hydrogen>\n");
			if (occupancy_sum_non_hydrogen != null) ow.write(indent + " <PDBx:occupancy_sum_non_hydrogen>" + occupancy_sum_non_hydrogen + "</PDBx:occupancy_sum_non_hydrogen>\n");
			if (pdbx_Luzzati_d_res_high_obs != null) ow.write(indent + " <PDBx:pdbx_Luzzati_d_res_high_obs>" + pdbx_Luzzati_d_res_high_obs + "</PDBx:pdbx_Luzzati_d_res_high_obs>\n");
			ow.write(indent + "</PDBx:refine_analyze>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
