package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_FUNCT_MINIMIZED category record
 *  details about the individual terms of the function minimized
 *  during refinement.
 *  
 * <pre>
 *  Example 1 - based on RESTRAIN refinement for the CCP4 test data set
 *  toxd.
 *  <PDBx:refine_funct_minimizedCategory>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Amplitude)^2">
 *  <PDBx:number_terms>3009</PDBx:number_terms>
 *  <PDBx:residual>1621.3</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Plane+Rigid)^2">
 *  <PDBx:number_terms>85</PDBx:number_terms>
 *  <PDBx:residual>56.68</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(Distance)^2">
 *  <PDBx:number_terms>1219</PDBx:number_terms>
 *  <PDBx:residual>163.59</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  <PDBx:refine_funct_minimized type="sum(W*Delta(U-tempfactors)^2">
 *  <PDBx:number_terms>1192</PDBx:number_terms>
 *  <PDBx:residual>69.338</PDBx:residual>
 *  </PDBx:refine_funct_minimized>
 *  </PDBx:refine_funct_minimizedCategory>
 * </pre>
 */
public class Refine_funct_minimized extends org.pdb.beans.Refine_funct_minimized implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_funct_minimized";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_funct_minimized()
	{
	}

	/** Full constructor */
	public Refine_funct_minimized(
		Datablock datablock,
		java.lang.Integer number_terms,
		java.lang.Float residual,
		java.lang.String type,
		java.lang.Float weight)
	{
		this.datablock = datablock;
		this.number_terms = number_terms;
		this.residual = residual;
		this.type = type;
		this.weight = weight;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_funct_minimized");
		sb.append("\n");
		if (number_terms != null)
		{
			sb.append("number_terms = ");
			sb.append(number_terms);
			sb.append('\n');
		}
		if (residual != null)
		{
			sb.append("residual = ");
			sb.append(residual);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (weight != null)
		{
			sb.append("weight = ");
			sb.append(weight);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		number_terms = null;
		residual = null;
		type = null;
		weight = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_funct_minimized)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_funct_minimized>\n");
			if (number_terms != null) ow.write(indent + " <PDBx:number_terms>" + number_terms + "</PDBx:number_terms>\n");
			if (residual != null) ow.write(indent + " <PDBx:residual>" + residual + "</PDBx:residual>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (weight != null) ow.write(indent + " <PDBx:weight>" + weight + "</PDBx:weight>\n");
			ow.write(indent + "</PDBx:refine_funct_minimized>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
