package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_LS_RESTR category record details about
 *  the restraints applied to various classes of parameters during
 *  the least-squares refinement.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr type="bond_d">
 *  <PDBx:dev_ideal_target>0.020</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.018</PDBx:dev_ideal>
 *  <PDBx:number>1654</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>22</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="angle_d">
 *  <PDBx:dev_ideal_target>0.030</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.038</PDBx:dev_ideal>
 *  <PDBx:number>2246</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>139</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar_d">
 *  <PDBx:dev_ideal_target>0.040</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.043</PDBx:dev_ideal>
 *  <PDBx:number>498</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>21</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar">
 *  <PDBx:dev_ideal_target>0.020</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.015</PDBx:dev_ideal>
 *  <PDBx:number>270</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>1</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="chiral">
 *  <PDBx:dev_ideal_target>0.150</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.177</PDBx:dev_ideal>
 *  <PDBx:number>278</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>2</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="singtor_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.216</PDBx:dev_ideal>
 *  <PDBx:number>582</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="multtor_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.207</PDBx:dev_ideal>
 *  <PDBx:number>419</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="xyhbond_nbd">
 *  <PDBx:dev_ideal_target>0.500</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>0.245</PDBx:dev_ideal>
 *  <PDBx:number>149</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>0</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="planar_tor">
 *  <PDBx:dev_ideal_target>3.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>2.6</PDBx:dev_ideal>
 *  <PDBx:number>203</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>9</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="staggered_tor">
 *  <PDBx:dev_ideal_target>15.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>17.4</PDBx:dev_ideal>
 *  <PDBx:number>298</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>31</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="orthonormal_tor">
 *  <PDBx:dev_ideal_target>20.0</PDBx:dev_ideal_target>
 *  <PDBx:dev_ideal>18.1</PDBx:dev_ideal>
 *  <PDBx:number>12</PDBx:number>
 *  <PDBx:criterion>&gt; 2\s</PDBx:criterion>
 *  <PDBx:rejects>1</PDBx:rejects>
 *  </PDBx:refine_ls_restr>
 *  </PDBx:refine_ls_restrCategory>
 * </pre>
 */
public class Refine_ls_restr extends org.pdb.beans.Refine_ls_restr implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_ls_restr";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_ls_restr()
	{
	}

	/** Full constructor */
	public Refine_ls_restr(
		Datablock datablock,
		java.lang.String criterion,
		java.lang.Float dev_ideal,
		java.lang.Float dev_ideal_target,
		java.lang.Integer number,
		java.lang.Integer rejects,
		java.lang.String type,
		java.lang.Float weight)
	{
		this.datablock = datablock;
		this.criterion = criterion;
		this.dev_ideal = dev_ideal;
		this.dev_ideal_target = dev_ideal_target;
		this.number = number;
		this.rejects = rejects;
		this.type = type;
		this.weight = weight;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_ls_restr");
		sb.append("\n");
		if (criterion != null)
		{
			sb.append("criterion = ");
			sb.append(criterion);
			sb.append('\n');
		}
		if (dev_ideal != null)
		{
			sb.append("dev_ideal = ");
			sb.append(dev_ideal);
			sb.append('\n');
		}
		if (dev_ideal_target != null)
		{
			sb.append("dev_ideal_target = ");
			sb.append(dev_ideal_target);
			sb.append('\n');
		}
		if (number != null)
		{
			sb.append("number = ");
			sb.append(number);
			sb.append('\n');
		}
		if (rejects != null)
		{
			sb.append("rejects = ");
			sb.append(rejects);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		if (weight != null)
		{
			sb.append("weight = ");
			sb.append(weight);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		criterion = null;
		dev_ideal = null;
		dev_ideal_target = null;
		number = null;
		rejects = null;
		type = null;
		weight = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_ls_restr)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_ls_restr>\n");
			if (criterion != null) ow.write(indent + " <PDBx:criterion>" + criterion + "</PDBx:criterion>\n");
			if (dev_ideal != null) ow.write(indent + " <PDBx:dev_ideal>" + dev_ideal + "</PDBx:dev_ideal>\n");
			if (dev_ideal_target != null) ow.write(indent + " <PDBx:dev_ideal_target>" + dev_ideal_target + "</PDBx:dev_ideal_target>\n");
			if (number != null) ow.write(indent + " <PDBx:number>" + number + "</PDBx:number>\n");
			if (rejects != null) ow.write(indent + " <PDBx:rejects>" + rejects + "</PDBx:rejects>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			if (weight != null) ow.write(indent + " <PDBx:weight>" + weight + "</PDBx:weight>\n");
			ow.write(indent + "</PDBx:refine_ls_restr>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
