package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFINE_LS_RESTR_TYPE category record details
 *  about the restraint types used in the least-squares refinement.
 *  
 * <pre>
 *  Example 1 - based on RESTRAIN refinement for the CCP4 test data set
 *  toxd.
 *  <PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances &lt; 2.12">
 *  <PDBx:number>509</PDBx:number>
 *  <PDBx:dev_ideal>0.005</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.022</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances 2.12 &lt; D &lt; 2.625">
 *  <PDBx:number>671</PDBx:number>
 *  <PDBx:dev_ideal>0.016</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.037</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Distances &gt; 2.625">
 *  <PDBx:number>39</PDBx:number>
 *  <PDBx:dev_ideal>0.034</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.043</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Peptide Planes">
 *  <PDBx:number>59</PDBx:number>
 *  <PDBx:dev_ideal>0.002</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.010</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_Ring and other planes">
 *  <PDBx:number>26</PDBx:number>
 *  <PDBx:dev_ideal>0.014</PDBx:dev_ideal>
 *  <PDBx:dev_ideal_target>0.010</PDBx:dev_ideal_target>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.2-1.4">
 *  <PDBx:number>212</PDBx:number>
 *  <PDBx:dev_ideal>0.106</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.4-1.6">
 *  <PDBx:number>288</PDBx:number>
 *  <PDBx:dev_ideal>0.101</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 1.8-2.0">
 *  <PDBx:number>6</PDBx:number>
 *  <PDBx:dev_ideal>0.077</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 2.0-2.2">
 *  <PDBx:number>10</PDBx:number>
 *  <PDBx:dev_ideal>0.114</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist 2.2-2.4">
 *  <PDBx:number>215</PDBx:number>
 *  <PDBx:dev_ideal>0.119</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  <PDBx:refine_ls_restr type="RESTRAIN_rms diffs for Uiso atoms at dist &gt;2.4">
 *  <PDBx:number>461</PDBx:number>
 *  <PDBx:dev_ideal>0.106</PDBx:dev_ideal>
 *  </PDBx:refine_ls_restr>
 *  </PDBx:refine_ls_restrCategory>
 *  <PDBx:refine_ls_restr_typeCategory>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances &lt; 2.12">
 *  <PDBx:distance_cutoff_high>2.12</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances 2.12 &lt; D &lt; 2.625">
 *  <PDBx:distance_cutoff_low>2.12</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.625</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_Distances &gt; 2.625">
 *  <PDBx:distance_cutoff_low>2.625</PDBx:distance_cutoff_low>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.2-1.4">
 *  <PDBx:distance_cutoff_low>1.2</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>1.4</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.4-1.6">
 *  <PDBx:distance_cutoff_low>1.4</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>1.6</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 1.8-2.0">
 *  <PDBx:distance_cutoff_low>1.8</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.0</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 2.0-2.2">
 *  <PDBx:distance_cutoff_low>2.0</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.2</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist 2.2-2.4">
 *  <PDBx:distance_cutoff_low>2.2</PDBx:distance_cutoff_low>
 *  <PDBx:distance_cutoff_high>2.4</PDBx:distance_cutoff_high>
 *  </PDBx:refine_ls_restr_type>
 *  <PDBx:refine_ls_restr_type type="RESTRAIN_rms diffs for Uiso atoms at dist &gt;2.4">
 *  <PDBx:distance_cutoff_low>2.4</PDBx:distance_cutoff_low>
 *  </PDBx:refine_ls_restr_type>
 *  </PDBx:refine_ls_restr_typeCategory>
 * </pre>
 */
public class Refine_ls_restr_type extends org.pdb.beans.Refine_ls_restr_type implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refine_ls_restr_type";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refine_ls_restr_type()
	{
	}

	/** Full constructor */
	public Refine_ls_restr_type(
		Datablock datablock,
		java.lang.Float distance_cutoff_high,
		java.lang.Float distance_cutoff_low,
		java.lang.String type)
	{
		this.datablock = datablock;
		this.distance_cutoff_high = distance_cutoff_high;
		this.distance_cutoff_low = distance_cutoff_low;
		this.type = type;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refine_ls_restr_type");
		sb.append("\n");
		if (distance_cutoff_high != null)
		{
			sb.append("distance_cutoff_high = ");
			sb.append(distance_cutoff_high);
			sb.append('\n');
		}
		if (distance_cutoff_low != null)
		{
			sb.append("distance_cutoff_low = ");
			sb.append(distance_cutoff_low);
			sb.append('\n');
		}
		if (type != null)
		{
			sb.append("type = ");
			sb.append(type);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		distance_cutoff_high = null;
		distance_cutoff_low = null;
		type = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refine_ls_restr_type)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refine_ls_restr_type>\n");
			if (distance_cutoff_high != null) ow.write(indent + " <PDBx:distance_cutoff_high>" + distance_cutoff_high + "</PDBx:distance_cutoff_high>\n");
			if (distance_cutoff_low != null) ow.write(indent + " <PDBx:distance_cutoff_low>" + distance_cutoff_low + "</PDBx:distance_cutoff_low>\n");
			if (type != null) ow.write(indent + " <PDBx:type>" + type + "</PDBx:type>\n");
			ow.write(indent + "</PDBx:refine_ls_restr_type>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
