package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLN category record details about the
 *  reflection data used to determine the ATOM_SITE data items.
 *  
 *  The REFLN data items refer to individual reflections and must
 *  be included in looped lists.
 *  
 *  The REFLNS data items specify the parameters that apply to all
 *  reflections. The REFLNS data items are not looped.
 *  
 * <pre>
 *  Example 1 - based on data set fetod of Todres, Yanovsky, Ermekov & Struchkov
 *  [Acta Cryst. (1993), C49, 1352-1354].
 *  <PDBx:reflnCategory>
 *  <PDBx:refln index_h="2" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>85.57</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>58.90</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>1.45</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="3" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>15718.18</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>15631.06</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>30.40</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="4" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>55613.11</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>49840.09</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>61.86</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="5" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>246.85</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>241.86</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>10.02</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="6" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>82.16</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>69.97</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>1.93</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="7" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>1133.62</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>947.79</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>11.78</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="8" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>2558.04</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>2453.33</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>20.44</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="9" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>283.88</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>393.66</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>7.79</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  <PDBx:refln index_h="10" index_k="0" index_l="0">
 *  <PDBx:F_squared_calc>283.70</PDBx:F_squared_calc>
 *  <PDBx:F_squared_meas>171.98</PDBx:F_squared_meas>
 *  <PDBx:F_squared_sigma>4.26</PDBx:F_squared_sigma>
 *  <PDBx:status>o</PDBx:status>
 *  </PDBx:refln>
 *  </PDBx:reflnCategory>
 * </pre>
 */
public class Refln extends org.pdb.beans.Refln implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refln";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refln()
	{
	}

	/** Full constructor */
	public Refln(
		Datablock datablock,
		java.lang.Float A_calc,
		java.lang.Float A_calc_au,
		java.lang.Float A_meas,
		java.lang.Float A_meas_au,
		java.lang.Float B_calc,
		java.lang.Float B_calc_au,
		java.lang.Float B_meas,
		java.lang.Float B_meas_au,
		java.lang.Float F_calc,
		java.lang.Float F_calc_au,
		java.lang.Float F_meas,
		java.lang.Float F_meas_au,
		java.lang.Float F_meas_sigma,
		java.lang.Float F_meas_sigma_au,
		java.lang.Float F_squared_calc,
		java.lang.Float F_squared_meas,
		java.lang.Float F_squared_sigma,
		java.lang.String class_code,
		java.lang.String crystal_id,
		java.lang.Float d_spacing,
		java.lang.Float fom,
		java.lang.String include_status,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float intensity_calc,
		java.lang.Float intensity_meas,
		java.lang.Float intensity_sigma,
		java.lang.Float mean_path_length_tbar,
		java.lang.Float pdbx_F_calc_part_solvent,
		java.lang.Float pdbx_F_calc_with_solvent,
		java.lang.Float pdbx_F_minus,
		java.lang.Float pdbx_F_minus_sigma,
		java.lang.Float pdbx_F_plus,
		java.lang.Float pdbx_F_plus_sigma,
		java.lang.Float pdbx_HL_A_iso,
		java.lang.Float pdbx_HL_B_iso,
		java.lang.Float pdbx_HL_C_iso,
		java.lang.Float pdbx_HL_D_iso,
		java.lang.Float pdbx_I_minus,
		java.lang.Float pdbx_I_minus_sigma,
		java.lang.Float pdbx_I_plus,
		java.lang.Float pdbx_I_plus_sigma,
		java.lang.Float pdbx_anom_difference,
		java.lang.Float pdbx_anom_difference_sigma,
		java.lang.Float pdbx_phase_calc_part_solvent,
		java.lang.Float pdbx_phase_calc_with_solvent,
		java.lang.Float phase_calc,
		java.lang.Float phase_meas,
		java.lang.String refinement_status,
		java.lang.String scale_group_code,
		java.lang.Float sint_over_lambda,
		java.lang.String status,
		java.lang.Integer symmetry_epsilon,
		java.lang.Integer symmetry_multiplicity,
		java.lang.Float wavelength,
		java.lang.String wavelength_id)
	{
		this.datablock = datablock;
		this.A_calc = A_calc;
		this.A_calc_au = A_calc_au;
		this.A_meas = A_meas;
		this.A_meas_au = A_meas_au;
		this.B_calc = B_calc;
		this.B_calc_au = B_calc_au;
		this.B_meas = B_meas;
		this.B_meas_au = B_meas_au;
		this.F_calc = F_calc;
		this.F_calc_au = F_calc_au;
		this.F_meas = F_meas;
		this.F_meas_au = F_meas_au;
		this.F_meas_sigma = F_meas_sigma;
		this.F_meas_sigma_au = F_meas_sigma_au;
		this.F_squared_calc = F_squared_calc;
		this.F_squared_meas = F_squared_meas;
		this.F_squared_sigma = F_squared_sigma;
		this.class_code = class_code;
		this.crystal_id = crystal_id;
		this.d_spacing = d_spacing;
		this.fom = fom;
		this.include_status = include_status;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.intensity_calc = intensity_calc;
		this.intensity_meas = intensity_meas;
		this.intensity_sigma = intensity_sigma;
		this.mean_path_length_tbar = mean_path_length_tbar;
		this.pdbx_F_calc_part_solvent = pdbx_F_calc_part_solvent;
		this.pdbx_F_calc_with_solvent = pdbx_F_calc_with_solvent;
		this.pdbx_F_minus = pdbx_F_minus;
		this.pdbx_F_minus_sigma = pdbx_F_minus_sigma;
		this.pdbx_F_plus = pdbx_F_plus;
		this.pdbx_F_plus_sigma = pdbx_F_plus_sigma;
		this.pdbx_HL_A_iso = pdbx_HL_A_iso;
		this.pdbx_HL_B_iso = pdbx_HL_B_iso;
		this.pdbx_HL_C_iso = pdbx_HL_C_iso;
		this.pdbx_HL_D_iso = pdbx_HL_D_iso;
		this.pdbx_I_minus = pdbx_I_minus;
		this.pdbx_I_minus_sigma = pdbx_I_minus_sigma;
		this.pdbx_I_plus = pdbx_I_plus;
		this.pdbx_I_plus_sigma = pdbx_I_plus_sigma;
		this.pdbx_anom_difference = pdbx_anom_difference;
		this.pdbx_anom_difference_sigma = pdbx_anom_difference_sigma;
		this.pdbx_phase_calc_part_solvent = pdbx_phase_calc_part_solvent;
		this.pdbx_phase_calc_with_solvent = pdbx_phase_calc_with_solvent;
		this.phase_calc = phase_calc;
		this.phase_meas = phase_meas;
		this.refinement_status = refinement_status;
		this.scale_group_code = scale_group_code;
		this.sint_over_lambda = sint_over_lambda;
		this.status = status;
		this.symmetry_epsilon = symmetry_epsilon;
		this.symmetry_multiplicity = symmetry_multiplicity;
		this.wavelength = wavelength;
		this.wavelength_id = wavelength_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refln");
		sb.append("\n");
		if (A_calc != null)
		{
			sb.append("A_calc = ");
			sb.append(A_calc);
			sb.append('\n');
		}
		if (A_calc_au != null)
		{
			sb.append("A_calc_au = ");
			sb.append(A_calc_au);
			sb.append('\n');
		}
		if (A_meas != null)
		{
			sb.append("A_meas = ");
			sb.append(A_meas);
			sb.append('\n');
		}
		if (A_meas_au != null)
		{
			sb.append("A_meas_au = ");
			sb.append(A_meas_au);
			sb.append('\n');
		}
		if (B_calc != null)
		{
			sb.append("B_calc = ");
			sb.append(B_calc);
			sb.append('\n');
		}
		if (B_calc_au != null)
		{
			sb.append("B_calc_au = ");
			sb.append(B_calc_au);
			sb.append('\n');
		}
		if (B_meas != null)
		{
			sb.append("B_meas = ");
			sb.append(B_meas);
			sb.append('\n');
		}
		if (B_meas_au != null)
		{
			sb.append("B_meas_au = ");
			sb.append(B_meas_au);
			sb.append('\n');
		}
		if (F_calc != null)
		{
			sb.append("F_calc = ");
			sb.append(F_calc);
			sb.append('\n');
		}
		if (F_calc_au != null)
		{
			sb.append("F_calc_au = ");
			sb.append(F_calc_au);
			sb.append('\n');
		}
		if (F_meas != null)
		{
			sb.append("F_meas = ");
			sb.append(F_meas);
			sb.append('\n');
		}
		if (F_meas_au != null)
		{
			sb.append("F_meas_au = ");
			sb.append(F_meas_au);
			sb.append('\n');
		}
		if (F_meas_sigma != null)
		{
			sb.append("F_meas_sigma = ");
			sb.append(F_meas_sigma);
			sb.append('\n');
		}
		if (F_meas_sigma_au != null)
		{
			sb.append("F_meas_sigma_au = ");
			sb.append(F_meas_sigma_au);
			sb.append('\n');
		}
		if (F_squared_calc != null)
		{
			sb.append("F_squared_calc = ");
			sb.append(F_squared_calc);
			sb.append('\n');
		}
		if (F_squared_meas != null)
		{
			sb.append("F_squared_meas = ");
			sb.append(F_squared_meas);
			sb.append('\n');
		}
		if (F_squared_sigma != null)
		{
			sb.append("F_squared_sigma = ");
			sb.append(F_squared_sigma);
			sb.append('\n');
		}
		if (class_code != null)
		{
			sb.append("class_code = ");
			sb.append(class_code);
			sb.append('\n');
		}
		if (crystal_id != null)
		{
			sb.append("crystal_id = ");
			sb.append(crystal_id);
			sb.append('\n');
		}
		if (d_spacing != null)
		{
			sb.append("d_spacing = ");
			sb.append(d_spacing);
			sb.append('\n');
		}
		if (fom != null)
		{
			sb.append("fom = ");
			sb.append(fom);
			sb.append('\n');
		}
		if (include_status != null)
		{
			sb.append("include_status = ");
			sb.append(include_status);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (intensity_calc != null)
		{
			sb.append("intensity_calc = ");
			sb.append(intensity_calc);
			sb.append('\n');
		}
		if (intensity_meas != null)
		{
			sb.append("intensity_meas = ");
			sb.append(intensity_meas);
			sb.append('\n');
		}
		if (intensity_sigma != null)
		{
			sb.append("intensity_sigma = ");
			sb.append(intensity_sigma);
			sb.append('\n');
		}
		if (mean_path_length_tbar != null)
		{
			sb.append("mean_path_length_tbar = ");
			sb.append(mean_path_length_tbar);
			sb.append('\n');
		}
		if (pdbx_F_calc_part_solvent != null)
		{
			sb.append("pdbx_F_calc_part_solvent = ");
			sb.append(pdbx_F_calc_part_solvent);
			sb.append('\n');
		}
		if (pdbx_F_calc_with_solvent != null)
		{
			sb.append("pdbx_F_calc_with_solvent = ");
			sb.append(pdbx_F_calc_with_solvent);
			sb.append('\n');
		}
		if (pdbx_F_minus != null)
		{
			sb.append("pdbx_F_minus = ");
			sb.append(pdbx_F_minus);
			sb.append('\n');
		}
		if (pdbx_F_minus_sigma != null)
		{
			sb.append("pdbx_F_minus_sigma = ");
			sb.append(pdbx_F_minus_sigma);
			sb.append('\n');
		}
		if (pdbx_F_plus != null)
		{
			sb.append("pdbx_F_plus = ");
			sb.append(pdbx_F_plus);
			sb.append('\n');
		}
		if (pdbx_F_plus_sigma != null)
		{
			sb.append("pdbx_F_plus_sigma = ");
			sb.append(pdbx_F_plus_sigma);
			sb.append('\n');
		}
		if (pdbx_HL_A_iso != null)
		{
			sb.append("pdbx_HL_A_iso = ");
			sb.append(pdbx_HL_A_iso);
			sb.append('\n');
		}
		if (pdbx_HL_B_iso != null)
		{
			sb.append("pdbx_HL_B_iso = ");
			sb.append(pdbx_HL_B_iso);
			sb.append('\n');
		}
		if (pdbx_HL_C_iso != null)
		{
			sb.append("pdbx_HL_C_iso = ");
			sb.append(pdbx_HL_C_iso);
			sb.append('\n');
		}
		if (pdbx_HL_D_iso != null)
		{
			sb.append("pdbx_HL_D_iso = ");
			sb.append(pdbx_HL_D_iso);
			sb.append('\n');
		}
		if (pdbx_I_minus != null)
		{
			sb.append("pdbx_I_minus = ");
			sb.append(pdbx_I_minus);
			sb.append('\n');
		}
		if (pdbx_I_minus_sigma != null)
		{
			sb.append("pdbx_I_minus_sigma = ");
			sb.append(pdbx_I_minus_sigma);
			sb.append('\n');
		}
		if (pdbx_I_plus != null)
		{
			sb.append("pdbx_I_plus = ");
			sb.append(pdbx_I_plus);
			sb.append('\n');
		}
		if (pdbx_I_plus_sigma != null)
		{
			sb.append("pdbx_I_plus_sigma = ");
			sb.append(pdbx_I_plus_sigma);
			sb.append('\n');
		}
		if (pdbx_anom_difference != null)
		{
			sb.append("pdbx_anom_difference = ");
			sb.append(pdbx_anom_difference);
			sb.append('\n');
		}
		if (pdbx_anom_difference_sigma != null)
		{
			sb.append("pdbx_anom_difference_sigma = ");
			sb.append(pdbx_anom_difference_sigma);
			sb.append('\n');
		}
		if (pdbx_phase_calc_part_solvent != null)
		{
			sb.append("pdbx_phase_calc_part_solvent = ");
			sb.append(pdbx_phase_calc_part_solvent);
			sb.append('\n');
		}
		if (pdbx_phase_calc_with_solvent != null)
		{
			sb.append("pdbx_phase_calc_with_solvent = ");
			sb.append(pdbx_phase_calc_with_solvent);
			sb.append('\n');
		}
		if (phase_calc != null)
		{
			sb.append("phase_calc = ");
			sb.append(phase_calc);
			sb.append('\n');
		}
		if (phase_meas != null)
		{
			sb.append("phase_meas = ");
			sb.append(phase_meas);
			sb.append('\n');
		}
		if (refinement_status != null)
		{
			sb.append("refinement_status = ");
			sb.append(refinement_status);
			sb.append('\n');
		}
		if (scale_group_code != null)
		{
			sb.append("scale_group_code = ");
			sb.append(scale_group_code);
			sb.append('\n');
		}
		if (sint_over_lambda != null)
		{
			sb.append("sint_over_lambda = ");
			sb.append(sint_over_lambda);
			sb.append('\n');
		}
		if (status != null)
		{
			sb.append("status = ");
			sb.append(status);
			sb.append('\n');
		}
		if (symmetry_epsilon != null)
		{
			sb.append("symmetry_epsilon = ");
			sb.append(symmetry_epsilon);
			sb.append('\n');
		}
		if (symmetry_multiplicity != null)
		{
			sb.append("symmetry_multiplicity = ");
			sb.append(symmetry_multiplicity);
			sb.append('\n');
		}
		if (wavelength != null)
		{
			sb.append("wavelength = ");
			sb.append(wavelength);
			sb.append('\n');
		}
		if (wavelength_id != null)
		{
			sb.append("wavelength_id = ");
			sb.append(wavelength_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		A_calc = null;
		A_calc_au = null;
		A_meas = null;
		A_meas_au = null;
		B_calc = null;
		B_calc_au = null;
		B_meas = null;
		B_meas_au = null;
		F_calc = null;
		F_calc_au = null;
		F_meas = null;
		F_meas_au = null;
		F_meas_sigma = null;
		F_meas_sigma_au = null;
		F_squared_calc = null;
		F_squared_meas = null;
		F_squared_sigma = null;
		class_code = null;
		crystal_id = null;
		d_spacing = null;
		fom = null;
		include_status = null;
		index_h = null;
		index_k = null;
		index_l = null;
		intensity_calc = null;
		intensity_meas = null;
		intensity_sigma = null;
		mean_path_length_tbar = null;
		pdbx_F_calc_part_solvent = null;
		pdbx_F_calc_with_solvent = null;
		pdbx_F_minus = null;
		pdbx_F_minus_sigma = null;
		pdbx_F_plus = null;
		pdbx_F_plus_sigma = null;
		pdbx_HL_A_iso = null;
		pdbx_HL_B_iso = null;
		pdbx_HL_C_iso = null;
		pdbx_HL_D_iso = null;
		pdbx_I_minus = null;
		pdbx_I_minus_sigma = null;
		pdbx_I_plus = null;
		pdbx_I_plus_sigma = null;
		pdbx_anom_difference = null;
		pdbx_anom_difference_sigma = null;
		pdbx_phase_calc_part_solvent = null;
		pdbx_phase_calc_with_solvent = null;
		phase_calc = null;
		phase_meas = null;
		refinement_status = null;
		scale_group_code = null;
		sint_over_lambda = null;
		status = null;
		symmetry_epsilon = null;
		symmetry_multiplicity = null;
		wavelength = null;
		wavelength_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refln)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refln>\n");
			if (A_calc != null) ow.write(indent + " <PDBx:A_calc>" + A_calc + "</PDBx:A_calc>\n");
			if (A_calc_au != null) ow.write(indent + " <PDBx:A_calc_au>" + A_calc_au + "</PDBx:A_calc_au>\n");
			if (A_meas != null) ow.write(indent + " <PDBx:A_meas>" + A_meas + "</PDBx:A_meas>\n");
			if (A_meas_au != null) ow.write(indent + " <PDBx:A_meas_au>" + A_meas_au + "</PDBx:A_meas_au>\n");
			if (B_calc != null) ow.write(indent + " <PDBx:B_calc>" + B_calc + "</PDBx:B_calc>\n");
			if (B_calc_au != null) ow.write(indent + " <PDBx:B_calc_au>" + B_calc_au + "</PDBx:B_calc_au>\n");
			if (B_meas != null) ow.write(indent + " <PDBx:B_meas>" + B_meas + "</PDBx:B_meas>\n");
			if (B_meas_au != null) ow.write(indent + " <PDBx:B_meas_au>" + B_meas_au + "</PDBx:B_meas_au>\n");
			if (F_calc != null) ow.write(indent + " <PDBx:F_calc>" + F_calc + "</PDBx:F_calc>\n");
			if (F_calc_au != null) ow.write(indent + " <PDBx:F_calc_au>" + F_calc_au + "</PDBx:F_calc_au>\n");
			if (F_meas != null) ow.write(indent + " <PDBx:F_meas>" + F_meas + "</PDBx:F_meas>\n");
			if (F_meas_au != null) ow.write(indent + " <PDBx:F_meas_au>" + F_meas_au + "</PDBx:F_meas_au>\n");
			if (F_meas_sigma != null) ow.write(indent + " <PDBx:F_meas_sigma>" + F_meas_sigma + "</PDBx:F_meas_sigma>\n");
			if (F_meas_sigma_au != null) ow.write(indent + " <PDBx:F_meas_sigma_au>" + F_meas_sigma_au + "</PDBx:F_meas_sigma_au>\n");
			if (F_squared_calc != null) ow.write(indent + " <PDBx:F_squared_calc>" + F_squared_calc + "</PDBx:F_squared_calc>\n");
			if (F_squared_meas != null) ow.write(indent + " <PDBx:F_squared_meas>" + F_squared_meas + "</PDBx:F_squared_meas>\n");
			if (F_squared_sigma != null) ow.write(indent + " <PDBx:F_squared_sigma>" + F_squared_sigma + "</PDBx:F_squared_sigma>\n");
			if (class_code != null) ow.write(indent + " <PDBx:class_code>" + class_code + "</PDBx:class_code>\n");
			if (crystal_id != null) ow.write(indent + " <PDBx:crystal_id>" + crystal_id + "</PDBx:crystal_id>\n");
			if (d_spacing != null) ow.write(indent + " <PDBx:d_spacing>" + d_spacing + "</PDBx:d_spacing>\n");
			if (fom != null) ow.write(indent + " <PDBx:fom>" + fom + "</PDBx:fom>\n");
			if (include_status != null) ow.write(indent + " <PDBx:include_status>" + include_status + "</PDBx:include_status>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (intensity_calc != null) ow.write(indent + " <PDBx:intensity_calc>" + intensity_calc + "</PDBx:intensity_calc>\n");
			if (intensity_meas != null) ow.write(indent + " <PDBx:intensity_meas>" + intensity_meas + "</PDBx:intensity_meas>\n");
			if (intensity_sigma != null) ow.write(indent + " <PDBx:intensity_sigma>" + intensity_sigma + "</PDBx:intensity_sigma>\n");
			if (mean_path_length_tbar != null) ow.write(indent + " <PDBx:mean_path_length_tbar>" + mean_path_length_tbar + "</PDBx:mean_path_length_tbar>\n");
			if (pdbx_F_calc_part_solvent != null) ow.write(indent + " <PDBx:pdbx_F_calc_part_solvent>" + pdbx_F_calc_part_solvent + "</PDBx:pdbx_F_calc_part_solvent>\n");
			if (pdbx_F_calc_with_solvent != null) ow.write(indent + " <PDBx:pdbx_F_calc_with_solvent>" + pdbx_F_calc_with_solvent + "</PDBx:pdbx_F_calc_with_solvent>\n");
			if (pdbx_F_minus != null) ow.write(indent + " <PDBx:pdbx_F_minus>" + pdbx_F_minus + "</PDBx:pdbx_F_minus>\n");
			if (pdbx_F_minus_sigma != null) ow.write(indent + " <PDBx:pdbx_F_minus_sigma>" + pdbx_F_minus_sigma + "</PDBx:pdbx_F_minus_sigma>\n");
			if (pdbx_F_plus != null) ow.write(indent + " <PDBx:pdbx_F_plus>" + pdbx_F_plus + "</PDBx:pdbx_F_plus>\n");
			if (pdbx_F_plus_sigma != null) ow.write(indent + " <PDBx:pdbx_F_plus_sigma>" + pdbx_F_plus_sigma + "</PDBx:pdbx_F_plus_sigma>\n");
			if (pdbx_HL_A_iso != null) ow.write(indent + " <PDBx:pdbx_HL_A_iso>" + pdbx_HL_A_iso + "</PDBx:pdbx_HL_A_iso>\n");
			if (pdbx_HL_B_iso != null) ow.write(indent + " <PDBx:pdbx_HL_B_iso>" + pdbx_HL_B_iso + "</PDBx:pdbx_HL_B_iso>\n");
			if (pdbx_HL_C_iso != null) ow.write(indent + " <PDBx:pdbx_HL_C_iso>" + pdbx_HL_C_iso + "</PDBx:pdbx_HL_C_iso>\n");
			if (pdbx_HL_D_iso != null) ow.write(indent + " <PDBx:pdbx_HL_D_iso>" + pdbx_HL_D_iso + "</PDBx:pdbx_HL_D_iso>\n");
			if (pdbx_I_minus != null) ow.write(indent + " <PDBx:pdbx_I_minus>" + pdbx_I_minus + "</PDBx:pdbx_I_minus>\n");
			if (pdbx_I_minus_sigma != null) ow.write(indent + " <PDBx:pdbx_I_minus_sigma>" + pdbx_I_minus_sigma + "</PDBx:pdbx_I_minus_sigma>\n");
			if (pdbx_I_plus != null) ow.write(indent + " <PDBx:pdbx_I_plus>" + pdbx_I_plus + "</PDBx:pdbx_I_plus>\n");
			if (pdbx_I_plus_sigma != null) ow.write(indent + " <PDBx:pdbx_I_plus_sigma>" + pdbx_I_plus_sigma + "</PDBx:pdbx_I_plus_sigma>\n");
			if (pdbx_anom_difference != null) ow.write(indent + " <PDBx:pdbx_anom_difference>" + pdbx_anom_difference + "</PDBx:pdbx_anom_difference>\n");
			if (pdbx_anom_difference_sigma != null) ow.write(indent + " <PDBx:pdbx_anom_difference_sigma>" + pdbx_anom_difference_sigma + "</PDBx:pdbx_anom_difference_sigma>\n");
			if (pdbx_phase_calc_part_solvent != null) ow.write(indent + " <PDBx:pdbx_phase_calc_part_solvent>" + pdbx_phase_calc_part_solvent + "</PDBx:pdbx_phase_calc_part_solvent>\n");
			if (pdbx_phase_calc_with_solvent != null) ow.write(indent + " <PDBx:pdbx_phase_calc_with_solvent>" + pdbx_phase_calc_with_solvent + "</PDBx:pdbx_phase_calc_with_solvent>\n");
			if (phase_calc != null) ow.write(indent + " <PDBx:phase_calc>" + phase_calc + "</PDBx:phase_calc>\n");
			if (phase_meas != null) ow.write(indent + " <PDBx:phase_meas>" + phase_meas + "</PDBx:phase_meas>\n");
			if (refinement_status != null) ow.write(indent + " <PDBx:refinement_status>" + refinement_status + "</PDBx:refinement_status>\n");
			if (scale_group_code != null) ow.write(indent + " <PDBx:scale_group_code>" + scale_group_code + "</PDBx:scale_group_code>\n");
			if (sint_over_lambda != null) ow.write(indent + " <PDBx:sint_over_lambda>" + sint_over_lambda + "</PDBx:sint_over_lambda>\n");
			if (status != null) ow.write(indent + " <PDBx:status>" + status + "</PDBx:status>\n");
			if (symmetry_epsilon != null) ow.write(indent + " <PDBx:symmetry_epsilon>" + symmetry_epsilon + "</PDBx:symmetry_epsilon>\n");
			if (symmetry_multiplicity != null) ow.write(indent + " <PDBx:symmetry_multiplicity>" + symmetry_multiplicity + "</PDBx:symmetry_multiplicity>\n");
			if (wavelength != null) ow.write(indent + " <PDBx:wavelength>" + wavelength + "</PDBx:wavelength>\n");
			if (wavelength_id != null) ow.write(indent + " <PDBx:wavelength_id>" + wavelength_id + "</PDBx:wavelength_id>\n");
			ow.write(indent + "</PDBx:refln>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
