package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLN_SYS_ABS category record details about
 *  the reflection data that should be systematically absent,
 *  given the designated space group.
 *  
 * <pre>
 *  Example 1 - hypothetical example.
 *  <PDBx:refln_sys_absCategory>
 *  <PDBx:refln_sys_abs index_h="0" index_k="3" index_l="0">
 *  <PDBx:I>28.32</PDBx:I>
 *  <PDBx:sigmaI>22.95</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>1.23</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="5" index_l="0">
 *  <PDBx:I>14.11</PDBx:I>
 *  <PDBx:sigmaI>16.38</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>0.86</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="7" index_l="0">
 *  <PDBx:I>114.81</PDBx:I>
 *  <PDBx:sigmaI>20.22</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>5.67</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  <PDBx:refln_sys_abs index_h="0" index_k="9" index_l="0">
 *  <PDBx:I>32.99</PDBx:I>
 *  <PDBx:sigmaI>24.51</PDBx:sigmaI>
 *  <PDBx:I_over_sigmaI>1.35</PDBx:I_over_sigmaI>
 *  </PDBx:refln_sys_abs>
 *  </PDBx:refln_sys_absCategory>
 * </pre>
 */
public class Refln_sys_abs extends org.pdb.beans.Refln_sys_abs implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "refln_sys_abs";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Refln_sys_abs()
	{
	}

	/** Full constructor */
	public Refln_sys_abs(
		Datablock datablock,
		java.lang.Float I,
		java.lang.Float I_over_sigmaI,
		java.lang.Integer index_h,
		java.lang.Integer index_k,
		java.lang.Integer index_l,
		java.lang.Float sigmaI)
	{
		this.datablock = datablock;
		this.I = I;
		this.I_over_sigmaI = I_over_sigmaI;
		this.index_h = index_h;
		this.index_k = index_k;
		this.index_l = index_l;
		this.sigmaI = sigmaI;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Refln_sys_abs");
		sb.append("\n");
		if (I != null)
		{
			sb.append("I = ");
			sb.append(I);
			sb.append('\n');
		}
		if (I_over_sigmaI != null)
		{
			sb.append("I_over_sigmaI = ");
			sb.append(I_over_sigmaI);
			sb.append('\n');
		}
		if (index_h != null)
		{
			sb.append("index_h = ");
			sb.append(index_h);
			sb.append('\n');
		}
		if (index_k != null)
		{
			sb.append("index_k = ");
			sb.append(index_k);
			sb.append('\n');
		}
		if (index_l != null)
		{
			sb.append("index_l = ");
			sb.append(index_l);
			sb.append('\n');
		}
		if (sigmaI != null)
		{
			sb.append("sigmaI = ");
			sb.append(sigmaI);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		I = null;
		I_over_sigmaI = null;
		index_h = null;
		index_k = null;
		index_l = null;
		sigmaI = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Refln_sys_abs)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:refln_sys_abs>\n");
			if (I != null) ow.write(indent + " <PDBx:I>" + I + "</PDBx:I>\n");
			if (I_over_sigmaI != null) ow.write(indent + " <PDBx:I_over_sigmaI>" + I_over_sigmaI + "</PDBx:I_over_sigmaI>\n");
			if (index_h != null) ow.write(indent + " <PDBx:index_h>" + index_h + "</PDBx:index_h>\n");
			if (index_k != null) ow.write(indent + " <PDBx:index_k>" + index_k + "</PDBx:index_k>\n");
			if (index_l != null) ow.write(indent + " <PDBx:index_l>" + index_l + "</PDBx:index_l>\n");
			if (sigmaI != null) ow.write(indent + " <PDBx:sigmaI>" + sigmaI + "</PDBx:sigmaI>\n");
			ow.write(indent + "</PDBx:refln_sys_abs>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
