package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLNS category record details about the
 *  reflection data used to determine the ATOM_SITE data items.
 *  
 *  The REFLN data items refer to individual reflections and must
 *  be included in looped lists.
 *  
 *  The REFLNS data items specify the parameters that apply to all
 *  reflections. The REFLNS data items are not looped.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:reflnsCategory>
 *  <PDBx:reflns entry_id="5HVP">
 *  <PDBx:data_reduction_method> Xengen program scalei. Anomalous pairs were merged. Scaling
 *  proceeded in several passes, beginning with 1-parameter
 *  fit and ending with 3-parameter fit.</PDBx:data_reduction_method>
 *  <PDBx:data_reduction_details> Merging and scaling based on only those reflections
 *  with I &gt; \s(I).</PDBx:data_reduction_details>
 *  <PDBx:d_resolution_high>2.00</PDBx:d_resolution_high>
 *  <PDBx:d_resolution_low>8.00</PDBx:d_resolution_low>
 *  <PDBx:limit_h_max>22</PDBx:limit_h_max>
 *  <PDBx:limit_h_min>0</PDBx:limit_h_min>
 *  <PDBx:limit_k_max>46</PDBx:limit_k_max>
 *  <PDBx:limit_k_min>0</PDBx:limit_k_min>
 *  <PDBx:limit_l_max>57</PDBx:limit_l_max>
 *  <PDBx:limit_l_min>0</PDBx:limit_l_min>
 *  <PDBx:number_obs>7228</PDBx:number_obs>
 *  <PDBx:observed_criterion>&gt; 1 \s(I)</PDBx:observed_criterion>
 *  <PDBx:details>none</PDBx:details>
 *  </PDBx:reflns>
 *  </PDBx:reflnsCategory>
 *  
 *  
 *  Example 2 - based on data set TOZ of Willis, Beckwith & Tozer
 *  [Acta Cryst. (1991), C47, 2276-2277].
 *  <PDBx:reflnsCategory>
 *  <PDBx:reflns>
 *  <PDBx:limit_h_min>0</PDBx:limit_h_min>
 *  <PDBx:limit_h_max>6</PDBx:limit_h_max>
 *  <PDBx:limit_k_min>0</PDBx:limit_k_min>
 *  <PDBx:limit_k_max>17</PDBx:limit_k_max>
 *  <PDBx:limit_l_min>0</PDBx:limit_l_min>
 *  <PDBx:limit_l_max>22</PDBx:limit_l_max>
 *  <PDBx:number_all>1592</PDBx:number_all>
 *  <PDBx:number_obs>1408</PDBx:number_obs>
 *  <PDBx:observed_criterion>F_&gt;_6.0_\s(F)</PDBx:observed_criterion>
 *  <PDBx:d_resolution_high>0.8733</PDBx:d_resolution_high>
 *  <PDBx:d_resolution_low>11.9202</PDBx:d_resolution_low>
 *  </PDBx:reflns>
 *  </PDBx:reflnsCategory>
 * </pre>
 */
public class Reflns extends org.pdb.beans.Reflns implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "reflns";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Reflns()
	{
	}

	/** Full constructor */
	public Reflns(
		Datablock datablock,
		java.lang.Float B_iso_Wilson_estimate,
		java.lang.Float Friedel_coverage,
		java.lang.String R_free_details,
		java.lang.Float Rmerge_F_all,
		java.lang.Float Rmerge_F_obs,
		java.lang.Float d_resolution_high,
		java.lang.Float d_resolution_low,
		java.lang.String data_reduction_details,
		java.lang.String data_reduction_method,
		java.lang.String details,
		java.lang.String entry_id,
		java.lang.Integer limit_h_max,
		java.lang.Integer limit_h_min,
		java.lang.Integer limit_k_max,
		java.lang.Integer limit_k_min,
		java.lang.Integer limit_l_max,
		java.lang.Integer limit_l_min,
		java.lang.Integer number_all,
		java.lang.Integer number_gt,
		java.lang.Integer number_obs,
		java.lang.String observed_criterion,
		java.lang.Float observed_criterion_F_max,
		java.lang.Float observed_criterion_F_min,
		java.lang.Float observed_criterion_I_max,
		java.lang.Float observed_criterion_I_min,
		java.lang.Float observed_criterion_sigma_F,
		java.lang.Float observed_criterion_sigma_I,
		java.lang.Float pdbx_Rmerge_I_all,
		java.lang.Float pdbx_Rmerge_I_obs,
		java.lang.Float pdbx_Rsym_value,
		java.lang.Float pdbx_chi_squared,
		java.lang.Float pdbx_d_res_high_opt,
		java.lang.Float pdbx_d_res_low_opt,
		java.lang.String pdbx_d_res_opt_method,
		java.lang.Float pdbx_netI_over_av_sigmaI,
		java.lang.Float pdbx_netI_over_sigmaI,
		java.lang.Float pdbx_redundancy,
		java.lang.Float pdbx_res_netI_over_av_sigmaI_2,
		java.lang.Float pdbx_res_netI_over_sigmaI_2,
		java.lang.Integer pdbx_scaling_rejects,
		java.lang.Float percent_possible_obs,
		java.lang.String threshold_expression)
	{
		this.datablock = datablock;
		this.B_iso_Wilson_estimate = B_iso_Wilson_estimate;
		this.Friedel_coverage = Friedel_coverage;
		this.R_free_details = R_free_details;
		this.Rmerge_F_all = Rmerge_F_all;
		this.Rmerge_F_obs = Rmerge_F_obs;
		this.d_resolution_high = d_resolution_high;
		this.d_resolution_low = d_resolution_low;
		this.data_reduction_details = data_reduction_details;
		this.data_reduction_method = data_reduction_method;
		this.details = details;
		this.entry_id = entry_id;
		this.limit_h_max = limit_h_max;
		this.limit_h_min = limit_h_min;
		this.limit_k_max = limit_k_max;
		this.limit_k_min = limit_k_min;
		this.limit_l_max = limit_l_max;
		this.limit_l_min = limit_l_min;
		this.number_all = number_all;
		this.number_gt = number_gt;
		this.number_obs = number_obs;
		this.observed_criterion = observed_criterion;
		this.observed_criterion_F_max = observed_criterion_F_max;
		this.observed_criterion_F_min = observed_criterion_F_min;
		this.observed_criterion_I_max = observed_criterion_I_max;
		this.observed_criterion_I_min = observed_criterion_I_min;
		this.observed_criterion_sigma_F = observed_criterion_sigma_F;
		this.observed_criterion_sigma_I = observed_criterion_sigma_I;
		this.pdbx_Rmerge_I_all = pdbx_Rmerge_I_all;
		this.pdbx_Rmerge_I_obs = pdbx_Rmerge_I_obs;
		this.pdbx_Rsym_value = pdbx_Rsym_value;
		this.pdbx_chi_squared = pdbx_chi_squared;
		this.pdbx_d_res_high_opt = pdbx_d_res_high_opt;
		this.pdbx_d_res_low_opt = pdbx_d_res_low_opt;
		this.pdbx_d_res_opt_method = pdbx_d_res_opt_method;
		this.pdbx_netI_over_av_sigmaI = pdbx_netI_over_av_sigmaI;
		this.pdbx_netI_over_sigmaI = pdbx_netI_over_sigmaI;
		this.pdbx_redundancy = pdbx_redundancy;
		this.pdbx_res_netI_over_av_sigmaI_2 = pdbx_res_netI_over_av_sigmaI_2;
		this.pdbx_res_netI_over_sigmaI_2 = pdbx_res_netI_over_sigmaI_2;
		this.pdbx_scaling_rejects = pdbx_scaling_rejects;
		this.percent_possible_obs = percent_possible_obs;
		this.threshold_expression = threshold_expression;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Reflns");
		sb.append("\n");
		if (B_iso_Wilson_estimate != null)
		{
			sb.append("B_iso_Wilson_estimate = ");
			sb.append(B_iso_Wilson_estimate);
			sb.append('\n');
		}
		if (Friedel_coverage != null)
		{
			sb.append("Friedel_coverage = ");
			sb.append(Friedel_coverage);
			sb.append('\n');
		}
		if (R_free_details != null)
		{
			sb.append("R_free_details = ");
			sb.append(R_free_details);
			sb.append('\n');
		}
		if (Rmerge_F_all != null)
		{
			sb.append("Rmerge_F_all = ");
			sb.append(Rmerge_F_all);
			sb.append('\n');
		}
		if (Rmerge_F_obs != null)
		{
			sb.append("Rmerge_F_obs = ");
			sb.append(Rmerge_F_obs);
			sb.append('\n');
		}
		if (d_resolution_high != null)
		{
			sb.append("d_resolution_high = ");
			sb.append(d_resolution_high);
			sb.append('\n');
		}
		if (d_resolution_low != null)
		{
			sb.append("d_resolution_low = ");
			sb.append(d_resolution_low);
			sb.append('\n');
		}
		if (data_reduction_details != null)
		{
			sb.append("data_reduction_details = ");
			sb.append(data_reduction_details);
			sb.append('\n');
		}
		if (data_reduction_method != null)
		{
			sb.append("data_reduction_method = ");
			sb.append(data_reduction_method);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (limit_h_max != null)
		{
			sb.append("limit_h_max = ");
			sb.append(limit_h_max);
			sb.append('\n');
		}
		if (limit_h_min != null)
		{
			sb.append("limit_h_min = ");
			sb.append(limit_h_min);
			sb.append('\n');
		}
		if (limit_k_max != null)
		{
			sb.append("limit_k_max = ");
			sb.append(limit_k_max);
			sb.append('\n');
		}
		if (limit_k_min != null)
		{
			sb.append("limit_k_min = ");
			sb.append(limit_k_min);
			sb.append('\n');
		}
		if (limit_l_max != null)
		{
			sb.append("limit_l_max = ");
			sb.append(limit_l_max);
			sb.append('\n');
		}
		if (limit_l_min != null)
		{
			sb.append("limit_l_min = ");
			sb.append(limit_l_min);
			sb.append('\n');
		}
		if (number_all != null)
		{
			sb.append("number_all = ");
			sb.append(number_all);
			sb.append('\n');
		}
		if (number_gt != null)
		{
			sb.append("number_gt = ");
			sb.append(number_gt);
			sb.append('\n');
		}
		if (number_obs != null)
		{
			sb.append("number_obs = ");
			sb.append(number_obs);
			sb.append('\n');
		}
		if (observed_criterion != null)
		{
			sb.append("observed_criterion = ");
			sb.append(observed_criterion);
			sb.append('\n');
		}
		if (observed_criterion_F_max != null)
		{
			sb.append("observed_criterion_F_max = ");
			sb.append(observed_criterion_F_max);
			sb.append('\n');
		}
		if (observed_criterion_F_min != null)
		{
			sb.append("observed_criterion_F_min = ");
			sb.append(observed_criterion_F_min);
			sb.append('\n');
		}
		if (observed_criterion_I_max != null)
		{
			sb.append("observed_criterion_I_max = ");
			sb.append(observed_criterion_I_max);
			sb.append('\n');
		}
		if (observed_criterion_I_min != null)
		{
			sb.append("observed_criterion_I_min = ");
			sb.append(observed_criterion_I_min);
			sb.append('\n');
		}
		if (observed_criterion_sigma_F != null)
		{
			sb.append("observed_criterion_sigma_F = ");
			sb.append(observed_criterion_sigma_F);
			sb.append('\n');
		}
		if (observed_criterion_sigma_I != null)
		{
			sb.append("observed_criterion_sigma_I = ");
			sb.append(observed_criterion_sigma_I);
			sb.append('\n');
		}
		if (pdbx_Rmerge_I_all != null)
		{
			sb.append("pdbx_Rmerge_I_all = ");
			sb.append(pdbx_Rmerge_I_all);
			sb.append('\n');
		}
		if (pdbx_Rmerge_I_obs != null)
		{
			sb.append("pdbx_Rmerge_I_obs = ");
			sb.append(pdbx_Rmerge_I_obs);
			sb.append('\n');
		}
		if (pdbx_Rsym_value != null)
		{
			sb.append("pdbx_Rsym_value = ");
			sb.append(pdbx_Rsym_value);
			sb.append('\n');
		}
		if (pdbx_chi_squared != null)
		{
			sb.append("pdbx_chi_squared = ");
			sb.append(pdbx_chi_squared);
			sb.append('\n');
		}
		if (pdbx_d_res_high_opt != null)
		{
			sb.append("pdbx_d_res_high_opt = ");
			sb.append(pdbx_d_res_high_opt);
			sb.append('\n');
		}
		if (pdbx_d_res_low_opt != null)
		{
			sb.append("pdbx_d_res_low_opt = ");
			sb.append(pdbx_d_res_low_opt);
			sb.append('\n');
		}
		if (pdbx_d_res_opt_method != null)
		{
			sb.append("pdbx_d_res_opt_method = ");
			sb.append(pdbx_d_res_opt_method);
			sb.append('\n');
		}
		if (pdbx_netI_over_av_sigmaI != null)
		{
			sb.append("pdbx_netI_over_av_sigmaI = ");
			sb.append(pdbx_netI_over_av_sigmaI);
			sb.append('\n');
		}
		if (pdbx_netI_over_sigmaI != null)
		{
			sb.append("pdbx_netI_over_sigmaI = ");
			sb.append(pdbx_netI_over_sigmaI);
			sb.append('\n');
		}
		if (pdbx_redundancy != null)
		{
			sb.append("pdbx_redundancy = ");
			sb.append(pdbx_redundancy);
			sb.append('\n');
		}
		if (pdbx_res_netI_over_av_sigmaI_2 != null)
		{
			sb.append("pdbx_res_netI_over_av_sigmaI_2 = ");
			sb.append(pdbx_res_netI_over_av_sigmaI_2);
			sb.append('\n');
		}
		if (pdbx_res_netI_over_sigmaI_2 != null)
		{
			sb.append("pdbx_res_netI_over_sigmaI_2 = ");
			sb.append(pdbx_res_netI_over_sigmaI_2);
			sb.append('\n');
		}
		if (pdbx_scaling_rejects != null)
		{
			sb.append("pdbx_scaling_rejects = ");
			sb.append(pdbx_scaling_rejects);
			sb.append('\n');
		}
		if (percent_possible_obs != null)
		{
			sb.append("percent_possible_obs = ");
			sb.append(percent_possible_obs);
			sb.append('\n');
		}
		if (threshold_expression != null)
		{
			sb.append("threshold_expression = ");
			sb.append(threshold_expression);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		B_iso_Wilson_estimate = null;
		Friedel_coverage = null;
		R_free_details = null;
		Rmerge_F_all = null;
		Rmerge_F_obs = null;
		d_resolution_high = null;
		d_resolution_low = null;
		data_reduction_details = null;
		data_reduction_method = null;
		details = null;
		entry_id = null;
		limit_h_max = null;
		limit_h_min = null;
		limit_k_max = null;
		limit_k_min = null;
		limit_l_max = null;
		limit_l_min = null;
		number_all = null;
		number_gt = null;
		number_obs = null;
		observed_criterion = null;
		observed_criterion_F_max = null;
		observed_criterion_F_min = null;
		observed_criterion_I_max = null;
		observed_criterion_I_min = null;
		observed_criterion_sigma_F = null;
		observed_criterion_sigma_I = null;
		pdbx_Rmerge_I_all = null;
		pdbx_Rmerge_I_obs = null;
		pdbx_Rsym_value = null;
		pdbx_chi_squared = null;
		pdbx_d_res_high_opt = null;
		pdbx_d_res_low_opt = null;
		pdbx_d_res_opt_method = null;
		pdbx_netI_over_av_sigmaI = null;
		pdbx_netI_over_sigmaI = null;
		pdbx_redundancy = null;
		pdbx_res_netI_over_av_sigmaI_2 = null;
		pdbx_res_netI_over_sigmaI_2 = null;
		pdbx_scaling_rejects = null;
		percent_possible_obs = null;
		threshold_expression = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Reflns)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:reflns>\n");
			if (B_iso_Wilson_estimate != null) ow.write(indent + " <PDBx:B_iso_Wilson_estimate>" + B_iso_Wilson_estimate + "</PDBx:B_iso_Wilson_estimate>\n");
			if (Friedel_coverage != null) ow.write(indent + " <PDBx:Friedel_coverage>" + Friedel_coverage + "</PDBx:Friedel_coverage>\n");
			if (R_free_details != null) ow.write(indent + " <PDBx:R_free_details>" + R_free_details + "</PDBx:R_free_details>\n");
			if (Rmerge_F_all != null) ow.write(indent + " <PDBx:Rmerge_F_all>" + Rmerge_F_all + "</PDBx:Rmerge_F_all>\n");
			if (Rmerge_F_obs != null) ow.write(indent + " <PDBx:Rmerge_F_obs>" + Rmerge_F_obs + "</PDBx:Rmerge_F_obs>\n");
			if (d_resolution_high != null) ow.write(indent + " <PDBx:d_resolution_high>" + d_resolution_high + "</PDBx:d_resolution_high>\n");
			if (d_resolution_low != null) ow.write(indent + " <PDBx:d_resolution_low>" + d_resolution_low + "</PDBx:d_resolution_low>\n");
			if (data_reduction_details != null) ow.write(indent + " <PDBx:data_reduction_details>" + data_reduction_details + "</PDBx:data_reduction_details>\n");
			if (data_reduction_method != null) ow.write(indent + " <PDBx:data_reduction_method>" + data_reduction_method + "</PDBx:data_reduction_method>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (limit_h_max != null) ow.write(indent + " <PDBx:limit_h_max>" + limit_h_max + "</PDBx:limit_h_max>\n");
			if (limit_h_min != null) ow.write(indent + " <PDBx:limit_h_min>" + limit_h_min + "</PDBx:limit_h_min>\n");
			if (limit_k_max != null) ow.write(indent + " <PDBx:limit_k_max>" + limit_k_max + "</PDBx:limit_k_max>\n");
			if (limit_k_min != null) ow.write(indent + " <PDBx:limit_k_min>" + limit_k_min + "</PDBx:limit_k_min>\n");
			if (limit_l_max != null) ow.write(indent + " <PDBx:limit_l_max>" + limit_l_max + "</PDBx:limit_l_max>\n");
			if (limit_l_min != null) ow.write(indent + " <PDBx:limit_l_min>" + limit_l_min + "</PDBx:limit_l_min>\n");
			if (number_all != null) ow.write(indent + " <PDBx:number_all>" + number_all + "</PDBx:number_all>\n");
			if (number_gt != null) ow.write(indent + " <PDBx:number_gt>" + number_gt + "</PDBx:number_gt>\n");
			if (number_obs != null) ow.write(indent + " <PDBx:number_obs>" + number_obs + "</PDBx:number_obs>\n");
			if (observed_criterion != null) ow.write(indent + " <PDBx:observed_criterion>" + observed_criterion + "</PDBx:observed_criterion>\n");
			if (observed_criterion_F_max != null) ow.write(indent + " <PDBx:observed_criterion_F_max>" + observed_criterion_F_max + "</PDBx:observed_criterion_F_max>\n");
			if (observed_criterion_F_min != null) ow.write(indent + " <PDBx:observed_criterion_F_min>" + observed_criterion_F_min + "</PDBx:observed_criterion_F_min>\n");
			if (observed_criterion_I_max != null) ow.write(indent + " <PDBx:observed_criterion_I_max>" + observed_criterion_I_max + "</PDBx:observed_criterion_I_max>\n");
			if (observed_criterion_I_min != null) ow.write(indent + " <PDBx:observed_criterion_I_min>" + observed_criterion_I_min + "</PDBx:observed_criterion_I_min>\n");
			if (observed_criterion_sigma_F != null) ow.write(indent + " <PDBx:observed_criterion_sigma_F>" + observed_criterion_sigma_F + "</PDBx:observed_criterion_sigma_F>\n");
			if (observed_criterion_sigma_I != null) ow.write(indent + " <PDBx:observed_criterion_sigma_I>" + observed_criterion_sigma_I + "</PDBx:observed_criterion_sigma_I>\n");
			if (pdbx_Rmerge_I_all != null) ow.write(indent + " <PDBx:pdbx_Rmerge_I_all>" + pdbx_Rmerge_I_all + "</PDBx:pdbx_Rmerge_I_all>\n");
			if (pdbx_Rmerge_I_obs != null) ow.write(indent + " <PDBx:pdbx_Rmerge_I_obs>" + pdbx_Rmerge_I_obs + "</PDBx:pdbx_Rmerge_I_obs>\n");
			if (pdbx_Rsym_value != null) ow.write(indent + " <PDBx:pdbx_Rsym_value>" + pdbx_Rsym_value + "</PDBx:pdbx_Rsym_value>\n");
			if (pdbx_chi_squared != null) ow.write(indent + " <PDBx:pdbx_chi_squared>" + pdbx_chi_squared + "</PDBx:pdbx_chi_squared>\n");
			if (pdbx_d_res_high_opt != null) ow.write(indent + " <PDBx:pdbx_d_res_high_opt>" + pdbx_d_res_high_opt + "</PDBx:pdbx_d_res_high_opt>\n");
			if (pdbx_d_res_low_opt != null) ow.write(indent + " <PDBx:pdbx_d_res_low_opt>" + pdbx_d_res_low_opt + "</PDBx:pdbx_d_res_low_opt>\n");
			if (pdbx_d_res_opt_method != null) ow.write(indent + " <PDBx:pdbx_d_res_opt_method>" + pdbx_d_res_opt_method + "</PDBx:pdbx_d_res_opt_method>\n");
			if (pdbx_netI_over_av_sigmaI != null) ow.write(indent + " <PDBx:pdbx_netI_over_av_sigmaI>" + pdbx_netI_over_av_sigmaI + "</PDBx:pdbx_netI_over_av_sigmaI>\n");
			if (pdbx_netI_over_sigmaI != null) ow.write(indent + " <PDBx:pdbx_netI_over_sigmaI>" + pdbx_netI_over_sigmaI + "</PDBx:pdbx_netI_over_sigmaI>\n");
			if (pdbx_redundancy != null) ow.write(indent + " <PDBx:pdbx_redundancy>" + pdbx_redundancy + "</PDBx:pdbx_redundancy>\n");
			if (pdbx_res_netI_over_av_sigmaI_2 != null) ow.write(indent + " <PDBx:pdbx_res_netI_over_av_sigmaI_2>" + pdbx_res_netI_over_av_sigmaI_2 + "</PDBx:pdbx_res_netI_over_av_sigmaI_2>\n");
			if (pdbx_res_netI_over_sigmaI_2 != null) ow.write(indent + " <PDBx:pdbx_res_netI_over_sigmaI_2>" + pdbx_res_netI_over_sigmaI_2 + "</PDBx:pdbx_res_netI_over_sigmaI_2>\n");
			if (pdbx_scaling_rejects != null) ow.write(indent + " <PDBx:pdbx_scaling_rejects>" + pdbx_scaling_rejects + "</PDBx:pdbx_scaling_rejects>\n");
			if (percent_possible_obs != null) ow.write(indent + " <PDBx:percent_possible_obs>" + percent_possible_obs + "</PDBx:percent_possible_obs>\n");
			if (threshold_expression != null) ow.write(indent + " <PDBx:threshold_expression>" + threshold_expression + "</PDBx:threshold_expression>\n");
			ow.write(indent + "</PDBx:reflns>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
