package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLNS_CLASS category record details
 *  of the reflections used to determine the structural
 *  parameters for each reflection class.
 *  
 * <pre>
 *  Example 1 - example corresponding to the one-dimensional incommensurately
 *  modulated structure of K~2~SeO~4~.
 *  <PDBx:reflns_classCategory>
 *  <PDBx:reflns_class code="Main">
 *  <PDBx:number_gt>584</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  <PDBx:reflns_class code="Sat1">
 *  <PDBx:number_gt>226</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  <PDBx:reflns_class code="Sat2">
 *  <PDBx:number_gt>50</PDBx:number_gt>
 *  </PDBx:reflns_class>
 *  </PDBx:reflns_classCategory>
 * </pre>
 */
public class Reflns_class extends org.pdb.beans.Reflns_class implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "reflns_class";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Reflns_class()
	{
	}

	/** Full constructor */
	public Reflns_class(
		Datablock datablock,
		java.lang.Float R_Fsqd_factor,
		java.lang.Float R_I_factor,
		java.lang.Float R_factor_all,
		java.lang.Float R_factor_gt,
		java.lang.String code,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.String description,
		java.lang.Integer number_gt,
		java.lang.Integer number_total,
		java.lang.Float wR_factor_all)
	{
		this.datablock = datablock;
		this.R_Fsqd_factor = R_Fsqd_factor;
		this.R_I_factor = R_I_factor;
		this.R_factor_all = R_factor_all;
		this.R_factor_gt = R_factor_gt;
		this.code = code;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.description = description;
		this.number_gt = number_gt;
		this.number_total = number_total;
		this.wR_factor_all = wR_factor_all;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Reflns_class");
		sb.append("\n");
		if (R_Fsqd_factor != null)
		{
			sb.append("R_Fsqd_factor = ");
			sb.append(R_Fsqd_factor);
			sb.append('\n');
		}
		if (R_I_factor != null)
		{
			sb.append("R_I_factor = ");
			sb.append(R_I_factor);
			sb.append('\n');
		}
		if (R_factor_all != null)
		{
			sb.append("R_factor_all = ");
			sb.append(R_factor_all);
			sb.append('\n');
		}
		if (R_factor_gt != null)
		{
			sb.append("R_factor_gt = ");
			sb.append(R_factor_gt);
			sb.append('\n');
		}
		if (code != null)
		{
			sb.append("code = ");
			sb.append(code);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (description != null)
		{
			sb.append("description = ");
			sb.append(description);
			sb.append('\n');
		}
		if (number_gt != null)
		{
			sb.append("number_gt = ");
			sb.append(number_gt);
			sb.append('\n');
		}
		if (number_total != null)
		{
			sb.append("number_total = ");
			sb.append(number_total);
			sb.append('\n');
		}
		if (wR_factor_all != null)
		{
			sb.append("wR_factor_all = ");
			sb.append(wR_factor_all);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		R_Fsqd_factor = null;
		R_I_factor = null;
		R_factor_all = null;
		R_factor_gt = null;
		code = null;
		d_res_high = null;
		d_res_low = null;
		description = null;
		number_gt = null;
		number_total = null;
		wR_factor_all = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Reflns_class)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:reflns_class>\n");
			if (R_Fsqd_factor != null) ow.write(indent + " <PDBx:R_Fsqd_factor>" + R_Fsqd_factor + "</PDBx:R_Fsqd_factor>\n");
			if (R_I_factor != null) ow.write(indent + " <PDBx:R_I_factor>" + R_I_factor + "</PDBx:R_I_factor>\n");
			if (R_factor_all != null) ow.write(indent + " <PDBx:R_factor_all>" + R_factor_all + "</PDBx:R_factor_all>\n");
			if (R_factor_gt != null) ow.write(indent + " <PDBx:R_factor_gt>" + R_factor_gt + "</PDBx:R_factor_gt>\n");
			if (code != null) ow.write(indent + " <PDBx:code>" + code + "</PDBx:code>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (description != null) ow.write(indent + " <PDBx:description>" + description + "</PDBx:description>\n");
			if (number_gt != null) ow.write(indent + " <PDBx:number_gt>" + number_gt + "</PDBx:number_gt>\n");
			if (number_total != null) ow.write(indent + " <PDBx:number_total>" + number_total + "</PDBx:number_total>\n");
			if (wR_factor_all != null) ow.write(indent + " <PDBx:wR_factor_all>" + wR_factor_all + "</PDBx:wR_factor_all>\n");
			ow.write(indent + "</PDBx:reflns_class>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
