package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLNS_SCALE category record details about
 *  the structure-factor scales. They are referenced from within
 *  the REFLN list through  attribute scale_group_code in category refln.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide [(POG)4 EKG (POG)5]3.
 *  <PDBx:reflns_scaleCategory>
 *  <PDBx:reflns_scale group_code="SG1">
 *  <PDBx:meas_F>4.0</PDBx:meas_F>
 *  </PDBx:reflns_scale>
 *  </PDBx:reflns_scaleCategory>
 * </pre>
 */
public class Reflns_scale extends org.pdb.beans.Reflns_scale implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "reflns_scale";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Reflns_scale()
	{
	}

	/** Full constructor */
	public Reflns_scale(
		Datablock datablock,
		java.lang.String group_code,
		java.lang.Float meas_F,
		java.lang.Float meas_F_squared,
		java.lang.Float meas_intensity)
	{
		this.datablock = datablock;
		this.group_code = group_code;
		this.meas_F = meas_F;
		this.meas_F_squared = meas_F_squared;
		this.meas_intensity = meas_intensity;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Reflns_scale");
		sb.append("\n");
		if (group_code != null)
		{
			sb.append("group_code = ");
			sb.append(group_code);
			sb.append('\n');
		}
		if (meas_F != null)
		{
			sb.append("meas_F = ");
			sb.append(meas_F);
			sb.append('\n');
		}
		if (meas_F_squared != null)
		{
			sb.append("meas_F_squared = ");
			sb.append(meas_F_squared);
			sb.append('\n');
		}
		if (meas_intensity != null)
		{
			sb.append("meas_intensity = ");
			sb.append(meas_intensity);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		group_code = null;
		meas_F = null;
		meas_F_squared = null;
		meas_intensity = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Reflns_scale)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:reflns_scale>\n");
			if (group_code != null) ow.write(indent + " <PDBx:group_code>" + group_code + "</PDBx:group_code>\n");
			if (meas_F != null) ow.write(indent + " <PDBx:meas_F>" + meas_F + "</PDBx:meas_F>\n");
			if (meas_F_squared != null) ow.write(indent + " <PDBx:meas_F_squared>" + meas_F_squared + "</PDBx:meas_F_squared>\n");
			if (meas_intensity != null) ow.write(indent + " <PDBx:meas_intensity>" + meas_intensity + "</PDBx:meas_intensity>\n");
			ow.write(indent + "</PDBx:reflns_scale>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
