package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the REFLNS_SHELL category record details about
 *  the reflection data used to determine the ATOM_SITE data items
 *  broken down into shells of resolution.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:reflns_shellCategory>
 *  <PDBx:reflns_shell d_res_high="31.38" d_res_low="3.82">
 *  <PDBx:meanI_over_sigI_obs>69.8</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>9024</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2540</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>96.8</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>1.98</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="3.82" d_res_low="3.03">
 *  <PDBx:meanI_over_sigI_obs>26.1</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>7413</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2364</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>95.1</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>3.85</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="3.03" d_res_low="2.65">
 *  <PDBx:meanI_over_sigI_obs>10.5</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>5640</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>2123</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>86.2</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>6.37</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.65" d_res_low="2.41">
 *  <PDBx:meanI_over_sigI_obs>6.4</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>4322</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>1882</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>76.8</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>8.01</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.41" d_res_low="2.23">
 *  <PDBx:meanI_over_sigI_obs>4.3</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>3247</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>1714</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>70.4</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>9.86</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  <PDBx:reflns_shell d_res_high="2.23" d_res_low="2.10">
 *  <PDBx:meanI_over_sigI_obs>3.1</PDBx:meanI_over_sigI_obs>
 *  <PDBx:number_measured_obs>1140</PDBx:number_measured_obs>
 *  <PDBx:number_unique_obs>812</PDBx:number_unique_obs>
 *  <PDBx:percent_possible_obs>33.3</PDBx:percent_possible_obs>
 *  <PDBx:Rmerge_F_obs>13.99</PDBx:Rmerge_F_obs>
 *  </PDBx:reflns_shell>
 *  </PDBx:reflns_shellCategory>
 * </pre>
 */
public class Reflns_shell extends org.pdb.beans.Reflns_shell implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "reflns_shell";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Reflns_shell()
	{
	}

	/** Full constructor */
	public Reflns_shell(
		Datablock datablock,
		java.lang.Float Rmerge_F_all,
		java.lang.Float Rmerge_F_gt,
		java.lang.Float Rmerge_F_obs,
		java.lang.Float Rmerge_I_all,
		java.lang.Float Rmerge_I_gt,
		java.lang.Float Rmerge_I_obs,
		java.lang.Float d_res_high,
		java.lang.Float d_res_low,
		java.lang.Float meanI_over_sigI_all,
		java.lang.Float meanI_over_sigI_gt,
		java.lang.Float meanI_over_sigI_obs,
		java.lang.Float meanI_over_uI_all,
		java.lang.Float meanI_over_uI_gt,
		java.lang.Integer number_measured_all,
		java.lang.Integer number_measured_gt,
		java.lang.Integer number_measured_obs,
		java.lang.Integer number_possible,
		java.lang.Integer number_unique_all,
		java.lang.Integer number_unique_gt,
		java.lang.Integer number_unique_obs,
		java.lang.Float pdbx_Rsym_value,
		java.lang.Float pdbx_chi_squared,
		java.lang.Float pdbx_netI_over_sigmaI_all,
		java.lang.Float pdbx_netI_over_sigmaI_obs,
		java.lang.Float pdbx_redundancy,
		java.lang.Float percent_possible_all,
		java.lang.Float percent_possible_gt,
		java.lang.Float percent_possible_obs)
	{
		this.datablock = datablock;
		this.Rmerge_F_all = Rmerge_F_all;
		this.Rmerge_F_gt = Rmerge_F_gt;
		this.Rmerge_F_obs = Rmerge_F_obs;
		this.Rmerge_I_all = Rmerge_I_all;
		this.Rmerge_I_gt = Rmerge_I_gt;
		this.Rmerge_I_obs = Rmerge_I_obs;
		this.d_res_high = d_res_high;
		this.d_res_low = d_res_low;
		this.meanI_over_sigI_all = meanI_over_sigI_all;
		this.meanI_over_sigI_gt = meanI_over_sigI_gt;
		this.meanI_over_sigI_obs = meanI_over_sigI_obs;
		this.meanI_over_uI_all = meanI_over_uI_all;
		this.meanI_over_uI_gt = meanI_over_uI_gt;
		this.number_measured_all = number_measured_all;
		this.number_measured_gt = number_measured_gt;
		this.number_measured_obs = number_measured_obs;
		this.number_possible = number_possible;
		this.number_unique_all = number_unique_all;
		this.number_unique_gt = number_unique_gt;
		this.number_unique_obs = number_unique_obs;
		this.pdbx_Rsym_value = pdbx_Rsym_value;
		this.pdbx_chi_squared = pdbx_chi_squared;
		this.pdbx_netI_over_sigmaI_all = pdbx_netI_over_sigmaI_all;
		this.pdbx_netI_over_sigmaI_obs = pdbx_netI_over_sigmaI_obs;
		this.pdbx_redundancy = pdbx_redundancy;
		this.percent_possible_all = percent_possible_all;
		this.percent_possible_gt = percent_possible_gt;
		this.percent_possible_obs = percent_possible_obs;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Reflns_shell");
		sb.append("\n");
		if (Rmerge_F_all != null)
		{
			sb.append("Rmerge_F_all = ");
			sb.append(Rmerge_F_all);
			sb.append('\n');
		}
		if (Rmerge_F_gt != null)
		{
			sb.append("Rmerge_F_gt = ");
			sb.append(Rmerge_F_gt);
			sb.append('\n');
		}
		if (Rmerge_F_obs != null)
		{
			sb.append("Rmerge_F_obs = ");
			sb.append(Rmerge_F_obs);
			sb.append('\n');
		}
		if (Rmerge_I_all != null)
		{
			sb.append("Rmerge_I_all = ");
			sb.append(Rmerge_I_all);
			sb.append('\n');
		}
		if (Rmerge_I_gt != null)
		{
			sb.append("Rmerge_I_gt = ");
			sb.append(Rmerge_I_gt);
			sb.append('\n');
		}
		if (Rmerge_I_obs != null)
		{
			sb.append("Rmerge_I_obs = ");
			sb.append(Rmerge_I_obs);
			sb.append('\n');
		}
		if (d_res_high != null)
		{
			sb.append("d_res_high = ");
			sb.append(d_res_high);
			sb.append('\n');
		}
		if (d_res_low != null)
		{
			sb.append("d_res_low = ");
			sb.append(d_res_low);
			sb.append('\n');
		}
		if (meanI_over_sigI_all != null)
		{
			sb.append("meanI_over_sigI_all = ");
			sb.append(meanI_over_sigI_all);
			sb.append('\n');
		}
		if (meanI_over_sigI_gt != null)
		{
			sb.append("meanI_over_sigI_gt = ");
			sb.append(meanI_over_sigI_gt);
			sb.append('\n');
		}
		if (meanI_over_sigI_obs != null)
		{
			sb.append("meanI_over_sigI_obs = ");
			sb.append(meanI_over_sigI_obs);
			sb.append('\n');
		}
		if (meanI_over_uI_all != null)
		{
			sb.append("meanI_over_uI_all = ");
			sb.append(meanI_over_uI_all);
			sb.append('\n');
		}
		if (meanI_over_uI_gt != null)
		{
			sb.append("meanI_over_uI_gt = ");
			sb.append(meanI_over_uI_gt);
			sb.append('\n');
		}
		if (number_measured_all != null)
		{
			sb.append("number_measured_all = ");
			sb.append(number_measured_all);
			sb.append('\n');
		}
		if (number_measured_gt != null)
		{
			sb.append("number_measured_gt = ");
			sb.append(number_measured_gt);
			sb.append('\n');
		}
		if (number_measured_obs != null)
		{
			sb.append("number_measured_obs = ");
			sb.append(number_measured_obs);
			sb.append('\n');
		}
		if (number_possible != null)
		{
			sb.append("number_possible = ");
			sb.append(number_possible);
			sb.append('\n');
		}
		if (number_unique_all != null)
		{
			sb.append("number_unique_all = ");
			sb.append(number_unique_all);
			sb.append('\n');
		}
		if (number_unique_gt != null)
		{
			sb.append("number_unique_gt = ");
			sb.append(number_unique_gt);
			sb.append('\n');
		}
		if (number_unique_obs != null)
		{
			sb.append("number_unique_obs = ");
			sb.append(number_unique_obs);
			sb.append('\n');
		}
		if (pdbx_Rsym_value != null)
		{
			sb.append("pdbx_Rsym_value = ");
			sb.append(pdbx_Rsym_value);
			sb.append('\n');
		}
		if (pdbx_chi_squared != null)
		{
			sb.append("pdbx_chi_squared = ");
			sb.append(pdbx_chi_squared);
			sb.append('\n');
		}
		if (pdbx_netI_over_sigmaI_all != null)
		{
			sb.append("pdbx_netI_over_sigmaI_all = ");
			sb.append(pdbx_netI_over_sigmaI_all);
			sb.append('\n');
		}
		if (pdbx_netI_over_sigmaI_obs != null)
		{
			sb.append("pdbx_netI_over_sigmaI_obs = ");
			sb.append(pdbx_netI_over_sigmaI_obs);
			sb.append('\n');
		}
		if (pdbx_redundancy != null)
		{
			sb.append("pdbx_redundancy = ");
			sb.append(pdbx_redundancy);
			sb.append('\n');
		}
		if (percent_possible_all != null)
		{
			sb.append("percent_possible_all = ");
			sb.append(percent_possible_all);
			sb.append('\n');
		}
		if (percent_possible_gt != null)
		{
			sb.append("percent_possible_gt = ");
			sb.append(percent_possible_gt);
			sb.append('\n');
		}
		if (percent_possible_obs != null)
		{
			sb.append("percent_possible_obs = ");
			sb.append(percent_possible_obs);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Rmerge_F_all = null;
		Rmerge_F_gt = null;
		Rmerge_F_obs = null;
		Rmerge_I_all = null;
		Rmerge_I_gt = null;
		Rmerge_I_obs = null;
		d_res_high = null;
		d_res_low = null;
		meanI_over_sigI_all = null;
		meanI_over_sigI_gt = null;
		meanI_over_sigI_obs = null;
		meanI_over_uI_all = null;
		meanI_over_uI_gt = null;
		number_measured_all = null;
		number_measured_gt = null;
		number_measured_obs = null;
		number_possible = null;
		number_unique_all = null;
		number_unique_gt = null;
		number_unique_obs = null;
		pdbx_Rsym_value = null;
		pdbx_chi_squared = null;
		pdbx_netI_over_sigmaI_all = null;
		pdbx_netI_over_sigmaI_obs = null;
		pdbx_redundancy = null;
		percent_possible_all = null;
		percent_possible_gt = null;
		percent_possible_obs = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Reflns_shell)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:reflns_shell>\n");
			if (Rmerge_F_all != null) ow.write(indent + " <PDBx:Rmerge_F_all>" + Rmerge_F_all + "</PDBx:Rmerge_F_all>\n");
			if (Rmerge_F_gt != null) ow.write(indent + " <PDBx:Rmerge_F_gt>" + Rmerge_F_gt + "</PDBx:Rmerge_F_gt>\n");
			if (Rmerge_F_obs != null) ow.write(indent + " <PDBx:Rmerge_F_obs>" + Rmerge_F_obs + "</PDBx:Rmerge_F_obs>\n");
			if (Rmerge_I_all != null) ow.write(indent + " <PDBx:Rmerge_I_all>" + Rmerge_I_all + "</PDBx:Rmerge_I_all>\n");
			if (Rmerge_I_gt != null) ow.write(indent + " <PDBx:Rmerge_I_gt>" + Rmerge_I_gt + "</PDBx:Rmerge_I_gt>\n");
			if (Rmerge_I_obs != null) ow.write(indent + " <PDBx:Rmerge_I_obs>" + Rmerge_I_obs + "</PDBx:Rmerge_I_obs>\n");
			if (d_res_high != null) ow.write(indent + " <PDBx:d_res_high>" + d_res_high + "</PDBx:d_res_high>\n");
			if (d_res_low != null) ow.write(indent + " <PDBx:d_res_low>" + d_res_low + "</PDBx:d_res_low>\n");
			if (meanI_over_sigI_all != null) ow.write(indent + " <PDBx:meanI_over_sigI_all>" + meanI_over_sigI_all + "</PDBx:meanI_over_sigI_all>\n");
			if (meanI_over_sigI_gt != null) ow.write(indent + " <PDBx:meanI_over_sigI_gt>" + meanI_over_sigI_gt + "</PDBx:meanI_over_sigI_gt>\n");
			if (meanI_over_sigI_obs != null) ow.write(indent + " <PDBx:meanI_over_sigI_obs>" + meanI_over_sigI_obs + "</PDBx:meanI_over_sigI_obs>\n");
			if (meanI_over_uI_all != null) ow.write(indent + " <PDBx:meanI_over_uI_all>" + meanI_over_uI_all + "</PDBx:meanI_over_uI_all>\n");
			if (meanI_over_uI_gt != null) ow.write(indent + " <PDBx:meanI_over_uI_gt>" + meanI_over_uI_gt + "</PDBx:meanI_over_uI_gt>\n");
			if (number_measured_all != null) ow.write(indent + " <PDBx:number_measured_all>" + number_measured_all + "</PDBx:number_measured_all>\n");
			if (number_measured_gt != null) ow.write(indent + " <PDBx:number_measured_gt>" + number_measured_gt + "</PDBx:number_measured_gt>\n");
			if (number_measured_obs != null) ow.write(indent + " <PDBx:number_measured_obs>" + number_measured_obs + "</PDBx:number_measured_obs>\n");
			if (number_possible != null) ow.write(indent + " <PDBx:number_possible>" + number_possible + "</PDBx:number_possible>\n");
			if (number_unique_all != null) ow.write(indent + " <PDBx:number_unique_all>" + number_unique_all + "</PDBx:number_unique_all>\n");
			if (number_unique_gt != null) ow.write(indent + " <PDBx:number_unique_gt>" + number_unique_gt + "</PDBx:number_unique_gt>\n");
			if (number_unique_obs != null) ow.write(indent + " <PDBx:number_unique_obs>" + number_unique_obs + "</PDBx:number_unique_obs>\n");
			if (pdbx_Rsym_value != null) ow.write(indent + " <PDBx:pdbx_Rsym_value>" + pdbx_Rsym_value + "</PDBx:pdbx_Rsym_value>\n");
			if (pdbx_chi_squared != null) ow.write(indent + " <PDBx:pdbx_chi_squared>" + pdbx_chi_squared + "</PDBx:pdbx_chi_squared>\n");
			if (pdbx_netI_over_sigmaI_all != null) ow.write(indent + " <PDBx:pdbx_netI_over_sigmaI_all>" + pdbx_netI_over_sigmaI_all + "</PDBx:pdbx_netI_over_sigmaI_all>\n");
			if (pdbx_netI_over_sigmaI_obs != null) ow.write(indent + " <PDBx:pdbx_netI_over_sigmaI_obs>" + pdbx_netI_over_sigmaI_obs + "</PDBx:pdbx_netI_over_sigmaI_obs>\n");
			if (pdbx_redundancy != null) ow.write(indent + " <PDBx:pdbx_redundancy>" + pdbx_redundancy + "</PDBx:pdbx_redundancy>\n");
			if (percent_possible_all != null) ow.write(indent + " <PDBx:percent_possible_all>" + percent_possible_all + "</PDBx:percent_possible_all>\n");
			if (percent_possible_gt != null) ow.write(indent + " <PDBx:percent_possible_gt>" + percent_possible_gt + "</PDBx:percent_possible_gt>\n");
			if (percent_possible_obs != null) ow.write(indent + " <PDBx:percent_possible_obs>" + percent_possible_obs + "</PDBx:percent_possible_obs>\n");
			ow.write(indent + "</PDBx:reflns_shell>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
