package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT category record details about the
 *  description of the crystallographic structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:structCategory>
 *  <PDBx:struct entry_id="5HVP">
 *  <PDBx:title> HIV-1 protease complex with acetyl-pepstatin</PDBx:title>
 *  </PDBx:struct>
 *  </PDBx:structCategory>
 * </pre>
 */
public class Struct extends org.pdb.beans.Struct implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct()
	{
	}

	/** Full constructor */
	public Struct(
		Datablock datablock,
		java.lang.String entry_id,
		java.lang.String pdbx_descriptor,
		java.lang.Float pdbx_formula_weight,
		java.lang.String pdbx_formula_weight_method,
		java.lang.String pdbx_model_details,
		java.lang.String title)
	{
		this.datablock = datablock;
		this.entry_id = entry_id;
		this.pdbx_descriptor = pdbx_descriptor;
		this.pdbx_formula_weight = pdbx_formula_weight;
		this.pdbx_formula_weight_method = pdbx_formula_weight_method;
		this.pdbx_model_details = pdbx_model_details;
		this.title = title;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct");
		sb.append("\n");
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (pdbx_descriptor != null)
		{
			sb.append("pdbx_descriptor = ");
			sb.append(pdbx_descriptor);
			sb.append('\n');
		}
		if (pdbx_formula_weight != null)
		{
			sb.append("pdbx_formula_weight = ");
			sb.append(pdbx_formula_weight);
			sb.append('\n');
		}
		if (pdbx_formula_weight_method != null)
		{
			sb.append("pdbx_formula_weight_method = ");
			sb.append(pdbx_formula_weight_method);
			sb.append('\n');
		}
		if (pdbx_model_details != null)
		{
			sb.append("pdbx_model_details = ");
			sb.append(pdbx_model_details);
			sb.append('\n');
		}
		if (title != null)
		{
			sb.append("title = ");
			sb.append(title);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		entry_id = null;
		pdbx_descriptor = null;
		pdbx_formula_weight = null;
		pdbx_formula_weight_method = null;
		pdbx_model_details = null;
		title = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (pdbx_descriptor != null) ow.write(indent + " <PDBx:pdbx_descriptor>" + pdbx_descriptor + "</PDBx:pdbx_descriptor>\n");
			if (pdbx_formula_weight != null) ow.write(indent + " <PDBx:pdbx_formula_weight>" + pdbx_formula_weight + "</PDBx:pdbx_formula_weight>\n");
			if (pdbx_formula_weight_method != null) ow.write(indent + " <PDBx:pdbx_formula_weight_method>" + pdbx_formula_weight_method + "</PDBx:pdbx_formula_weight_method>\n");
			if (pdbx_model_details != null) ow.write(indent + " <PDBx:pdbx_model_details>" + pdbx_model_details + "</PDBx:pdbx_model_details>\n");
			if (title != null) ow.write(indent + " <PDBx:title>" + title + "</PDBx:title>\n");
			ow.write(indent + "</PDBx:struct>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
