package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_ASYM category record details about the
 *  structural elements in the asymmetric unit.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_asymCategory>
 *  <PDBx:struct_asym id="A">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="B">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:details>one monomer of the dimeric enzyme</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="C">
 *  <PDBx:entity_id>2</PDBx:entity_id>
 *  <PDBx:details>one partially occupied position for the inhibitor</PDBx:details>
 *  </PDBx:struct_asym>
 *  <PDBx:struct_asym id="D">
 *  <PDBx:entity_id>2</PDBx:entity_id>
 *  <PDBx:details>one partially occupied position for the inhibitor</PDBx:details>
 *  </PDBx:struct_asym>
 *  </PDBx:struct_asymCategory>
 * </pre>
 */
public class Struct_asym extends org.pdb.beans.Struct_asym implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_asym";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_asym()
	{
	}

	/** Full constructor */
	public Struct_asym(
		Datablock datablock,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String id_,
		java.lang.String pdbx_blank_PDB_chainid_flag,
		java.lang.String pdbx_modified)
	{
		this.datablock = datablock;
		this.details = details;
		this.entity_id = entity_id;
		this.id_ = id_;
		this.pdbx_blank_PDB_chainid_flag = pdbx_blank_PDB_chainid_flag;
		this.pdbx_modified = pdbx_modified;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_asym");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_blank_PDB_chainid_flag != null)
		{
			sb.append("pdbx_blank_PDB_chainid_flag = ");
			sb.append(pdbx_blank_PDB_chainid_flag);
			sb.append('\n');
		}
		if (pdbx_modified != null)
		{
			sb.append("pdbx_modified = ");
			sb.append(pdbx_modified);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		entity_id = null;
		id_ = null;
		pdbx_blank_PDB_chainid_flag = null;
		pdbx_modified = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_asym)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_asym>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_blank_PDB_chainid_flag != null) ow.write(indent + " <PDBx:pdbx_blank_PDB_chainid_flag>" + pdbx_blank_PDB_chainid_flag + "</PDBx:pdbx_blank_PDB_chainid_flag>\n");
			if (pdbx_modified != null) ow.write(indent + " <PDBx:pdbx_modified>" + pdbx_modified + "</PDBx:pdbx_modified>\n");
			ow.write(indent + "</PDBx:struct_asym>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
