package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_BIOL_GEN category record details about
 *  the generation of each biological unit. The STRUCT_BIOL_GEN
 *  data items provide the specifications of the components that
 *  constitute that biological unit, which may include symmetry
 *  elements.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_biol_genCategory>
 *  <PDBx:struct_biol_gen biol_id="1" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="1" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="2" asym_id="C" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="A" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="B" symmetry="1_555"></PDBx:struct_biol_gen>
 *  <PDBx:struct_biol_gen biol_id="3" asym_id="D" symmetry="1_555"></PDBx:struct_biol_gen>
 *  </PDBx:struct_biol_genCategory>
 * </pre>
 */
public class Struct_biol_gen extends org.pdb.beans.Struct_biol_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_biol_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_biol_gen()
	{
	}

	/** Full constructor */
	public Struct_biol_gen(
		Datablock datablock,
		java.lang.String asym_id,
		java.lang.String biol_id,
		java.lang.String details,
		java.lang.Integer pdbx_PDB_order,
		java.lang.String pdbx_full_symmetry_operation,
		java.lang.String symmetry)
	{
		this.datablock = datablock;
		this.asym_id = asym_id;
		this.biol_id = biol_id;
		this.details = details;
		this.pdbx_PDB_order = pdbx_PDB_order;
		this.pdbx_full_symmetry_operation = pdbx_full_symmetry_operation;
		this.symmetry = symmetry;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_biol_gen");
		sb.append("\n");
		if (asym_id != null)
		{
			sb.append("asym_id = ");
			sb.append(asym_id);
			sb.append('\n');
		}
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (pdbx_PDB_order != null)
		{
			sb.append("pdbx_PDB_order = ");
			sb.append(pdbx_PDB_order);
			sb.append('\n');
		}
		if (pdbx_full_symmetry_operation != null)
		{
			sb.append("pdbx_full_symmetry_operation = ");
			sb.append(pdbx_full_symmetry_operation);
			sb.append('\n');
		}
		if (symmetry != null)
		{
			sb.append("symmetry = ");
			sb.append(symmetry);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		asym_id = null;
		biol_id = null;
		details = null;
		pdbx_PDB_order = null;
		pdbx_full_symmetry_operation = null;
		symmetry = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_biol_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_biol_gen>\n");
			if (asym_id != null) ow.write(indent + " <PDBx:asym_id>" + asym_id + "</PDBx:asym_id>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (pdbx_PDB_order != null) ow.write(indent + " <PDBx:pdbx_PDB_order>" + pdbx_PDB_order + "</PDBx:pdbx_PDB_order>\n");
			if (pdbx_full_symmetry_operation != null) ow.write(indent + " <PDBx:pdbx_full_symmetry_operation>" + pdbx_full_symmetry_operation + "</PDBx:pdbx_full_symmetry_operation>\n");
			if (symmetry != null) ow.write(indent + " <PDBx:symmetry>" + symmetry + "</PDBx:symmetry>\n");
			ow.write(indent + "</PDBx:struct_biol_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
