package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_BIOL_VIEW category record details
 *  about how to draw and annotate an informative view of the
 *  biological structure.
 *  
 * <pre>
 *  Example 1 - based on NDB structure GDL001 by Coll, Aymami,
 *  Van Der Marel, Van Boom, Rich & Wang
 *  [Biochemistry, (1989), 28, 310-320].
 *  <PDBx:struct_biol_viewCategory>
 *  <PDBx:struct_biol_view biol_id="c1" id="1">
 *  <PDBx:rot_matrix11>0.132</PDBx:rot_matrix11>
 *  <PDBx:rot_matrix12>0.922</PDBx:rot_matrix12>
 *  <PDBx:rot_matrix13>-0.363</PDBx:rot_matrix13>
 *  <PDBx:rot_matrix21>0.131</PDBx:rot_matrix21>
 *  <PDBx:rot_matrix22>-0.380</PDBx:rot_matrix22>
 *  <PDBx:rot_matrix23>-0.916</PDBx:rot_matrix23>
 *  <PDBx:rot_matrix31>-0.982</PDBx:rot_matrix31>
 *  <PDBx:rot_matrix32>0.073</PDBx:rot_matrix32>
 *  <PDBx:rot_matrix33>-0.172</PDBx:rot_matrix33>
 *  <PDBx:details> This view highlights the ATAT-Netropsin interaction in the
 *  DNA-drug complex.</PDBx:details>
 *  </PDBx:struct_biol_view>
 *  </PDBx:struct_biol_viewCategory>
 * </pre>
 */
public class Struct_biol_view extends org.pdb.beans.Struct_biol_view implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_biol_view";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_biol_view()
	{
	}

	/** Full constructor */
	public Struct_biol_view(
		Datablock datablock,
		java.lang.String biol_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.Float rot_matrix11,
		java.lang.Float rot_matrix12,
		java.lang.Float rot_matrix13,
		java.lang.Float rot_matrix21,
		java.lang.Float rot_matrix22,
		java.lang.Float rot_matrix23,
		java.lang.Float rot_matrix31,
		java.lang.Float rot_matrix32,
		java.lang.Float rot_matrix33)
	{
		this.datablock = datablock;
		this.biol_id = biol_id;
		this.details = details;
		this.id_ = id_;
		this.rot_matrix11 = rot_matrix11;
		this.rot_matrix12 = rot_matrix12;
		this.rot_matrix13 = rot_matrix13;
		this.rot_matrix21 = rot_matrix21;
		this.rot_matrix22 = rot_matrix22;
		this.rot_matrix23 = rot_matrix23;
		this.rot_matrix31 = rot_matrix31;
		this.rot_matrix32 = rot_matrix32;
		this.rot_matrix33 = rot_matrix33;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_biol_view");
		sb.append("\n");
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (rot_matrix11 != null)
		{
			sb.append("rot_matrix11 = ");
			sb.append(rot_matrix11);
			sb.append('\n');
		}
		if (rot_matrix12 != null)
		{
			sb.append("rot_matrix12 = ");
			sb.append(rot_matrix12);
			sb.append('\n');
		}
		if (rot_matrix13 != null)
		{
			sb.append("rot_matrix13 = ");
			sb.append(rot_matrix13);
			sb.append('\n');
		}
		if (rot_matrix21 != null)
		{
			sb.append("rot_matrix21 = ");
			sb.append(rot_matrix21);
			sb.append('\n');
		}
		if (rot_matrix22 != null)
		{
			sb.append("rot_matrix22 = ");
			sb.append(rot_matrix22);
			sb.append('\n');
		}
		if (rot_matrix23 != null)
		{
			sb.append("rot_matrix23 = ");
			sb.append(rot_matrix23);
			sb.append('\n');
		}
		if (rot_matrix31 != null)
		{
			sb.append("rot_matrix31 = ");
			sb.append(rot_matrix31);
			sb.append('\n');
		}
		if (rot_matrix32 != null)
		{
			sb.append("rot_matrix32 = ");
			sb.append(rot_matrix32);
			sb.append('\n');
		}
		if (rot_matrix33 != null)
		{
			sb.append("rot_matrix33 = ");
			sb.append(rot_matrix33);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		biol_id = null;
		details = null;
		id_ = null;
		rot_matrix11 = null;
		rot_matrix12 = null;
		rot_matrix13 = null;
		rot_matrix21 = null;
		rot_matrix22 = null;
		rot_matrix23 = null;
		rot_matrix31 = null;
		rot_matrix32 = null;
		rot_matrix33 = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_biol_view)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_biol_view>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (rot_matrix11 != null) ow.write(indent + " <PDBx:rot_matrix11>" + rot_matrix11 + "</PDBx:rot_matrix11>\n");
			if (rot_matrix12 != null) ow.write(indent + " <PDBx:rot_matrix12>" + rot_matrix12 + "</PDBx:rot_matrix12>\n");
			if (rot_matrix13 != null) ow.write(indent + " <PDBx:rot_matrix13>" + rot_matrix13 + "</PDBx:rot_matrix13>\n");
			if (rot_matrix21 != null) ow.write(indent + " <PDBx:rot_matrix21>" + rot_matrix21 + "</PDBx:rot_matrix21>\n");
			if (rot_matrix22 != null) ow.write(indent + " <PDBx:rot_matrix22>" + rot_matrix22 + "</PDBx:rot_matrix22>\n");
			if (rot_matrix23 != null) ow.write(indent + " <PDBx:rot_matrix23>" + rot_matrix23 + "</PDBx:rot_matrix23>\n");
			if (rot_matrix31 != null) ow.write(indent + " <PDBx:rot_matrix31>" + rot_matrix31 + "</PDBx:rot_matrix31>\n");
			if (rot_matrix32 != null) ow.write(indent + " <PDBx:rot_matrix32>" + rot_matrix32 + "</PDBx:rot_matrix32>\n");
			if (rot_matrix33 != null) ow.write(indent + " <PDBx:rot_matrix33>" + rot_matrix33 + "</PDBx:rot_matrix33>\n");
			ow.write(indent + "</PDBx:struct_biol_view>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
