package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_CONN category record details about
 *  the connections between portions of the structure. These can be
 *  hydrogen bonds, salt bridges, disulfide bridges and so on.
 *  
 *  The STRUCT_CONN_TYPE records define the criteria used to
 *  identify these connections.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_connCategory>
 *  <PDBx:struct_conn id="C1">
 *  <PDBx:conn_type_id>saltbr</PDBx:conn_type_id>
 *  <PDBx:ptnr1_label_comp_id>ARG</PDBx:ptnr1_label_comp_id>
 *  <PDBx:ptnr1_label_asym_id>A</PDBx:ptnr1_label_asym_id>
 *  <PDBx:ptnr1_label_seq_id>87</PDBx:ptnr1_label_seq_id>
 *  <PDBx:ptnr1_label_atom_id>NZ1</PDBx:ptnr1_label_atom_id>
 *  <PDBx:ptnr1_role>positive</PDBx:ptnr1_role>
 *  <PDBx:ptnr1_symmetry>1_555</PDBx:ptnr1_symmetry>
 *  <PDBx:ptnr2_label_comp_id>GLU</PDBx:ptnr2_label_comp_id>
 *  <PDBx:ptnr2_label_asym_id>A</PDBx:ptnr2_label_asym_id>
 *  <PDBx:ptnr2_label_seq_id>92</PDBx:ptnr2_label_seq_id>
 *  <PDBx:ptnr2_label_atom_id>OE1</PDBx:ptnr2_label_atom_id>
 *  <PDBx:ptnr2_role>negative</PDBx:ptnr2_role>
 *  <PDBx:ptnr2_symmetry>1_555</PDBx:ptnr2_symmetry>
 *  </PDBx:struct_conn>
 *  <PDBx:struct_conn id="C2">
 *  <PDBx:conn_type_id>hydrog</PDBx:conn_type_id>
 *  <PDBx:ptnr1_label_comp_id>ARG</PDBx:ptnr1_label_comp_id>
 *  <PDBx:ptnr1_label_asym_id>B</PDBx:ptnr1_label_asym_id>
 *  <PDBx:ptnr1_label_seq_id>287</PDBx:ptnr1_label_seq_id>
 *  <PDBx:ptnr1_label_atom_id>N</PDBx:ptnr1_label_atom_id>
 *  <PDBx:ptnr1_role>donor</PDBx:ptnr1_role>
 *  <PDBx:ptnr1_symmetry>1_555</PDBx:ptnr1_symmetry>
 *  <PDBx:ptnr2_label_comp_id>GLY</PDBx:ptnr2_label_comp_id>
 *  <PDBx:ptnr2_label_asym_id>B</PDBx:ptnr2_label_asym_id>
 *  <PDBx:ptnr2_label_seq_id>292</PDBx:ptnr2_label_seq_id>
 *  <PDBx:ptnr2_label_atom_id>O</PDBx:ptnr2_label_atom_id>
 *  <PDBx:ptnr2_role>acceptor</PDBx:ptnr2_role>
 *  <PDBx:ptnr2_symmetry>1_555</PDBx:ptnr2_symmetry>
 *  </PDBx:struct_conn>
 *  </PDBx:struct_connCategory>
 * </pre>
 */
public class Struct_conn extends org.pdb.beans.Struct_conn implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_conn";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_conn()
	{
	}

	/** Full constructor */
	public Struct_conn(
		Datablock datablock,
		java.lang.String conn_type_id,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String pdbx_PDB_id,
		java.lang.Float pdbx_dist_value,
		java.lang.String pdbx_ptnr1_PDB_ins_code,
		java.lang.String pdbx_ptnr1_auth_alt_id,
		java.lang.String pdbx_ptnr1_label_alt_id,
		java.lang.String pdbx_ptnr1_standard_comp_id,
		java.lang.String pdbx_ptnr2_PDB_ins_code,
		java.lang.String pdbx_ptnr2_auth_alt_id,
		java.lang.String pdbx_ptnr2_label_alt_id,
		java.lang.String pdbx_ptnr3_PDB_ins_code,
		java.lang.String pdbx_ptnr3_auth_alt_id,
		java.lang.String pdbx_ptnr3_auth_asym_id,
		java.lang.String pdbx_ptnr3_auth_atom_id,
		java.lang.String pdbx_ptnr3_auth_comp_id,
		java.lang.String pdbx_ptnr3_auth_seq_id,
		java.lang.String pdbx_ptnr3_label_alt_id,
		java.lang.String pdbx_ptnr3_label_asym_id,
		java.lang.String pdbx_ptnr3_label_atom_id,
		java.lang.String pdbx_ptnr3_label_comp_id,
		java.lang.Integer pdbx_ptnr3_label_seq_id,
		java.lang.String ptnr1_auth_asym_id,
		java.lang.String ptnr1_auth_atom_id,
		java.lang.String ptnr1_auth_comp_id,
		java.lang.String ptnr1_auth_seq_id,
		java.lang.String ptnr1_label_alt_id,
		java.lang.String ptnr1_label_asym_id,
		java.lang.String ptnr1_label_atom_id,
		java.lang.String ptnr1_label_comp_id,
		java.lang.Integer ptnr1_label_seq_id,
		java.lang.String ptnr1_role,
		java.lang.String ptnr1_symmetry,
		java.lang.String ptnr2_auth_asym_id,
		java.lang.String ptnr2_auth_atom_id,
		java.lang.String ptnr2_auth_comp_id,
		java.lang.String ptnr2_auth_seq_id,
		java.lang.String ptnr2_label_alt_id,
		java.lang.String ptnr2_label_asym_id,
		java.lang.String ptnr2_label_atom_id,
		java.lang.String ptnr2_label_comp_id,
		java.lang.Integer ptnr2_label_seq_id,
		java.lang.String ptnr2_role,
		java.lang.String ptnr2_symmetry)
	{
		this.datablock = datablock;
		this.conn_type_id = conn_type_id;
		this.details = details;
		this.id_ = id_;
		this.pdbx_PDB_id = pdbx_PDB_id;
		this.pdbx_dist_value = pdbx_dist_value;
		this.pdbx_ptnr1_PDB_ins_code = pdbx_ptnr1_PDB_ins_code;
		this.pdbx_ptnr1_auth_alt_id = pdbx_ptnr1_auth_alt_id;
		this.pdbx_ptnr1_label_alt_id = pdbx_ptnr1_label_alt_id;
		this.pdbx_ptnr1_standard_comp_id = pdbx_ptnr1_standard_comp_id;
		this.pdbx_ptnr2_PDB_ins_code = pdbx_ptnr2_PDB_ins_code;
		this.pdbx_ptnr2_auth_alt_id = pdbx_ptnr2_auth_alt_id;
		this.pdbx_ptnr2_label_alt_id = pdbx_ptnr2_label_alt_id;
		this.pdbx_ptnr3_PDB_ins_code = pdbx_ptnr3_PDB_ins_code;
		this.pdbx_ptnr3_auth_alt_id = pdbx_ptnr3_auth_alt_id;
		this.pdbx_ptnr3_auth_asym_id = pdbx_ptnr3_auth_asym_id;
		this.pdbx_ptnr3_auth_atom_id = pdbx_ptnr3_auth_atom_id;
		this.pdbx_ptnr3_auth_comp_id = pdbx_ptnr3_auth_comp_id;
		this.pdbx_ptnr3_auth_seq_id = pdbx_ptnr3_auth_seq_id;
		this.pdbx_ptnr3_label_alt_id = pdbx_ptnr3_label_alt_id;
		this.pdbx_ptnr3_label_asym_id = pdbx_ptnr3_label_asym_id;
		this.pdbx_ptnr3_label_atom_id = pdbx_ptnr3_label_atom_id;
		this.pdbx_ptnr3_label_comp_id = pdbx_ptnr3_label_comp_id;
		this.pdbx_ptnr3_label_seq_id = pdbx_ptnr3_label_seq_id;
		this.ptnr1_auth_asym_id = ptnr1_auth_asym_id;
		this.ptnr1_auth_atom_id = ptnr1_auth_atom_id;
		this.ptnr1_auth_comp_id = ptnr1_auth_comp_id;
		this.ptnr1_auth_seq_id = ptnr1_auth_seq_id;
		this.ptnr1_label_alt_id = ptnr1_label_alt_id;
		this.ptnr1_label_asym_id = ptnr1_label_asym_id;
		this.ptnr1_label_atom_id = ptnr1_label_atom_id;
		this.ptnr1_label_comp_id = ptnr1_label_comp_id;
		this.ptnr1_label_seq_id = ptnr1_label_seq_id;
		this.ptnr1_role = ptnr1_role;
		this.ptnr1_symmetry = ptnr1_symmetry;
		this.ptnr2_auth_asym_id = ptnr2_auth_asym_id;
		this.ptnr2_auth_atom_id = ptnr2_auth_atom_id;
		this.ptnr2_auth_comp_id = ptnr2_auth_comp_id;
		this.ptnr2_auth_seq_id = ptnr2_auth_seq_id;
		this.ptnr2_label_alt_id = ptnr2_label_alt_id;
		this.ptnr2_label_asym_id = ptnr2_label_asym_id;
		this.ptnr2_label_atom_id = ptnr2_label_atom_id;
		this.ptnr2_label_comp_id = ptnr2_label_comp_id;
		this.ptnr2_label_seq_id = ptnr2_label_seq_id;
		this.ptnr2_role = ptnr2_role;
		this.ptnr2_symmetry = ptnr2_symmetry;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_conn");
		sb.append("\n");
		if (conn_type_id != null)
		{
			sb.append("conn_type_id = ");
			sb.append(conn_type_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_PDB_id != null)
		{
			sb.append("pdbx_PDB_id = ");
			sb.append(pdbx_PDB_id);
			sb.append('\n');
		}
		if (pdbx_dist_value != null)
		{
			sb.append("pdbx_dist_value = ");
			sb.append(pdbx_dist_value);
			sb.append('\n');
		}
		if (pdbx_ptnr1_PDB_ins_code != null)
		{
			sb.append("pdbx_ptnr1_PDB_ins_code = ");
			sb.append(pdbx_ptnr1_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_ptnr1_auth_alt_id != null)
		{
			sb.append("pdbx_ptnr1_auth_alt_id = ");
			sb.append(pdbx_ptnr1_auth_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr1_label_alt_id != null)
		{
			sb.append("pdbx_ptnr1_label_alt_id = ");
			sb.append(pdbx_ptnr1_label_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr1_standard_comp_id != null)
		{
			sb.append("pdbx_ptnr1_standard_comp_id = ");
			sb.append(pdbx_ptnr1_standard_comp_id);
			sb.append('\n');
		}
		if (pdbx_ptnr2_PDB_ins_code != null)
		{
			sb.append("pdbx_ptnr2_PDB_ins_code = ");
			sb.append(pdbx_ptnr2_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_ptnr2_auth_alt_id != null)
		{
			sb.append("pdbx_ptnr2_auth_alt_id = ");
			sb.append(pdbx_ptnr2_auth_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr2_label_alt_id != null)
		{
			sb.append("pdbx_ptnr2_label_alt_id = ");
			sb.append(pdbx_ptnr2_label_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_PDB_ins_code != null)
		{
			sb.append("pdbx_ptnr3_PDB_ins_code = ");
			sb.append(pdbx_ptnr3_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_ptnr3_auth_alt_id != null)
		{
			sb.append("pdbx_ptnr3_auth_alt_id = ");
			sb.append(pdbx_ptnr3_auth_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_auth_asym_id != null)
		{
			sb.append("pdbx_ptnr3_auth_asym_id = ");
			sb.append(pdbx_ptnr3_auth_asym_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_auth_atom_id != null)
		{
			sb.append("pdbx_ptnr3_auth_atom_id = ");
			sb.append(pdbx_ptnr3_auth_atom_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_auth_comp_id != null)
		{
			sb.append("pdbx_ptnr3_auth_comp_id = ");
			sb.append(pdbx_ptnr3_auth_comp_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_auth_seq_id != null)
		{
			sb.append("pdbx_ptnr3_auth_seq_id = ");
			sb.append(pdbx_ptnr3_auth_seq_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_label_alt_id != null)
		{
			sb.append("pdbx_ptnr3_label_alt_id = ");
			sb.append(pdbx_ptnr3_label_alt_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_label_asym_id != null)
		{
			sb.append("pdbx_ptnr3_label_asym_id = ");
			sb.append(pdbx_ptnr3_label_asym_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_label_atom_id != null)
		{
			sb.append("pdbx_ptnr3_label_atom_id = ");
			sb.append(pdbx_ptnr3_label_atom_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_label_comp_id != null)
		{
			sb.append("pdbx_ptnr3_label_comp_id = ");
			sb.append(pdbx_ptnr3_label_comp_id);
			sb.append('\n');
		}
		if (pdbx_ptnr3_label_seq_id != null)
		{
			sb.append("pdbx_ptnr3_label_seq_id = ");
			sb.append(pdbx_ptnr3_label_seq_id);
			sb.append('\n');
		}
		if (ptnr1_auth_asym_id != null)
		{
			sb.append("ptnr1_auth_asym_id = ");
			sb.append(ptnr1_auth_asym_id);
			sb.append('\n');
		}
		if (ptnr1_auth_atom_id != null)
		{
			sb.append("ptnr1_auth_atom_id = ");
			sb.append(ptnr1_auth_atom_id);
			sb.append('\n');
		}
		if (ptnr1_auth_comp_id != null)
		{
			sb.append("ptnr1_auth_comp_id = ");
			sb.append(ptnr1_auth_comp_id);
			sb.append('\n');
		}
		if (ptnr1_auth_seq_id != null)
		{
			sb.append("ptnr1_auth_seq_id = ");
			sb.append(ptnr1_auth_seq_id);
			sb.append('\n');
		}
		if (ptnr1_label_alt_id != null)
		{
			sb.append("ptnr1_label_alt_id = ");
			sb.append(ptnr1_label_alt_id);
			sb.append('\n');
		}
		if (ptnr1_label_asym_id != null)
		{
			sb.append("ptnr1_label_asym_id = ");
			sb.append(ptnr1_label_asym_id);
			sb.append('\n');
		}
		if (ptnr1_label_atom_id != null)
		{
			sb.append("ptnr1_label_atom_id = ");
			sb.append(ptnr1_label_atom_id);
			sb.append('\n');
		}
		if (ptnr1_label_comp_id != null)
		{
			sb.append("ptnr1_label_comp_id = ");
			sb.append(ptnr1_label_comp_id);
			sb.append('\n');
		}
		if (ptnr1_label_seq_id != null)
		{
			sb.append("ptnr1_label_seq_id = ");
			sb.append(ptnr1_label_seq_id);
			sb.append('\n');
		}
		if (ptnr1_role != null)
		{
			sb.append("ptnr1_role = ");
			sb.append(ptnr1_role);
			sb.append('\n');
		}
		if (ptnr1_symmetry != null)
		{
			sb.append("ptnr1_symmetry = ");
			sb.append(ptnr1_symmetry);
			sb.append('\n');
		}
		if (ptnr2_auth_asym_id != null)
		{
			sb.append("ptnr2_auth_asym_id = ");
			sb.append(ptnr2_auth_asym_id);
			sb.append('\n');
		}
		if (ptnr2_auth_atom_id != null)
		{
			sb.append("ptnr2_auth_atom_id = ");
			sb.append(ptnr2_auth_atom_id);
			sb.append('\n');
		}
		if (ptnr2_auth_comp_id != null)
		{
			sb.append("ptnr2_auth_comp_id = ");
			sb.append(ptnr2_auth_comp_id);
			sb.append('\n');
		}
		if (ptnr2_auth_seq_id != null)
		{
			sb.append("ptnr2_auth_seq_id = ");
			sb.append(ptnr2_auth_seq_id);
			sb.append('\n');
		}
		if (ptnr2_label_alt_id != null)
		{
			sb.append("ptnr2_label_alt_id = ");
			sb.append(ptnr2_label_alt_id);
			sb.append('\n');
		}
		if (ptnr2_label_asym_id != null)
		{
			sb.append("ptnr2_label_asym_id = ");
			sb.append(ptnr2_label_asym_id);
			sb.append('\n');
		}
		if (ptnr2_label_atom_id != null)
		{
			sb.append("ptnr2_label_atom_id = ");
			sb.append(ptnr2_label_atom_id);
			sb.append('\n');
		}
		if (ptnr2_label_comp_id != null)
		{
			sb.append("ptnr2_label_comp_id = ");
			sb.append(ptnr2_label_comp_id);
			sb.append('\n');
		}
		if (ptnr2_label_seq_id != null)
		{
			sb.append("ptnr2_label_seq_id = ");
			sb.append(ptnr2_label_seq_id);
			sb.append('\n');
		}
		if (ptnr2_role != null)
		{
			sb.append("ptnr2_role = ");
			sb.append(ptnr2_role);
			sb.append('\n');
		}
		if (ptnr2_symmetry != null)
		{
			sb.append("ptnr2_symmetry = ");
			sb.append(ptnr2_symmetry);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		conn_type_id = null;
		details = null;
		id_ = null;
		pdbx_PDB_id = null;
		pdbx_dist_value = null;
		pdbx_ptnr1_PDB_ins_code = null;
		pdbx_ptnr1_auth_alt_id = null;
		pdbx_ptnr1_label_alt_id = null;
		pdbx_ptnr1_standard_comp_id = null;
		pdbx_ptnr2_PDB_ins_code = null;
		pdbx_ptnr2_auth_alt_id = null;
		pdbx_ptnr2_label_alt_id = null;
		pdbx_ptnr3_PDB_ins_code = null;
		pdbx_ptnr3_auth_alt_id = null;
		pdbx_ptnr3_auth_asym_id = null;
		pdbx_ptnr3_auth_atom_id = null;
		pdbx_ptnr3_auth_comp_id = null;
		pdbx_ptnr3_auth_seq_id = null;
		pdbx_ptnr3_label_alt_id = null;
		pdbx_ptnr3_label_asym_id = null;
		pdbx_ptnr3_label_atom_id = null;
		pdbx_ptnr3_label_comp_id = null;
		pdbx_ptnr3_label_seq_id = null;
		ptnr1_auth_asym_id = null;
		ptnr1_auth_atom_id = null;
		ptnr1_auth_comp_id = null;
		ptnr1_auth_seq_id = null;
		ptnr1_label_alt_id = null;
		ptnr1_label_asym_id = null;
		ptnr1_label_atom_id = null;
		ptnr1_label_comp_id = null;
		ptnr1_label_seq_id = null;
		ptnr1_role = null;
		ptnr1_symmetry = null;
		ptnr2_auth_asym_id = null;
		ptnr2_auth_atom_id = null;
		ptnr2_auth_comp_id = null;
		ptnr2_auth_seq_id = null;
		ptnr2_label_alt_id = null;
		ptnr2_label_asym_id = null;
		ptnr2_label_atom_id = null;
		ptnr2_label_comp_id = null;
		ptnr2_label_seq_id = null;
		ptnr2_role = null;
		ptnr2_symmetry = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_conn)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_conn>\n");
			if (conn_type_id != null) ow.write(indent + " <PDBx:conn_type_id>" + conn_type_id + "</PDBx:conn_type_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_PDB_id != null) ow.write(indent + " <PDBx:pdbx_PDB_id>" + pdbx_PDB_id + "</PDBx:pdbx_PDB_id>\n");
			if (pdbx_dist_value != null) ow.write(indent + " <PDBx:pdbx_dist_value>" + pdbx_dist_value + "</PDBx:pdbx_dist_value>\n");
			if (pdbx_ptnr1_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_ptnr1_PDB_ins_code>" + pdbx_ptnr1_PDB_ins_code + "</PDBx:pdbx_ptnr1_PDB_ins_code>\n");
			if (pdbx_ptnr1_auth_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr1_auth_alt_id>" + pdbx_ptnr1_auth_alt_id + "</PDBx:pdbx_ptnr1_auth_alt_id>\n");
			if (pdbx_ptnr1_label_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr1_label_alt_id>" + pdbx_ptnr1_label_alt_id + "</PDBx:pdbx_ptnr1_label_alt_id>\n");
			if (pdbx_ptnr1_standard_comp_id != null) ow.write(indent + " <PDBx:pdbx_ptnr1_standard_comp_id>" + pdbx_ptnr1_standard_comp_id + "</PDBx:pdbx_ptnr1_standard_comp_id>\n");
			if (pdbx_ptnr2_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_ptnr2_PDB_ins_code>" + pdbx_ptnr2_PDB_ins_code + "</PDBx:pdbx_ptnr2_PDB_ins_code>\n");
			if (pdbx_ptnr2_auth_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr2_auth_alt_id>" + pdbx_ptnr2_auth_alt_id + "</PDBx:pdbx_ptnr2_auth_alt_id>\n");
			if (pdbx_ptnr2_label_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr2_label_alt_id>" + pdbx_ptnr2_label_alt_id + "</PDBx:pdbx_ptnr2_label_alt_id>\n");
			if (pdbx_ptnr3_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_ptnr3_PDB_ins_code>" + pdbx_ptnr3_PDB_ins_code + "</PDBx:pdbx_ptnr3_PDB_ins_code>\n");
			if (pdbx_ptnr3_auth_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_auth_alt_id>" + pdbx_ptnr3_auth_alt_id + "</PDBx:pdbx_ptnr3_auth_alt_id>\n");
			if (pdbx_ptnr3_auth_asym_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_auth_asym_id>" + pdbx_ptnr3_auth_asym_id + "</PDBx:pdbx_ptnr3_auth_asym_id>\n");
			if (pdbx_ptnr3_auth_atom_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_auth_atom_id>" + pdbx_ptnr3_auth_atom_id + "</PDBx:pdbx_ptnr3_auth_atom_id>\n");
			if (pdbx_ptnr3_auth_comp_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_auth_comp_id>" + pdbx_ptnr3_auth_comp_id + "</PDBx:pdbx_ptnr3_auth_comp_id>\n");
			if (pdbx_ptnr3_auth_seq_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_auth_seq_id>" + pdbx_ptnr3_auth_seq_id + "</PDBx:pdbx_ptnr3_auth_seq_id>\n");
			if (pdbx_ptnr3_label_alt_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_label_alt_id>" + pdbx_ptnr3_label_alt_id + "</PDBx:pdbx_ptnr3_label_alt_id>\n");
			if (pdbx_ptnr3_label_asym_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_label_asym_id>" + pdbx_ptnr3_label_asym_id + "</PDBx:pdbx_ptnr3_label_asym_id>\n");
			if (pdbx_ptnr3_label_atom_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_label_atom_id>" + pdbx_ptnr3_label_atom_id + "</PDBx:pdbx_ptnr3_label_atom_id>\n");
			if (pdbx_ptnr3_label_comp_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_label_comp_id>" + pdbx_ptnr3_label_comp_id + "</PDBx:pdbx_ptnr3_label_comp_id>\n");
			if (pdbx_ptnr3_label_seq_id != null) ow.write(indent + " <PDBx:pdbx_ptnr3_label_seq_id>" + pdbx_ptnr3_label_seq_id + "</PDBx:pdbx_ptnr3_label_seq_id>\n");
			if (ptnr1_auth_asym_id != null) ow.write(indent + " <PDBx:ptnr1_auth_asym_id>" + ptnr1_auth_asym_id + "</PDBx:ptnr1_auth_asym_id>\n");
			if (ptnr1_auth_atom_id != null) ow.write(indent + " <PDBx:ptnr1_auth_atom_id>" + ptnr1_auth_atom_id + "</PDBx:ptnr1_auth_atom_id>\n");
			if (ptnr1_auth_comp_id != null) ow.write(indent + " <PDBx:ptnr1_auth_comp_id>" + ptnr1_auth_comp_id + "</PDBx:ptnr1_auth_comp_id>\n");
			if (ptnr1_auth_seq_id != null) ow.write(indent + " <PDBx:ptnr1_auth_seq_id>" + ptnr1_auth_seq_id + "</PDBx:ptnr1_auth_seq_id>\n");
			if (ptnr1_label_alt_id != null) ow.write(indent + " <PDBx:ptnr1_label_alt_id>" + ptnr1_label_alt_id + "</PDBx:ptnr1_label_alt_id>\n");
			if (ptnr1_label_asym_id != null) ow.write(indent + " <PDBx:ptnr1_label_asym_id>" + ptnr1_label_asym_id + "</PDBx:ptnr1_label_asym_id>\n");
			if (ptnr1_label_atom_id != null) ow.write(indent + " <PDBx:ptnr1_label_atom_id>" + ptnr1_label_atom_id + "</PDBx:ptnr1_label_atom_id>\n");
			if (ptnr1_label_comp_id != null) ow.write(indent + " <PDBx:ptnr1_label_comp_id>" + ptnr1_label_comp_id + "</PDBx:ptnr1_label_comp_id>\n");
			if (ptnr1_label_seq_id != null) ow.write(indent + " <PDBx:ptnr1_label_seq_id>" + ptnr1_label_seq_id + "</PDBx:ptnr1_label_seq_id>\n");
			if (ptnr1_role != null) ow.write(indent + " <PDBx:ptnr1_role>" + ptnr1_role + "</PDBx:ptnr1_role>\n");
			if (ptnr1_symmetry != null) ow.write(indent + " <PDBx:ptnr1_symmetry>" + ptnr1_symmetry + "</PDBx:ptnr1_symmetry>\n");
			if (ptnr2_auth_asym_id != null) ow.write(indent + " <PDBx:ptnr2_auth_asym_id>" + ptnr2_auth_asym_id + "</PDBx:ptnr2_auth_asym_id>\n");
			if (ptnr2_auth_atom_id != null) ow.write(indent + " <PDBx:ptnr2_auth_atom_id>" + ptnr2_auth_atom_id + "</PDBx:ptnr2_auth_atom_id>\n");
			if (ptnr2_auth_comp_id != null) ow.write(indent + " <PDBx:ptnr2_auth_comp_id>" + ptnr2_auth_comp_id + "</PDBx:ptnr2_auth_comp_id>\n");
			if (ptnr2_auth_seq_id != null) ow.write(indent + " <PDBx:ptnr2_auth_seq_id>" + ptnr2_auth_seq_id + "</PDBx:ptnr2_auth_seq_id>\n");
			if (ptnr2_label_alt_id != null) ow.write(indent + " <PDBx:ptnr2_label_alt_id>" + ptnr2_label_alt_id + "</PDBx:ptnr2_label_alt_id>\n");
			if (ptnr2_label_asym_id != null) ow.write(indent + " <PDBx:ptnr2_label_asym_id>" + ptnr2_label_asym_id + "</PDBx:ptnr2_label_asym_id>\n");
			if (ptnr2_label_atom_id != null) ow.write(indent + " <PDBx:ptnr2_label_atom_id>" + ptnr2_label_atom_id + "</PDBx:ptnr2_label_atom_id>\n");
			if (ptnr2_label_comp_id != null) ow.write(indent + " <PDBx:ptnr2_label_comp_id>" + ptnr2_label_comp_id + "</PDBx:ptnr2_label_comp_id>\n");
			if (ptnr2_label_seq_id != null) ow.write(indent + " <PDBx:ptnr2_label_seq_id>" + ptnr2_label_seq_id + "</PDBx:ptnr2_label_seq_id>\n");
			if (ptnr2_role != null) ow.write(indent + " <PDBx:ptnr2_role>" + ptnr2_role + "</PDBx:ptnr2_role>\n");
			if (ptnr2_symmetry != null) ow.write(indent + " <PDBx:ptnr2_symmetry>" + ptnr2_symmetry + "</PDBx:ptnr2_symmetry>\n");
			ow.write(indent + "</PDBx:struct_conn>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
