package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_CONN_TYPE category record details
 *  about the criteria used to identify interactions between
 *  portions of the structure.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_conn_typeCategory>
 *  <PDBx:struct_conn_type id="saltbr">
 *  <PDBx:criteria>negative to positive distance &gt; 2.5 \&#37;A, &lt; 3.2 \&#37;A</PDBx:criteria>
 *  </PDBx:struct_conn_type>
 *  <PDBx:struct_conn_type id="hydrog">
 *  <PDBx:criteria>NO distance &gt; 2.5\&#37;A, &lt; 3.5\&#37;A, NOC angle &lt; 120 degrees</PDBx:criteria>
 *  </PDBx:struct_conn_type>
 *  </PDBx:struct_conn_typeCategory>
 * </pre>
 */
public class Struct_conn_type extends org.pdb.beans.Struct_conn_type implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_conn_type";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_conn_type()
	{
	}

	/** Full constructor */
	public Struct_conn_type(
		Datablock datablock,
		java.lang.String criteria,
		java.lang.String id_,
		java.lang.String reference)
	{
		this.datablock = datablock;
		this.criteria = criteria;
		this.id_ = id_;
		this.reference = reference;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_conn_type");
		sb.append("\n");
		if (criteria != null)
		{
			sb.append("criteria = ");
			sb.append(criteria);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (reference != null)
		{
			sb.append("reference = ");
			sb.append(reference);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		criteria = null;
		id_ = null;
		reference = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_conn_type)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_conn_type>\n");
			if (criteria != null) ow.write(indent + " <PDBx:criteria>" + criteria + "</PDBx:criteria>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (reference != null) ow.write(indent + " <PDBx:reference>" + reference + "</PDBx:reference>\n");
			ow.write(indent + "</PDBx:struct_conn_type>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
