package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_MON_DETAILS category record details
 *  about specifics of calculations summarized in data items in the
 *  STRUCT_MON_PROT and STRUCT_MON_NUCL categories. These can
 *  include the coefficients used in map calculations,
 *  the radii used for including points in a calculation and so on.
 */
public class Struct_mon_details extends org.pdb.beans.Struct_mon_details implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_mon_details";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_mon_details()
	{
	}

	/** Full constructor */
	public Struct_mon_details(
		Datablock datablock,
		java.lang.String RSCC,
		java.lang.String RSR,
		java.lang.String entry_id,
		java.lang.Float prot_cis)
	{
		this.datablock = datablock;
		this.RSCC = RSCC;
		this.RSR = RSR;
		this.entry_id = entry_id;
		this.prot_cis = prot_cis;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_mon_details");
		sb.append("\n");
		if (RSCC != null)
		{
			sb.append("RSCC = ");
			sb.append(RSCC);
			sb.append('\n');
		}
		if (RSR != null)
		{
			sb.append("RSR = ");
			sb.append(RSR);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (prot_cis != null)
		{
			sb.append("prot_cis = ");
			sb.append(prot_cis);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		RSCC = null;
		RSR = null;
		entry_id = null;
		prot_cis = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_mon_details)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_mon_details>\n");
			if (RSCC != null) ow.write(indent + " <PDBx:RSCC>" + RSCC + "</PDBx:RSCC>\n");
			if (RSR != null) ow.write(indent + " <PDBx:RSR>" + RSR + "</PDBx:RSR>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (prot_cis != null) ow.write(indent + " <PDBx:prot_cis>" + prot_cis + "</PDBx:prot_cis>\n");
			ow.write(indent + "</PDBx:struct_mon_details>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
