package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_MON_NUCL category record details about
 *  structural properties of a nucleic acid when analyzed at the
 *  monomer level. Analogous data items for proteins are given in
 *  the STRUCT_MON_PROT category. For items where the value of the
 *  property depends on the method employed to calculate it,
 *  details of the method of calculation are given using data items
 *  in the STRUCT_MON_DETAILS category.
 *  
 * <pre>
 *  Example 1 - based on NDB structure BDL028.
 *  <PDBx:struct_mon_nuclCategory>
 *  <PDBx:struct_mon_nucl label_comp_id="C" label_seq_id="1" label_asym_id="A" label_alt_id="">
 *  <PDBx:gamma>29.9</PDBx:gamma>
 *  <PDBx:delta>131.9</PDBx:delta>
 *  <PDBx:epsilon>222.1</PDBx:epsilon>
 *  <PDBx:zeta>174.2</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  <PDBx:struct_mon_nucl label_comp_id="G" label_seq_id="2" label_asym_id="A" label_alt_id="">
 *  <PDBx:alpha>334.0</PDBx:alpha>
 *  <PDBx:beta>130.6</PDBx:beta>
 *  <PDBx:gamma>33.1</PDBx:gamma>
 *  <PDBx:delta>125.6</PDBx:delta>
 *  <PDBx:epsilon>167.6</PDBx:epsilon>
 *  <PDBx:zeta>270.9</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  <PDBx:struct_mon_nucl label_comp_id="T" label_seq_id="3" label_asym_id="A" label_alt_id="">
 *  <PDBx:alpha>258.2</PDBx:alpha>
 *  <PDBx:beta>178.7</PDBx:beta>
 *  <PDBx:gamma>101.0</PDBx:gamma>
 *  <PDBx:delta>114.6</PDBx:delta>
 *  <PDBx:epsilon>216.6</PDBx:epsilon>
 *  <PDBx:zeta>259.3</PDBx:zeta>
 *  </PDBx:struct_mon_nucl>
 *  </PDBx:struct_mon_nuclCategory>
 * </pre>
 */
public class Struct_mon_nucl extends org.pdb.beans.Struct_mon_nucl implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_mon_nucl";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_mon_nucl()
	{
	}

	/** Full constructor */
	public Struct_mon_nucl(
		Datablock datablock,
		java.lang.Float P,
		java.lang.Float RSCC_all,
		java.lang.Float RSCC_base,
		java.lang.Float RSCC_phos,
		java.lang.Float RSCC_sugar,
		java.lang.Float RSR_all,
		java.lang.Float RSR_base,
		java.lang.Float RSR_phos,
		java.lang.Float RSR_sugar,
		java.lang.Float alpha,
		java.lang.String auth_asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.Float beta,
		java.lang.Float chi1,
		java.lang.Float chi2,
		java.lang.Float delta,
		java.lang.Float details,
		java.lang.Float epsilon,
		java.lang.Float gamma,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id,
		java.lang.Float mean_B_all,
		java.lang.Float mean_B_base,
		java.lang.Float mean_B_phos,
		java.lang.Float mean_B_sugar,
		java.lang.Float nu0,
		java.lang.Float nu1,
		java.lang.Float nu2,
		java.lang.Float nu3,
		java.lang.Float nu4,
		java.lang.Float tau0,
		java.lang.Float tau1,
		java.lang.Float tau2,
		java.lang.Float tau3,
		java.lang.Float tau4,
		java.lang.Float taum,
		java.lang.Float zeta)
	{
		this.datablock = datablock;
		this.P = P;
		this.RSCC_all = RSCC_all;
		this.RSCC_base = RSCC_base;
		this.RSCC_phos = RSCC_phos;
		this.RSCC_sugar = RSCC_sugar;
		this.RSR_all = RSR_all;
		this.RSR_base = RSR_base;
		this.RSR_phos = RSR_phos;
		this.RSR_sugar = RSR_sugar;
		this.alpha = alpha;
		this.auth_asym_id = auth_asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.beta = beta;
		this.chi1 = chi1;
		this.chi2 = chi2;
		this.delta = delta;
		this.details = details;
		this.epsilon = epsilon;
		this.gamma = gamma;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
		this.mean_B_all = mean_B_all;
		this.mean_B_base = mean_B_base;
		this.mean_B_phos = mean_B_phos;
		this.mean_B_sugar = mean_B_sugar;
		this.nu0 = nu0;
		this.nu1 = nu1;
		this.nu2 = nu2;
		this.nu3 = nu3;
		this.nu4 = nu4;
		this.tau0 = tau0;
		this.tau1 = tau1;
		this.tau2 = tau2;
		this.tau3 = tau3;
		this.tau4 = tau4;
		this.taum = taum;
		this.zeta = zeta;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_mon_nucl");
		sb.append("\n");
		if (P != null)
		{
			sb.append("P = ");
			sb.append(P);
			sb.append('\n');
		}
		if (RSCC_all != null)
		{
			sb.append("RSCC_all = ");
			sb.append(RSCC_all);
			sb.append('\n');
		}
		if (RSCC_base != null)
		{
			sb.append("RSCC_base = ");
			sb.append(RSCC_base);
			sb.append('\n');
		}
		if (RSCC_phos != null)
		{
			sb.append("RSCC_phos = ");
			sb.append(RSCC_phos);
			sb.append('\n');
		}
		if (RSCC_sugar != null)
		{
			sb.append("RSCC_sugar = ");
			sb.append(RSCC_sugar);
			sb.append('\n');
		}
		if (RSR_all != null)
		{
			sb.append("RSR_all = ");
			sb.append(RSR_all);
			sb.append('\n');
		}
		if (RSR_base != null)
		{
			sb.append("RSR_base = ");
			sb.append(RSR_base);
			sb.append('\n');
		}
		if (RSR_phos != null)
		{
			sb.append("RSR_phos = ");
			sb.append(RSR_phos);
			sb.append('\n');
		}
		if (RSR_sugar != null)
		{
			sb.append("RSR_sugar = ");
			sb.append(RSR_sugar);
			sb.append('\n');
		}
		if (alpha != null)
		{
			sb.append("alpha = ");
			sb.append(alpha);
			sb.append('\n');
		}
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (beta != null)
		{
			sb.append("beta = ");
			sb.append(beta);
			sb.append('\n');
		}
		if (chi1 != null)
		{
			sb.append("chi1 = ");
			sb.append(chi1);
			sb.append('\n');
		}
		if (chi2 != null)
		{
			sb.append("chi2 = ");
			sb.append(chi2);
			sb.append('\n');
		}
		if (delta != null)
		{
			sb.append("delta = ");
			sb.append(delta);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (epsilon != null)
		{
			sb.append("epsilon = ");
			sb.append(epsilon);
			sb.append('\n');
		}
		if (gamma != null)
		{
			sb.append("gamma = ");
			sb.append(gamma);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		if (mean_B_all != null)
		{
			sb.append("mean_B_all = ");
			sb.append(mean_B_all);
			sb.append('\n');
		}
		if (mean_B_base != null)
		{
			sb.append("mean_B_base = ");
			sb.append(mean_B_base);
			sb.append('\n');
		}
		if (mean_B_phos != null)
		{
			sb.append("mean_B_phos = ");
			sb.append(mean_B_phos);
			sb.append('\n');
		}
		if (mean_B_sugar != null)
		{
			sb.append("mean_B_sugar = ");
			sb.append(mean_B_sugar);
			sb.append('\n');
		}
		if (nu0 != null)
		{
			sb.append("nu0 = ");
			sb.append(nu0);
			sb.append('\n');
		}
		if (nu1 != null)
		{
			sb.append("nu1 = ");
			sb.append(nu1);
			sb.append('\n');
		}
		if (nu2 != null)
		{
			sb.append("nu2 = ");
			sb.append(nu2);
			sb.append('\n');
		}
		if (nu3 != null)
		{
			sb.append("nu3 = ");
			sb.append(nu3);
			sb.append('\n');
		}
		if (nu4 != null)
		{
			sb.append("nu4 = ");
			sb.append(nu4);
			sb.append('\n');
		}
		if (tau0 != null)
		{
			sb.append("tau0 = ");
			sb.append(tau0);
			sb.append('\n');
		}
		if (tau1 != null)
		{
			sb.append("tau1 = ");
			sb.append(tau1);
			sb.append('\n');
		}
		if (tau2 != null)
		{
			sb.append("tau2 = ");
			sb.append(tau2);
			sb.append('\n');
		}
		if (tau3 != null)
		{
			sb.append("tau3 = ");
			sb.append(tau3);
			sb.append('\n');
		}
		if (tau4 != null)
		{
			sb.append("tau4 = ");
			sb.append(tau4);
			sb.append('\n');
		}
		if (taum != null)
		{
			sb.append("taum = ");
			sb.append(taum);
			sb.append('\n');
		}
		if (zeta != null)
		{
			sb.append("zeta = ");
			sb.append(zeta);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		P = null;
		RSCC_all = null;
		RSCC_base = null;
		RSCC_phos = null;
		RSCC_sugar = null;
		RSR_all = null;
		RSR_base = null;
		RSR_phos = null;
		RSR_sugar = null;
		alpha = null;
		auth_asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		beta = null;
		chi1 = null;
		chi2 = null;
		delta = null;
		details = null;
		epsilon = null;
		gamma = null;
		label_alt_id = null;
		label_asym_id = null;
		label_comp_id = null;
		label_seq_id = null;
		mean_B_all = null;
		mean_B_base = null;
		mean_B_phos = null;
		mean_B_sugar = null;
		nu0 = null;
		nu1 = null;
		nu2 = null;
		nu3 = null;
		nu4 = null;
		tau0 = null;
		tau1 = null;
		tau2 = null;
		tau3 = null;
		tau4 = null;
		taum = null;
		zeta = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_mon_nucl)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_mon_nucl>\n");
			if (P != null) ow.write(indent + " <PDBx:P>" + P + "</PDBx:P>\n");
			if (RSCC_all != null) ow.write(indent + " <PDBx:RSCC_all>" + RSCC_all + "</PDBx:RSCC_all>\n");
			if (RSCC_base != null) ow.write(indent + " <PDBx:RSCC_base>" + RSCC_base + "</PDBx:RSCC_base>\n");
			if (RSCC_phos != null) ow.write(indent + " <PDBx:RSCC_phos>" + RSCC_phos + "</PDBx:RSCC_phos>\n");
			if (RSCC_sugar != null) ow.write(indent + " <PDBx:RSCC_sugar>" + RSCC_sugar + "</PDBx:RSCC_sugar>\n");
			if (RSR_all != null) ow.write(indent + " <PDBx:RSR_all>" + RSR_all + "</PDBx:RSR_all>\n");
			if (RSR_base != null) ow.write(indent + " <PDBx:RSR_base>" + RSR_base + "</PDBx:RSR_base>\n");
			if (RSR_phos != null) ow.write(indent + " <PDBx:RSR_phos>" + RSR_phos + "</PDBx:RSR_phos>\n");
			if (RSR_sugar != null) ow.write(indent + " <PDBx:RSR_sugar>" + RSR_sugar + "</PDBx:RSR_sugar>\n");
			if (alpha != null) ow.write(indent + " <PDBx:alpha>" + alpha + "</PDBx:alpha>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (beta != null) ow.write(indent + " <PDBx:beta>" + beta + "</PDBx:beta>\n");
			if (chi1 != null) ow.write(indent + " <PDBx:chi1>" + chi1 + "</PDBx:chi1>\n");
			if (chi2 != null) ow.write(indent + " <PDBx:chi2>" + chi2 + "</PDBx:chi2>\n");
			if (delta != null) ow.write(indent + " <PDBx:delta>" + delta + "</PDBx:delta>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (epsilon != null) ow.write(indent + " <PDBx:epsilon>" + epsilon + "</PDBx:epsilon>\n");
			if (gamma != null) ow.write(indent + " <PDBx:gamma>" + gamma + "</PDBx:gamma>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			if (mean_B_all != null) ow.write(indent + " <PDBx:mean_B_all>" + mean_B_all + "</PDBx:mean_B_all>\n");
			if (mean_B_base != null) ow.write(indent + " <PDBx:mean_B_base>" + mean_B_base + "</PDBx:mean_B_base>\n");
			if (mean_B_phos != null) ow.write(indent + " <PDBx:mean_B_phos>" + mean_B_phos + "</PDBx:mean_B_phos>\n");
			if (mean_B_sugar != null) ow.write(indent + " <PDBx:mean_B_sugar>" + mean_B_sugar + "</PDBx:mean_B_sugar>\n");
			if (nu0 != null) ow.write(indent + " <PDBx:nu0>" + nu0 + "</PDBx:nu0>\n");
			if (nu1 != null) ow.write(indent + " <PDBx:nu1>" + nu1 + "</PDBx:nu1>\n");
			if (nu2 != null) ow.write(indent + " <PDBx:nu2>" + nu2 + "</PDBx:nu2>\n");
			if (nu3 != null) ow.write(indent + " <PDBx:nu3>" + nu3 + "</PDBx:nu3>\n");
			if (nu4 != null) ow.write(indent + " <PDBx:nu4>" + nu4 + "</PDBx:nu4>\n");
			if (tau0 != null) ow.write(indent + " <PDBx:tau0>" + tau0 + "</PDBx:tau0>\n");
			if (tau1 != null) ow.write(indent + " <PDBx:tau1>" + tau1 + "</PDBx:tau1>\n");
			if (tau2 != null) ow.write(indent + " <PDBx:tau2>" + tau2 + "</PDBx:tau2>\n");
			if (tau3 != null) ow.write(indent + " <PDBx:tau3>" + tau3 + "</PDBx:tau3>\n");
			if (tau4 != null) ow.write(indent + " <PDBx:tau4>" + tau4 + "</PDBx:tau4>\n");
			if (taum != null) ow.write(indent + " <PDBx:taum>" + taum + "</PDBx:taum>\n");
			if (zeta != null) ow.write(indent + " <PDBx:zeta>" + zeta + "</PDBx:zeta>\n");
			ow.write(indent + "</PDBx:struct_mon_nucl>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
