package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_MON_PROT_CIS category identify
 *  monomers that have been found to have the peptide bond in the cis
 *  conformation. The criterion used to select residues to be
 *  designated as containing cis peptide bonds is given in
 *  attribute prot_cis in category struct_mon_details.
 *  
 * <pre>
 *  Example 1 - based on PDB structure 1ACY of Ghiara, Stura, Stanfield,
 *  Profy & Wilson [Science (1994),  264,  82-85].
 *  <PDBx:struct_mon_prot_cisCategory>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="8" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="77" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="95" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  <PDBx:struct_mon_prot_cis label_comp_id="PRO" label_seq_id="141" label_asym_id="L" label_alt_id="" pdbx_PDB_model_num="1"></PDBx:struct_mon_prot_cis>
 *  </PDBx:struct_mon_prot_cisCategory>
 * </pre>
 */
public class Struct_mon_prot_cis extends org.pdb.beans.Struct_mon_prot_cis implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_mon_prot_cis";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_mon_prot_cis()
	{
	}

	/** Full constructor */
	public Struct_mon_prot_cis(
		Datablock datablock,
		java.lang.String auth_asym_id,
		java.lang.String auth_comp_id,
		java.lang.String auth_seq_id,
		java.lang.String label_alt_id,
		java.lang.String label_asym_id,
		java.lang.String label_comp_id,
		java.lang.Integer label_seq_id,
		java.lang.String pdbx_PDB_ins_code,
		java.lang.String pdbx_PDB_ins_code_2,
		java.lang.Integer pdbx_PDB_model_num,
		java.lang.String pdbx_auth_asym_id_2,
		java.lang.String pdbx_auth_comp_id_2,
		java.lang.String pdbx_auth_seq_id_2,
		java.lang.String pdbx_id,
		java.lang.String pdbx_label_asym_id_2,
		java.lang.String pdbx_label_comp_id_2,
		java.lang.Integer pdbx_label_seq_id_2,
		java.lang.String pdbx_omega_angle)
	{
		this.datablock = datablock;
		this.auth_asym_id = auth_asym_id;
		this.auth_comp_id = auth_comp_id;
		this.auth_seq_id = auth_seq_id;
		this.label_alt_id = label_alt_id;
		this.label_asym_id = label_asym_id;
		this.label_comp_id = label_comp_id;
		this.label_seq_id = label_seq_id;
		this.pdbx_PDB_ins_code = pdbx_PDB_ins_code;
		this.pdbx_PDB_ins_code_2 = pdbx_PDB_ins_code_2;
		this.pdbx_PDB_model_num = pdbx_PDB_model_num;
		this.pdbx_auth_asym_id_2 = pdbx_auth_asym_id_2;
		this.pdbx_auth_comp_id_2 = pdbx_auth_comp_id_2;
		this.pdbx_auth_seq_id_2 = pdbx_auth_seq_id_2;
		this.pdbx_id = pdbx_id;
		this.pdbx_label_asym_id_2 = pdbx_label_asym_id_2;
		this.pdbx_label_comp_id_2 = pdbx_label_comp_id_2;
		this.pdbx_label_seq_id_2 = pdbx_label_seq_id_2;
		this.pdbx_omega_angle = pdbx_omega_angle;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_mon_prot_cis");
		sb.append("\n");
		if (auth_asym_id != null)
		{
			sb.append("auth_asym_id = ");
			sb.append(auth_asym_id);
			sb.append('\n');
		}
		if (auth_comp_id != null)
		{
			sb.append("auth_comp_id = ");
			sb.append(auth_comp_id);
			sb.append('\n');
		}
		if (auth_seq_id != null)
		{
			sb.append("auth_seq_id = ");
			sb.append(auth_seq_id);
			sb.append('\n');
		}
		if (label_alt_id != null)
		{
			sb.append("label_alt_id = ");
			sb.append(label_alt_id);
			sb.append('\n');
		}
		if (label_asym_id != null)
		{
			sb.append("label_asym_id = ");
			sb.append(label_asym_id);
			sb.append('\n');
		}
		if (label_comp_id != null)
		{
			sb.append("label_comp_id = ");
			sb.append(label_comp_id);
			sb.append('\n');
		}
		if (label_seq_id != null)
		{
			sb.append("label_seq_id = ");
			sb.append(label_seq_id);
			sb.append('\n');
		}
		if (pdbx_PDB_ins_code != null)
		{
			sb.append("pdbx_PDB_ins_code = ");
			sb.append(pdbx_PDB_ins_code);
			sb.append('\n');
		}
		if (pdbx_PDB_ins_code_2 != null)
		{
			sb.append("pdbx_PDB_ins_code_2 = ");
			sb.append(pdbx_PDB_ins_code_2);
			sb.append('\n');
		}
		if (pdbx_PDB_model_num != null)
		{
			sb.append("pdbx_PDB_model_num = ");
			sb.append(pdbx_PDB_model_num);
			sb.append('\n');
		}
		if (pdbx_auth_asym_id_2 != null)
		{
			sb.append("pdbx_auth_asym_id_2 = ");
			sb.append(pdbx_auth_asym_id_2);
			sb.append('\n');
		}
		if (pdbx_auth_comp_id_2 != null)
		{
			sb.append("pdbx_auth_comp_id_2 = ");
			sb.append(pdbx_auth_comp_id_2);
			sb.append('\n');
		}
		if (pdbx_auth_seq_id_2 != null)
		{
			sb.append("pdbx_auth_seq_id_2 = ");
			sb.append(pdbx_auth_seq_id_2);
			sb.append('\n');
		}
		if (pdbx_id != null)
		{
			sb.append("pdbx_id = ");
			sb.append(pdbx_id);
			sb.append('\n');
		}
		if (pdbx_label_asym_id_2 != null)
		{
			sb.append("pdbx_label_asym_id_2 = ");
			sb.append(pdbx_label_asym_id_2);
			sb.append('\n');
		}
		if (pdbx_label_comp_id_2 != null)
		{
			sb.append("pdbx_label_comp_id_2 = ");
			sb.append(pdbx_label_comp_id_2);
			sb.append('\n');
		}
		if (pdbx_label_seq_id_2 != null)
		{
			sb.append("pdbx_label_seq_id_2 = ");
			sb.append(pdbx_label_seq_id_2);
			sb.append('\n');
		}
		if (pdbx_omega_angle != null)
		{
			sb.append("pdbx_omega_angle = ");
			sb.append(pdbx_omega_angle);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		auth_asym_id = null;
		auth_comp_id = null;
		auth_seq_id = null;
		label_alt_id = null;
		label_asym_id = null;
		label_comp_id = null;
		label_seq_id = null;
		pdbx_PDB_ins_code = null;
		pdbx_PDB_ins_code_2 = null;
		pdbx_PDB_model_num = null;
		pdbx_auth_asym_id_2 = null;
		pdbx_auth_comp_id_2 = null;
		pdbx_auth_seq_id_2 = null;
		pdbx_id = null;
		pdbx_label_asym_id_2 = null;
		pdbx_label_comp_id_2 = null;
		pdbx_label_seq_id_2 = null;
		pdbx_omega_angle = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_mon_prot_cis)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_mon_prot_cis>\n");
			if (auth_asym_id != null) ow.write(indent + " <PDBx:auth_asym_id>" + auth_asym_id + "</PDBx:auth_asym_id>\n");
			if (auth_comp_id != null) ow.write(indent + " <PDBx:auth_comp_id>" + auth_comp_id + "</PDBx:auth_comp_id>\n");
			if (auth_seq_id != null) ow.write(indent + " <PDBx:auth_seq_id>" + auth_seq_id + "</PDBx:auth_seq_id>\n");
			if (label_alt_id != null) ow.write(indent + " <PDBx:label_alt_id>" + label_alt_id + "</PDBx:label_alt_id>\n");
			if (label_asym_id != null) ow.write(indent + " <PDBx:label_asym_id>" + label_asym_id + "</PDBx:label_asym_id>\n");
			if (label_comp_id != null) ow.write(indent + " <PDBx:label_comp_id>" + label_comp_id + "</PDBx:label_comp_id>\n");
			if (label_seq_id != null) ow.write(indent + " <PDBx:label_seq_id>" + label_seq_id + "</PDBx:label_seq_id>\n");
			if (pdbx_PDB_ins_code != null) ow.write(indent + " <PDBx:pdbx_PDB_ins_code>" + pdbx_PDB_ins_code + "</PDBx:pdbx_PDB_ins_code>\n");
			if (pdbx_PDB_ins_code_2 != null) ow.write(indent + " <PDBx:pdbx_PDB_ins_code_2>" + pdbx_PDB_ins_code_2 + "</PDBx:pdbx_PDB_ins_code_2>\n");
			if (pdbx_PDB_model_num != null) ow.write(indent + " <PDBx:pdbx_PDB_model_num>" + pdbx_PDB_model_num + "</PDBx:pdbx_PDB_model_num>\n");
			if (pdbx_auth_asym_id_2 != null) ow.write(indent + " <PDBx:pdbx_auth_asym_id_2>" + pdbx_auth_asym_id_2 + "</PDBx:pdbx_auth_asym_id_2>\n");
			if (pdbx_auth_comp_id_2 != null) ow.write(indent + " <PDBx:pdbx_auth_comp_id_2>" + pdbx_auth_comp_id_2 + "</PDBx:pdbx_auth_comp_id_2>\n");
			if (pdbx_auth_seq_id_2 != null) ow.write(indent + " <PDBx:pdbx_auth_seq_id_2>" + pdbx_auth_seq_id_2 + "</PDBx:pdbx_auth_seq_id_2>\n");
			if (pdbx_id != null) ow.write(indent + " <PDBx:pdbx_id>" + pdbx_id + "</PDBx:pdbx_id>\n");
			if (pdbx_label_asym_id_2 != null) ow.write(indent + " <PDBx:pdbx_label_asym_id_2>" + pdbx_label_asym_id_2 + "</PDBx:pdbx_label_asym_id_2>\n");
			if (pdbx_label_comp_id_2 != null) ow.write(indent + " <PDBx:pdbx_label_comp_id_2>" + pdbx_label_comp_id_2 + "</PDBx:pdbx_label_comp_id_2>\n");
			if (pdbx_label_seq_id_2 != null) ow.write(indent + " <PDBx:pdbx_label_seq_id_2>" + pdbx_label_seq_id_2 + "</PDBx:pdbx_label_seq_id_2>\n");
			if (pdbx_omega_angle != null) ow.write(indent + " <PDBx:pdbx_omega_angle>" + pdbx_omega_angle + "</PDBx:pdbx_omega_angle>\n");
			ow.write(indent + "</PDBx:struct_mon_prot_cis>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
