package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_NCS_DOM category record information
 *  about the domains in an ensemble of domains related by one or
 *  more noncrystallographic symmetry operators.
 *  
 *  A domain need not correspond to a complete polypeptide chain;
 *  it can be composed of one or more segments in a single chain,
 *  or by segments from more than one chain.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_domCategory>
 *  <PDBx:struct_ncs_dom id="d1">
 *  <PDBx:details>Chains A, B, and C</PDBx:details>
 *  </PDBx:struct_ncs_dom>
 *  <PDBx:struct_ncs_dom id="d2">
 *  <PDBx:details>Chains D, E, and F</PDBx:details>
 *  </PDBx:struct_ncs_dom>
 *  </PDBx:struct_ncs_domCategory>
 * </pre>
 */
public class Struct_ncs_dom extends org.pdb.beans.Struct_ncs_dom implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ncs_dom";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ncs_dom()
	{
	}

	/** Full constructor */
	public Struct_ncs_dom(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ncs_dom");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ncs_dom)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ncs_dom>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			ow.write(indent + "</PDBx:struct_ncs_dom>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
